/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.oauth;

import com.oxygenxml.webapp.sharepoint.oauth.OAuthSession;
import com.oxygenxml.webapp.sharepoint.oauth.Session;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public final class SessionsManager {
    private static final Logger log = LoggerFactory.getLogger(SessionsManager.class);
    public static final String SHAREPOINT_SESSION_KEY = "sharepoint.session";
    private static SessionsManager instance;
    private static File testingSessionFile;
    private final boolean duringTests;

    public static void setTestingSessionLocation(File webAuthorTempDIr) {
        testingSessionFile = new File(webAuthorTempDIr, "sp-testing-session");
    }

    public static synchronized SessionsManager getInstance() {
        if (instance == null) {
            instance = new SessionsManager();
        }
        return instance;
    }

    private SessionsManager() {
        String e2eTestsEnabled = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("sp.e2et.enabled", null);
        this.duringTests = "true".equals(e2eTestsEnabled);
    }

    public Session getSession(String sessionID) {
        SessionStore sessionStore = SessionsManager.getSessionStore();
        Session session = (Session)sessionStore.get(sessionID, SHAREPOINT_SESSION_KEY);
        if (this.duringTests && session == null && (session = SessionsManager.getTestDummySession()) != null) {
            sessionStore.put(sessionID, SHAREPOINT_SESSION_KEY, (Object)session);
        }
        return session;
    }

    private static Session getTestDummySession() {
        OAuthSession session = null;
        if (testingSessionFile.exists()) {
            try {
                byte[] tokenBytes = Files.readAllBytes(testingSessionFile.toPath());
                Files.delete(testingSessionFile.toPath());
                session = OAuthSession.createForTests(new String(tokenBytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return session;
    }

    public static void registerSession(String sessionID, Session session) {
        SessionsManager.getSessionStore().put(sessionID, SHAREPOINT_SESSION_KEY, (Object)session);
    }

    public static void unregisterSession(String sessionID) {
        SessionsManager.getSessionStore().remove(sessionID, SHAREPOINT_SESSION_KEY);
    }

    public static SessionStore getSessionStore() {
        return ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getSessionStore();
    }
}

