/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.oauth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.sharepoint.config.AppConfiguration;
import com.oxygenxml.webapp.sharepoint.oauth.Session;
import com.oxygenxml.webapp.sharepoint.oauth.SessionsManager;
import com.oxygenxml.webapp.sharepoint.oauth.SiteDescriptor;
import com.oxygenxml.webapp.sharepoint.oauth.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletConfig;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class SessionServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(SessionServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        File tempDir = (File)config.getServletContext().getAttribute("OXYGEN_WEBAPP_DATA_DIR");
        SessionsManager.setTestingSessionLocation(tempDir);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SessionInfoResponse respContent = new SessionInfoResponse();
        respContent.isConfigured = AppConfiguration.getInstance().isConfigured();
        String sessionId = req.getSession().getId();
        Session session = SessionsManager.getInstance().getSession(sessionId);
        if (session != null) {
            respContent.isConfigured = true;
            respContent.isAuthenticated = session.isAuthenticated();
            respContent.siteUrls = session.getSites().stream().map(SiteDescriptor::getWebUrl).collect(Collectors.toList());
            respContent.userInfo = session.getUserInfo();
            if (log.isDebugEnabled() && respContent.userInfo != null) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = respContent.userInfo::getName;
                supplierArray[1] = respContent.userInfo::getObjectIdentifier;
                supplierArray[2] = respContent.userInfo::getPrincipalName;
                log.debug("\n[SP.USER.INFO]: {\n  name: {}\n  oid: {}\n  upn: {}\n}", supplierArray);
            }
        } else {
            respContent.isAuthenticated = false;
        }
        resp.setContentType("application/json");
        resp.setStatus(200);
        ObjectMapper mapper = new ObjectMapper();
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        mapper.writeValue((Writer)resp.getWriter(), (Object)respContent);
        resp.flushBuffer();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getSession().getId();
        SessionsManager.unregisterSession(sessionId);
        resp.setStatus(200);
    }

    public String getPath() {
        return "sp-session";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class SessionInfoResponse {
        @JsonProperty(value="isConfigured")
        private boolean isConfigured;
        @JsonProperty(value="isAuth")
        private boolean isAuthenticated;
        @JsonProperty(value="siteUrls")
        private List<String> siteUrls;
        @JsonProperty(value="user")
        private UserInfo userInfo;

        private SessionInfoResponse() {
        }

        public String toString() {
            return new StringBuilder(101).append("SessionInfoResponse [\n    isConfigured=").append(this.isConfigured).append(",\n    isAuthenticated=").append(this.isAuthenticated).append(",\n    resourceIds=").append(this.siteUrls).append(",\n    userInfo=").append(this.userInfo).append("\n]").toString();
        }
    }
}

