/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.oauth;

import com.oxygenxml.webapp.sharepoint.oauth.AbstractSession;
import com.oxygenxml.webapp.sharepoint.oauth.AccessToken;
import com.oxygenxml.webapp.sharepoint.oauth.AccessTokenSupplier;
import com.oxygenxml.webapp.sharepoint.oauth.GrantType;
import com.oxygenxml.webapp.sharepoint.oauth.SiteCollection;
import com.oxygenxml.webapp.sharepoint.oauth.SiteDescriptor;
import com.oxygenxml.webapp.sharepoint.rest.JsonRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.testing.ResourceAccessTokensSupplier;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthSession
extends AbstractSession {
    private static final Logger log = LoggerFactory.getLogger(OAuthSession.class);
    public static final String DISCOVERY_RESOURCE_ID = "https://graph.microsoft.com";
    public static final String DISCOVERY_ENDPOINT = "https://graph.microsoft.com/v1.0/sites?search=*";
    private AccessToken discoveryAccessToken;
    private final AccessTokenSupplier tokenSupplier = new AccessTokenSupplier();
    private Map<String, AccessToken> resourceAccessTokens = new HashMap<String, AccessToken>();
    private final List<SiteDescriptor> sites = new ArrayList<SiteDescriptor>();

    public static OAuthSession createForTests(String refreshToken) throws IOException {
        OAuthSession session = new OAuthSession();
        session.discoveryAccessToken = session.tokenSupplier.acquireToken(DISCOVERY_RESOURCE_ID, refreshToken, GrantType.REFRESH_TOKEN);
        session.resourceAccessTokens = new ResourceAccessTokensSupplier(refreshToken);
        session.discoverResources();
        return session;
    }

    public void authorizeSession(String authorizationCode) {
        this.acquireDiscoveryAccessToken(authorizationCode);
        this.discoverResources();
    }

    private void acquireDiscoveryAccessToken(String authorizationCode) {
        try {
            this.discoveryAccessToken = this.tokenSupplier.acquireToken(DISCOVERY_RESOURCE_ID, authorizationCode, GrantType.AUTHORIZATION_CODE);
        }
        catch (IOException io) {
            log.warn("Error retrieving token for site discovery", (Throwable)io);
        }
    }

    private void discoverResources() {
        try {
            JsonRestRequest<SiteCollection> request;
            SiteCollection siteCollection;
            if (this.discoveryAccessToken != null && (siteCollection = (SiteCollection)(request = new JsonRestRequest<SiteCollection>(new RestURLStreamProvider(new URL(DISCOVERY_ENDPOINT), this.discoveryAccessToken.getAccessToken()), SiteCollection.class)).get()) != null) {
                for (SiteDescriptor site : siteCollection.getServices()) {
                    this.resourceAccessTokens.put(site.getServiceResourceId(), null);
                    this.sites.add(site);
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    @Override
    public Set<String> getAvailableServiceResourceIDs() {
        return this.resourceAccessTokens.keySet();
    }

    @Override
    public List<SiteDescriptor> getSites() {
        return this.sites;
    }

    @Override
    public boolean isAuthenticated() {
        return this.discoveryAccessToken != null;
    }

    private String getResourceIdForURL(String url) {
        Object resourceID = null;
        Set<String> availableServiceResourceIDs = this.getAvailableServiceResourceIDs();
        for (String id : availableServiceResourceIDs) {
            if (!url.startsWith(id)) continue;
            resourceID = id;
            break;
        }
        if (resourceID == null) {
            try {
                URL u = new URL(url);
                resourceID = u.getProtocol() + "://" + u.getHost();
                log.warn("Could not discover a resource ID for URL: {}", (Object)url);
                log.warn("Using the URL's host as resource ID: {}", resourceID);
            }
            catch (MalformedURLException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        return resourceID;
    }

    @Override
    public String getAccessToken(String url) {
        AccessToken accessToken = this.getResourceAccessToken(url);
        return accessToken != null ? accessToken.getAccessToken() : null;
    }

    private AccessToken getResourceAccessToken(String url) {
        AccessToken token = null;
        String serviceResourceId = this.getResourceIdForURL(url);
        if (serviceResourceId != null) {
            token = this.resourceAccessTokens.get(serviceResourceId);
            if (token == null) {
                try {
                    token = this.tokenSupplier.acquireToken(serviceResourceId, this.discoveryAccessToken.getRefreshToken(), GrantType.REFRESH_TOKEN);
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = token::getRefreshToken;
                    log.debug("\n[SP.REFRESH.TOKEN]: {}", supplierArray);
                    this.resourceAccessTokens.put(serviceResourceId, token);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                AccessToken newToken;
                boolean expired = OAuthSession.checkIfExpired(token);
                if (expired && (newToken = this.refresh(token)) != null) {
                    token = newToken;
                    this.resourceAccessTokens.put(serviceResourceId, token);
                }
            }
        }
        return token;
    }

    private AccessToken refresh(AccessToken token) {
        AccessToken newToken = null;
        String resourceID = token.getResource();
        String refreshToken = token.getRefreshToken();
        try {
            newToken = this.tokenSupplier.acquireToken(resourceID, refreshToken, GrantType.REFRESH_TOKEN);
        }
        catch (IOException e) {
            log.error("Error refreshing token", (Throwable)e);
        }
        return newToken;
    }

    private static boolean checkIfExpired(AccessToken accessToken) {
        boolean expired = false;
        try {
            long expLong = Long.parseLong(accessToken.getExpiresOn()) * 1000L;
            expired = expLong - System.currentTimeMillis() <= 0L;
        }
        catch (NumberFormatException e) {
            log.error((Object)e, (Throwable)e);
        }
        return expired;
    }

    @Override
    protected String getUserInfoToken() {
        return this.discoveryAccessToken != null ? this.discoveryAccessToken.getIdToken() : null;
    }
}

