/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.oauth;

import com.oxygenxml.webapp.sharepoint.config.AppConfiguration;
import com.oxygenxml.webapp.sharepoint.oauth.OAuthSession;
import com.oxygenxml.webapp.sharepoint.oauth.SessionsManager;
import com.oxygenxml.webapp.sharepoint.oauth.SimpleSession;
import java.io.IOException;
import java.text.MessageFormat;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class OAuthServlet
extends ServletPluginExtension {
    private static final String APP_DASHBOARD_URL = "../app/oxygen.html";
    static final String OAUTH_URL_PATTERN = "{0}?response_type=code&client_id={1}&redirect_uri={2}&state={3}";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String state = req.getParameter("state");
        if (state == null) {
            state = APP_DASHBOARD_URL;
        }
        if (req.getParameter("init") != null) {
            resp.sendRedirect(OAuthServlet.getOAuthUrl(state));
        } else {
            String sessionID = req.getSession().getId();
            String authorizationCode = req.getParameter("code");
            if (authorizationCode != null) {
                OAuthSession session = new OAuthSession();
                session.authorizeSession(authorizationCode);
                SessionsManager.registerSession(sessionID, session);
                resp.sendRedirect(state);
            }
        }
    }

    private static String getOAuthUrl(String state) {
        AppConfiguration config = AppConfiguration.getInstance();
        return MessageFormat.format(OAUTH_URL_PATTERN, AppConfiguration.getAuthorizationEndPoint(), URLUtil.encodeURIComponent((String)config.getClientId()), URLUtil.encodeURIComponent((String)config.getRedirectUrl()), URLUtil.encodeURIComponent((String)state));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionID = req.getSession().getId();
        String providedAccessToken = req.getParameter("token");
        SimpleSession session = new SimpleSession(providedAccessToken);
        SessionsManager.registerSession(sessionID, session);
    }

    public String getPath() {
        return "sp-oauth";
    }
}

