/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.sharepoint.config.AppConfiguration;
import com.oxygenxml.webapp.sharepoint.oauth.AccessToken;
import com.oxygenxml.webapp.sharepoint.oauth.GrantType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.QuietClosable;
import ro.sync.basic.util.URLUtil;

public class AccessTokenSupplier {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenSupplier.class);
    public static final String AUTHORIZATION_EDNPOINT = "https://login.microsoftonline.com/common/oauth2/token";
    public static final String AUTH_CODE_ACCESS_TOKEN_REQUEST_BODY_PATTERN = "grant_type={0}&client_id={1}&{2}={3}&redirect_uri={4}&resource={5}&client_secret={6}";

    public AccessToken acquireToken(String resourceID, String code, GrantType grantType) throws IOException {
        HttpURLConnection connection = AccessTokenSupplier.openConnection();
        try (OutputStream outputStream = connection.getOutputStream();){
            byte[] requestBody = this.getRequestBody(resourceID, code, grantType);
            outputStream.write(requestBody);
        }
        catch (IOException e) {
            log.error("Error message from server " + this.readAsUtf8String(connection.getErrorStream()));
            throw e;
        }
        String tokenString = this.readAsUtf8String(connection.getInputStream());
        AccessToken token = null;
        try {
            token = (AccessToken)new ObjectMapper().readValue(tokenString, AccessToken.class);
            token.encryptRefreshToken();
        }
        catch (IOException e) {
            log.error(() -> "Error parsing token: " + tokenString, (Throwable)e);
            throw e;
        }
        return token;
    }

    private String readAsUtf8String(InputStream inputStream2) throws IOException {
        String resultString;
        try (InputStream inputStream = inputStream2;
             Reader isReader = QuietClosable.from((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            resultString = IOUtils.toString((Reader)isReader);
        }
        return resultString;
    }

    private static HttpURLConnection openConnection() throws IOException {
        URL authUrl = new URL(AUTHORIZATION_EDNPOINT);
        HttpURLConnection connection = (HttpURLConnection)authUrl.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        return connection;
    }

    byte[] getRequestBody(String resourceID, String code, GrantType grantType) {
        AppConfiguration appConfig = AppConfiguration.getInstance();
        String body = MessageFormat.format(AUTH_CODE_ACCESS_TOKEN_REQUEST_BODY_PATTERN, URLUtil.encodeURIComponent((String)grantType.getId()), URLUtil.encodeURIComponent((String)appConfig.getClientId()), URLUtil.encodeURIComponent((String)grantType.getCodeParamName()), URLUtil.encodeURIComponent((String)code), URLUtil.encodeURIComponent((String)appConfig.getRedirectUrl()), URLUtil.encodeURIComponent((String)resourceID), URLUtil.encodeURIComponent((String)appConfig.getClientSecret()));
        return body.getBytes();
    }
}

