/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.oauth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken {
    @JsonProperty(value="access_token")
    private final String accessToken;
    @JsonProperty(value="expires_in")
    private final String expiresIn;
    @JsonProperty(value="expires_on")
    private String expiresOn;
    @JsonProperty(value="id_token")
    private String idToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="resource")
    private String resource;
    @JsonProperty(value="scope")
    private final String scope;
    @JsonProperty(value="token_type")
    private final String tokenType;
    @JsonProperty(value="not_before")
    private final String notBefore;

    public AccessToken() {
        this.accessToken = null;
        this.expiresIn = null;
        this.scope = null;
        this.tokenType = null;
        this.notBefore = null;
    }

    public AccessToken(String resourceId, String refreshToken, String expiresOn, String idToken) {
        this.accessToken = null;
        this.expiresIn = null;
        this.scope = null;
        this.tokenType = null;
        this.notBefore = null;
        this.resource = resourceId;
        this.refreshToken = refreshToken;
        if (refreshToken != null) {
            this.encryptRefreshToken();
        }
        this.expiresOn = expiresOn;
        this.idToken = idToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public String getExpiresOn() {
        return this.expiresOn;
    }

    public String getIdToken() {
        return this.idToken;
    }

    void encryptRefreshToken() {
        this.refreshToken = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(this.refreshToken);
    }

    public String getRefreshToken() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(this.refreshToken);
    }

    public String getResource() {
        return this.resource;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public String toString() {
        return new StringBuilder(165).append("AccessToken [\n  accessToken=").append(this.accessToken).append(",\n   expiresIn=").append(this.expiresIn).append(",\n   expiresOn=").append(this.expiresOn).append(",\n   idToken=").append(this.idToken).append(",\n   encryptedRefreshToken=").append(this.refreshToken).append(",\n   resource=").append(this.resource).append(",\n   scope=").append(this.scope).append(",\n   tokenType=").append(this.tokenType).append(",\n   notBefore=").append(this.notBefore).append("\n]").toString();
    }
}

