/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.filehandler;

import com.oxygenxml.webapp.sharepoint.filehandler.FileHandlerFileCache;
import com.oxygenxml.webapp.sharepoint.filehandler.FileInfo;
import com.oxygenxml.webapp.sharepoint.oauth.Session;
import com.oxygenxml.webapp.sharepoint.oauth.SessionsManager;
import com.oxygenxml.webapp.sharepoint.rest.JsonRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.rest.RestUrlPattern;
import com.oxygenxml.webapp.sharepoint.rest.RestUtil;
import com.oxygenxml.webapp.sharepoint.rest.response.files.SpFile;
import java.io.IOException;
import java.net.URL;

public final class FileHandlerUtil {
    private FileHandlerUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getFileRealURL(String fileHandlerUrl, String sessionId) throws IOException {
        String realURL = null;
        FileInfo fileInfo = FileHandlerFileCache.getFileInfo(sessionId, fileHandlerUrl);
        if (fileInfo != null) {
            String serverRelativeUrl;
            String webUrl;
            String accessToken;
            String fileId = fileInfo.getFileId();
            Session session = SessionsManager.getInstance().getSession(sessionId);
            if (session != null && (accessToken = session.getAccessToken(fileHandlerUrl)) != null && (webUrl = FileHandlerUtil.getWebURL(fileHandlerUrl, accessToken)) != null && (serverRelativeUrl = FileHandlerUtil.getFileServerRelativeURL(fileId, webUrl, accessToken)) != null) {
                realURL = RestUtil.getAbsoluteURLFromServerRelativeURL(new URL(webUrl).getHost(), serverRelativeUrl);
            }
        }
        return realURL;
    }

    public static String getFileServerRelativeURL(String fileID, String webURL, String accessToken) throws IOException {
        String serverRelativeUrl = null;
        URL restURL = RestUrlPattern.GET_FILE_BY_ID.getRestUrl(webURL, fileID);
        JsonRestRequest<SpFile> restRequest = new JsonRestRequest<SpFile>(new RestURLStreamProvider(restURL, accessToken), SpFile.class);
        SpFile spFile = (SpFile)restRequest.get();
        if (spFile != null) {
            serverRelativeUrl = spFile.serverRelativeUrl;
        }
        return serverRelativeUrl;
    }

    public static String getWebURL(String fileGetUrl, String accessToken) throws IOException {
        int endIndex;
        String webUrl = null;
        if (fileGetUrl != null && (endIndex = fileGetUrl.indexOf("/_vti_bin")) != -1) {
            String prefixUrl = fileGetUrl.substring(0, endIndex);
            webUrl = RestUtil.getWebUrl(prefixUrl, accessToken);
        }
        return webUrl;
    }
}

