/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.filehandler;

import com.oxygenxml.webapp.sharepoint.SPUrlUtil;
import com.oxygenxml.webapp.sharepoint.filehandler.FileHandlerFileCache;
import com.oxygenxml.webapp.sharepoint.filehandler.FileHandlerParams;
import com.oxygenxml.webapp.sharepoint.filehandler.FileInfo;
import com.oxygenxml.webapp.sharepoint.rest.RestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletInputStream;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class FileHandlerServlet
extends ServletPluginExtension
implements FileHandlerParams {
    private static final String OPEN_REDIRECT_LOCATION_PATTERN = "../app/oxygen.html?url=spo-{0}";
    private static final String PREVIEW_REDIRECT_LOCATION_PATTERN = "../app/oxygen.html?url=spo-{0}&preview=true&modes=review";

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getSession().getId();
        ServletInputStream inputStream = req.getInputStream();
        StringBuilder requestContent = RestUtil.readIs((InputStream)inputStream);
        Map<String, String> queryMap = SPUrlUtil.parseUrlQuery(requestContent.toString());
        FileInfo info = new FileInfo(queryMap.get("fileget"), queryMap.get("fileput"), queryMap.get("fileid"), queryMap.get("resourceid"));
        FileHandlerFileCache.setFileInfo(sessionId, info);
        String pattern = "preview".equalsIgnoreCase(req.getParameter("mode")) ? PREVIEW_REDIRECT_LOCATION_PATTERN : OPEN_REDIRECT_LOCATION_PATTERN;
        String location = MessageFormat.format(pattern, URLUtil.encodeURIComponent((String)info.getFileGet()));
        resp.sendRedirect(location);
    }

    public String getPath() {
        return "sp-filehandler";
    }
}

