/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.filehandler;

import com.oxygenxml.webapp.sharepoint.filehandler.FileInfo;
import java.util.HashMap;
import java.util.Map;

public final class FileHandlerFileCache {
    private static final Map<String, SessionFileCache> FILE_CACHE = new HashMap<String, SessionFileCache>();

    private FileHandlerFileCache() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static FileInfo getFileInfo(String sessionID, String url) {
        return FILE_CACHE.computeIfAbsent(sessionID, sessionIDKey -> new SessionFileCache()).getFileInfo(url);
    }

    public static void setFileInfo(String sessionID, FileInfo fileInfo) {
        FILE_CACHE.computeIfAbsent(sessionID, sessionIDKey -> new SessionFileCache()).updateFileInfo(fileInfo.getFileGet(), fileInfo);
    }

    private static class SessionFileCache {
        final Map<String, FileInfo> cachedFiles = new HashMap<String, FileInfo>();

        private SessionFileCache() {
        }

        FileInfo getFileInfo(String fileUrl) {
            return this.cachedFiles.get(fileUrl);
        }

        void updateFileInfo(String fileUrl, FileInfo info) {
            this.cachedFiles.put(fileUrl, info);
        }
    }
}

