/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.filebrowser;

import com.oxygenxml.webapp.sharepoint.URLUtils;
import com.oxygenxml.webapp.sharepoint.rest.JsonRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.rest.RestUrlPattern;
import com.oxygenxml.webapp.sharepoint.rest.RestUtil;
import com.oxygenxml.webapp.sharepoint.rest.XMLRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.response.feed.EntryNode;
import com.oxygenxml.webapp.sharepoint.rest.response.feed.FeedNode;
import com.oxygenxml.webapp.sharepoint.rest.response.feed.PropertiesNode;
import com.oxygenxml.webapp.sharepoint.rest.response.lists.GetsListsResult;
import com.oxygenxml.webapp.sharepoint.rest.response.lists.SpList;
import com.oxygenxml.webapp.sharepoint.rest.response.lists.SpListItem;
import com.oxygenxml.webapp.sharepoint.rest.response.webs.GetsWebsResult;
import com.oxygenxml.webapp.sharepoint.rest.response.webs.SpWeb;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ro.sync.basic.util.URLUtil;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class ChildrenRetriever {
    private final String token;
    private final URL url;

    public ChildrenRetriever(URL url, String token) {
        this.url = url;
        this.token = token;
    }

    public List<FolderEntryDescriptor> getChildren() throws IOException {
        ArrayList<FolderEntryDescriptor> children = new ArrayList<FolderEntryDescriptor>();
        String webUrl = RestUtil.getWebUrl(this.url.toString(), this.token);
        if (webUrl != null) {
            boolean isWeb = ChildrenRetriever.sameURL(webUrl, this.url);
            if (isWeb) {
                this.listWebResources(webUrl, children);
            } else {
                this.listFolder(webUrl, children);
            }
        }
        return children;
    }

    private void listWebResources(String webUrl, List<FolderEntryDescriptor> children) throws IOException {
        List<SpList> lists;
        URL getListsUrl;
        RestURLStreamProvider listsStreamProvider;
        JsonRestRequest<GetsListsResult> listsRestReq;
        GetsListsResult getsListsResult;
        List<SpWeb> webs;
        URL getWebsUrl = RestUrlPattern.GET_WEBS.getRestUrl(webUrl);
        RestURLStreamProvider websStreamProvider = new RestURLStreamProvider(getWebsUrl, this.token);
        JsonRestRequest<GetsWebsResult> websRestReq = new JsonRestRequest<GetsWebsResult>(websStreamProvider, GetsWebsResult.class);
        GetsWebsResult getWebsResult = (GetsWebsResult)websRestReq.get();
        if (getWebsResult != null && (webs = getWebsResult.getWebs()) != null) {
            for (SpWeb spWeb : webs) {
                String spWebUrl = spWeb.getUrl();
                if (spWebUrl == null) continue;
                spWebUrl = URLUtils.ensureLastSlash(spWebUrl);
                children.add(new FolderEntryDescriptor(URLUtil.correct((String)spWebUrl, (boolean)false)));
            }
        }
        if ((getsListsResult = (GetsListsResult)(listsRestReq = new JsonRestRequest<GetsListsResult>(listsStreamProvider = new RestURLStreamProvider(getListsUrl = RestUrlPattern.GET_LISTS_INCLUDING_ROOT_FOLDER.getRestUrl(webUrl), this.token), GetsListsResult.class)).get()) != null && (lists = getsListsResult.getLists()) != null) {
            for (SpList spList : lists) {
                String serverRelativeUrl;
                SpListItem rootFolder = spList.getRootFolder();
                if (rootFolder == null || (serverRelativeUrl = rootFolder.getServerRelativeUrl()) == null) continue;
                children.add(this.getFolderEntryDescriptor(true, serverRelativeUrl));
            }
        }
    }

    private void listFolder(String webUrl, List<FolderEntryDescriptor> children) throws IOException {
        URL listFilesURL;
        RestURLStreamProvider filesProvider;
        XMLRestRequest<FeedNode> filesRestRequest;
        FeedNode filesListing;
        String serververRelativePath = this.url.getPath();
        URL listFoldersURL = RestUrlPattern.LIST_FOLDERS.getRestUrl(webUrl, serververRelativePath);
        RestURLStreamProvider foldersProvider = new RestURLStreamProvider(listFoldersURL, this.token);
        XMLRestRequest<FeedNode> foldersRestRequest = new XMLRestRequest<FeedNode>(foldersProvider, FeedNode.class);
        FeedNode foldersListing = (FeedNode)foldersRestRequest.get();
        if (foldersListing != null) {
            List<EntryNode> entries = foldersListing.getEntries();
            for (EntryNode entry : entries) {
                FolderEntryDescriptor folderEntryDescriptor = this.getFolderEntryDescriptor(entry, true);
                if (folderEntryDescriptor == null) continue;
                children.add(folderEntryDescriptor);
            }
        }
        if ((filesListing = (FeedNode)(filesRestRequest = new XMLRestRequest<FeedNode>(filesProvider = new RestURLStreamProvider(listFilesURL = RestUrlPattern.LIST_FILES.getRestUrl(webUrl, serververRelativePath), this.token), FeedNode.class)).get()) != null) {
            List<EntryNode> entries = filesListing.getEntries();
            for (EntryNode entry : entries) {
                FolderEntryDescriptor folderEntryDescriptor = this.getFolderEntryDescriptor(entry, false);
                if (folderEntryDescriptor == null) continue;
                children.add(folderEntryDescriptor);
            }
        }
    }

    private static boolean sameURL(String webUrl, URL url) {
        String urlString = url.toString();
        urlString = URLUtils.ensureLastSlash(urlString);
        webUrl = URLUtils.ensureLastSlash(webUrl);
        return webUrl.equalsIgnoreCase(urlString);
    }

    private FolderEntryDescriptor getFolderEntryDescriptor(EntryNode entry, boolean isFolder) {
        String serverRelativeUrl;
        FolderEntryDescriptor descriptor = null;
        PropertiesNode properties = entry.getProperties();
        if (properties != null && (serverRelativeUrl = properties.getServerRelativeUrl()) != null) {
            descriptor = this.getFolderEntryDescriptor(isFolder, serverRelativeUrl);
        }
        return descriptor;
    }

    private FolderEntryDescriptor getFolderEntryDescriptor(boolean isFolder, String serverRelativeUrl) {
        if (isFolder) {
            serverRelativeUrl = (String)serverRelativeUrl + (((String)serverRelativeUrl).endsWith("/") ? "" : "/");
        }
        return new FolderEntryDescriptor(RestUtil.getAbsoluteURLFromServerRelativeURL(this.url.getHost(), (String)serverRelativeUrl));
    }
}

