/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.config;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.PluginConfigExtension;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class SharePointPluginConfigExtension
extends PluginConfigExtension {
    public static final String DEFAULT_AUTOSAVE_INTERVAL = "10";
    private static final String LABEL_STYLE = " style=\"margin-top:6px;display:block;overflow:hidden\"";
    private static final String INPUT_STYLE = " style=\"color:#606060;background-color:#FAFAFA;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;border-radius:4px;border:1px solid #C8C1C1;padding:6px 4px\"";

    public void init() throws ServletException {
        super.init();
        String defaultValue = "";
        this.setDefaultOptions((Map)ImmutableMap.of((Object)"sp-client-id", (Object)defaultValue, (Object)"sp-client-secret", (Object)defaultValue, (Object)"sp-redirect-url", (Object)defaultValue, (Object)"sp-autosave-interval", (Object)DEFAULT_AUTOSAVE_INTERVAL, (Object)"sp-anyone-can-check-in", (Object)"false"));
    }

    public String getPath() {
        return "sp-config";
    }

    public String getOptionsForm() {
        String clientId = this.getOption("sp-client-id", "");
        String clientSecret = this.getOption("sp-client-secret", "");
        String redirectUrl = this.getOption("sp-redirect-url", "");
        String autosaveInterval = this.getOption("sp-autosave-interval", DEFAULT_AUTOSAVE_INTERVAL);
        String anyoneCanCheckIn = this.getOption("sp-anyone-can-check-in", "false");
        anyoneCanCheckIn = "true".equals(anyoneCanCheckIn) ? "checked" : "";
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        return "<div style=\"font-family: robotolight, Arial, Helvetica, sans-serif;font-size:0.9em;font-weight: lighter;\">\n  <h3>" + rb.getMessage("Authentication_title") + "</h3>\n  <div style=\"color:#333;background-color: lightyellow;border: 1px solid #dadab4;padding:0 5px 0 5px\">\n    <p style=\"margin:4px 0\">" + rb.getMessage("Sharepoint_oauth") + "</p>\n    <p style=\"margin:4px 0\">" + MessageFormat.format(rb.getMessage("Go_to_Azure_Management"), "<a target=\"_blank\" href=\"https://portal.azure.com/\">", "</a>") + "</p>\n    <p style=\"margin:12px 0\"><b>" + rb.getMessage("Note") + "</b>: " + MessageFormat.format(rb.getMessage("Sharepoint_redirect_url_format"), "<tt>", "</tt>") + " <span style=\"display:block; margin-bottom:4px 0\"><tt><i>[Web-Author-URL]</i><b>/plugins-dispatcher/sp-oauth</b></tt></span>\n<span style=\"display:block;margin-top:4px\">" + rb.getMessage("Example") + ":<br>\n<tt>http://www.mydomain.com/oxygen-webapp/plugins-dispatcher/sp-oauth</tt></span>\n</p>\n    \n  </div>\n  <form style=\"text-align:left;line-height: 1.7em;font-weight:bold;color:#505050;\">\n    <table style=\"width:100%;margin-top:8px\">\n      <colgroup><col width=\"25%\">\n      <col width=\"75%\">\n      </colgroup><tbody>\n        <tr>\n          <td><label style=\"margin-top:6px;display:block;overflow:hidden\">" + rb.getMessage("Client_ID") + ": </label></td>\n          <td>\n            <input placeholder=\"" + rb.getMessage("Client_ID") + "\" name=\"sp-client-id\" type=\"text\" style=\"color:#606060;background-color:#FAFAFA;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;border-radius:4px;border:1px solid #C8C1C1;padding:6px 4px\" value=\"" + clientId + "\">\n          </td>\n        </tr>\n        <tr>\n          <td><label style=\"margin-top:6px;display:block;overflow:hidden\">" + rb.getMessage("Client_Secret") + ": </label></td>\n          <td>\n            <input placeholder=\"" + rb.getMessage("Client_Secret") + "\" name=\"sp-client-secret\" type=\"text\" style=\"color:#606060;background-color:#FAFAFA;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;border-radius:4px;border:1px solid #C8C1C1;padding:6px 4px\" value=\"" + clientSecret + "\">\n          </td>\n        </tr>\n        <tr>\n          <td><label style=\"margin-top:6px;display:block;overflow:hidden\">" + rb.getMessage("Redirect_URL") + ": </label></td>\n          <td>\n            <input placeholder=\"[Web-Author-URL]/plugins-dispatcher/sp-oauth\" name=\"sp-redirect-url\" type=\"url\" style=\"color:#606060;background-color:#FAFAFA;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;border-radius:4px;border:1px solid #C8C1C1;padding:6px 4px\" value=\"" + redirectUrl + "\">\n          </td>\n        </tr>\n        <tr>\n          <td><label style=\"margin-top:6px;display:block;overflow:hidden\">" + rb.getMessage("Autosave_interval") + ": </label></td>\n          <td>\n            <input name=\"sp-autosave-interval\" type=\"text\" style=\"color:#606060;background-color:#FAFAFA;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;width:100%;border-radius:4px;border:1px solid #C8C1C1;padding:6px 4px\" value=\"" + autosaveInterval + "\">\n          </td>\n        </tr>\n      </tbody>\n    </table>\n  </form>\n  <h3>" + rb.getMessage("Editor_settings_title") + "</h3>  <label><input name=\"sp-anyone-can-check-in\" type=\"checkbox\" " + anyoneCanCheckIn + "/> " + rb.getMessage("Anyone_can_check_in") + "</label></div>";
    }

    protected void setOption(String key, String value) {
        if ("sp-anyone-can-check-in".equals(key)) {
            value = "on".equals(value) ? "true" : "false";
        }
        super.setOption(key, value);
    }

    public String getOptionsJson() {
        String autoSaveInterval = this.getOption("sp-autosave-interval", DEFAULT_AUTOSAVE_INTERVAL);
        String anyoneCanCheckIn = this.getOption("sp-anyone-can-check-in", "false");
        String messageOrigin = this.getOption("sp-message-origin", "");
        return "{\"sp-autosave-interval\":\"" + autoSaveInterval + "\",\"sp-anyone-can-check-in\":" + anyoneCanCheckIn + ",\"sp-message-origin\":\"" + messageOrigin + "\"}";
    }
}

