/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.config;

import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public final class AppConfiguration {
    private static final String AUTHORIZATION_END_POINT = "https://login.microsoftonline.com/common/oauth2/authorize";
    private static AppConfiguration instance;
    private final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();

    public static synchronized AppConfiguration getInstance() {
        if (instance == null) {
            instance = new AppConfiguration();
        }
        return instance;
    }

    private AppConfiguration() {
    }

    public String getClientId() {
        return this.optionsStorage.getOption("sp-client-id", "");
    }

    public String getRedirectUrl() {
        return this.optionsStorage.getOption("sp-redirect-url", "");
    }

    public static String getAuthorizationEndPoint() {
        return AUTHORIZATION_END_POINT;
    }

    public String getClientSecret() {
        return this.optionsStorage.getOption("sp-client-secret", "");
    }

    public boolean isConfigured() {
        String clientId = this.getClientId();
        String clientSecret = this.getClientSecret();
        String redirectUrl = this.getRedirectUrl();
        return clientId != null && !clientId.isEmpty() && clientSecret != null && !clientSecret.isEmpty() && redirectUrl != null && !redirectUrl.isEmpty();
    }
}

