/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.actions;

import com.oxygenxml.webapp.sharepoint.actions.ActionBase;
import com.oxygenxml.webapp.sharepoint.actions.ActionResult;
import com.oxygenxml.webapp.sharepoint.actions.IsCheckedOutActionResult;
import com.oxygenxml.webapp.sharepoint.rest.JsonRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.rest.RestUrlPattern;
import com.oxygenxml.webapp.sharepoint.rest.RestUtil;
import com.oxygenxml.webapp.sharepoint.rest.response.locking.SPUser;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsCheckedOutAction
extends ActionBase {
    private static final Logger log = LoggerFactory.getLogger(IsCheckedOutAction.class);

    public IsCheckedOutAction(String targetURL, String accessToken) {
        super(targetURL, accessToken);
    }

    @Override
    public ActionResult perform() {
        IsCheckedOutActionResult result = null;
        if (this.targetUrl != null) {
            String checkedOutBy = null;
            boolean isCheckedOut = false;
            boolean isCheckedOutByCurrentUser = false;
            String errMessage = null;
            boolean success = true;
            try {
                URL restUrl;
                RestURLStreamProvider streamProvider;
                JsonRestRequest<SPUser> restReq;
                SPUser checkedOutByUser;
                String webUrl = RestUtil.getWebUrl(this.targetUrl, this.accessToken);
                if (webUrl != null && (checkedOutByUser = (SPUser)(restReq = new JsonRestRequest<SPUser>(streamProvider = new RestURLStreamProvider(restUrl = RestUrlPattern.CHECKED_OUT_BY_USER.getRestUrl(webUrl, new URL(this.targetUrl).getPath()), this.accessToken, false), SPUser.class)).get()) != null && checkedOutByUser.getNullValue() == null) {
                    SPUser currentUser = this.getCurrentUser(webUrl);
                    isCheckedOutByCurrentUser = currentUser.getId().equals(checkedOutByUser.getId());
                    String email = checkedOutByUser.getEmail();
                    String title = checkedOutByUser.getTitle();
                    checkedOutBy = email != null && !email.trim().isEmpty() ? email : (title != null && !title.trim().isEmpty() ? title : checkedOutByUser.getLoginName());
                    isCheckedOut = checkedOutBy != null;
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                success = false;
                errMessage = e.getMessage();
            }
            result = new IsCheckedOutActionResult(success, errMessage, isCheckedOut, checkedOutBy, isCheckedOutByCurrentUser);
        }
        return result;
    }

    private SPUser getCurrentUser(String webUrl) throws IOException {
        URL restUrl = RestUrlPattern.GET_CURRENT_USER.getRestUrl(webUrl);
        RestURLStreamProvider streamProvider = new RestURLStreamProvider(restUrl, this.accessToken, false);
        JsonRestRequest<SPUser> restReq = new JsonRestRequest<SPUser>(streamProvider, SPUser.class);
        return (SPUser)restReq.get();
    }
}

