/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.webapp.sharepoint.SPUrlUtil;
import com.oxygenxml.webapp.sharepoint.actions.ActionBase;
import com.oxygenxml.webapp.sharepoint.actions.ActionRequest;
import com.oxygenxml.webapp.sharepoint.actions.ActionResult;
import com.oxygenxml.webapp.sharepoint.actions.CheckInAction;
import com.oxygenxml.webapp.sharepoint.actions.CheckOutAction;
import com.oxygenxml.webapp.sharepoint.actions.DiscardCheckOutAction;
import com.oxygenxml.webapp.sharepoint.actions.IsCheckedOutAction;
import com.oxygenxml.webapp.sharepoint.filehandler.FileHandlerUtil;
import com.oxygenxml.webapp.sharepoint.oauth.Session;
import com.oxygenxml.webapp.sharepoint.oauth.SessionsManager;
import java.io.IOException;
import ro.sync.basic.util.URLUtil;

public class ActionsManager {
    public String performAction(ActionRequest actionRequest, String sessionId) {
        String response = "{}";
        if (actionRequest != null) {
            ActionResult result;
            String actionId = actionRequest.getActionId();
            String url = actionRequest.getTargetUrl();
            url = this.processURL(url, sessionId);
            Session session = SessionsManager.getInstance().getSession(sessionId);
            String token = null;
            if (session != null) {
                token = session.getAccessToken(url);
            }
            ActionBase action = null;
            if ("is.checked.out".equals(actionId)) {
                action = new IsCheckedOutAction(url, token);
            } else if ("check.out".equals(actionId)) {
                action = new CheckOutAction(url, token);
            } else if ("check.in".equals(actionId)) {
                String comment = actionRequest.getComment();
                int type = actionRequest.getType();
                action = new CheckInAction(url, token, comment, type);
            } else if ("discard.check.out".equals(actionId)) {
                action = new DiscardCheckOutAction(url, token);
            }
            if (action != null && (result = ((ActionBase)action).perform()) != null) {
                try {
                    response = new ObjectMapper().writeValueAsString((Object)result);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }

    protected String processURL(String url, String sessionID) {
        String processedUrl = SPUrlUtil.getHttpUrlFromSharePointUrl(url);
        if (SPUrlUtil.isFileHandlerSpecificURL(processedUrl = URLUtil.clearUserInfo((String)processedUrl).toExternalForm())) {
            try {
                String fileRealURL = FileHandlerUtil.getFileRealURL(processedUrl, sessionID);
                if (fileRealURL != null) {
                    processedUrl = fileRealURL;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return processedUrl;
    }
}

