/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint.actions;

import com.oxygenxml.webapp.sharepoint.actions.ActionBase;
import com.oxygenxml.webapp.sharepoint.actions.ActionResult;
import com.oxygenxml.webapp.sharepoint.rest.JsonRestRequest;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.rest.RestUtil;
import com.oxygenxml.webapp.sharepoint.rest.response.locking.LockResult;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

abstract class AbstractInOutAction
extends ActionBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractInOutAction.class);

    AbstractInOutAction(String targetURL, String accessToken) {
        super(targetURL, accessToken);
    }

    abstract URL getRestURL(String var1) throws MalformedURLException;

    @Override
    public ActionResult perform() {
        if (this.targetUrl == null) {
            return null;
        }
        boolean success = false;
        String errMessage = null;
        try {
            URL restUrl;
            RestURLStreamProvider streamProvider;
            JsonRestRequest<LockResult> restReq;
            LockResult response;
            String webUrl = RestUtil.getWebUrl(this.targetUrl, this.accessToken);
            if (webUrl != null && (response = (LockResult)(restReq = new JsonRestRequest<LockResult>(streamProvider = new RestURLStreamProvider(restUrl = this.getRestURL(webUrl), this.accessToken, false), LockResult.class)).write(new byte[0])) != null) {
                success = response.isSuccess();
                errMessage = response.getErrorMessage();
            }
        }
        catch (HttpExceptionWithDetails e) {
            log.error((Object)e, (Throwable)e);
            String reason = e.getReason();
            errMessage = reason != null ? reason : e.getMessage();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            errMessage = e.getMessage();
        }
        return new ActionResult(success, errMessage);
    }
}

