/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import ro.sync.exml.plugin.workspace.security.Response;
import ro.sync.exml.plugin.workspace.security.TrustedHostsProviderExtension;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class TrustedHostsProvider
implements TrustedHostsProviderExtension {
    private final AtomicReference<Set<String>> trustedHostsRef = new AtomicReference(new HashSet());
    private final AtomicReference<String> trustedSubdomainRef = new AtomicReference<Object>(null);

    public TrustedHostsProvider() {
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.updateTrustedHosts(optionsStorage);
        Arrays.asList("sharepoint_domain_name", "sp-hosts", "sp-client-id", "sp-client-secret").forEach(optionKey -> optionsStorage.addOptionListener(new WSOptionListener((String)optionKey){

            public void optionValueChanged(WSOptionChangedEvent event) {
                TrustedHostsProvider.this.updateTrustedHosts(optionsStorage);
            }
        }));
    }

    private synchronized void updateTrustedHosts(WSOptionsStorage options) {
        HashSet<String> toSet = new HashSet<String>();
        if (options.getOption("sp-client-id", null) != null && options.getOption("sp-client-secret", null) != null) {
            String sharepointPrivateDomain = options.getOption("sharepoint_domain_name", null);
            if (sharepointPrivateDomain == null) {
                this.trustedSubdomainRef.set(".sharepoint.com");
                toSet.add("login.microsoftonline.com");
                toSet.add("graph.microsoft.com");
            } else {
                toSet.add(sharepointPrivateDomain);
            }
            String[] configuredHosts = options.getStringArrayOption("sp-hosts", null);
            if (configuredHosts != null) {
                Collections.addAll(toSet, configuredHosts);
            }
        }
        this.trustedHostsRef.set(toSet);
    }

    public Response isTrusted(String hostName) {
        this.updateTrustedHosts(PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage());
        int hostIndex = hostName.indexOf(58);
        if (hostIndex != -1) {
            hostName = hostName.substring(0, hostIndex);
        }
        Set<String> trustedHosts = this.trustedHostsRef.get();
        String trustedSubdomain = this.trustedSubdomainRef.get();
        Response response = TrustedHostsProviderExtension.UNKNOWN;
        if (trustedHosts.contains(hostName) || trustedSubdomain != null && hostName.endsWith(trustedSubdomain)) {
            response = TrustedHostsProviderExtension.TRUSTED;
        }
        return response;
    }
}

