/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint;

import com.oxygenxml.webapp.sharepoint.ConnectionClosingOutputStream;
import com.oxygenxml.webapp.sharepoint.filebrowser.ChildrenRetriever;
import com.oxygenxml.webapp.sharepoint.rest.RestURLStreamProvider;
import com.oxygenxml.webapp.sharepoint.rest.RestUrlPattern;
import com.oxygenxml.webapp.sharepoint.rest.RestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.plugin.urlstreamhandler.CacheableUrlConnection;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class SharepointUrlConnection
extends URLConnection
implements FileBrowsingConnection,
CacheableUrlConnection {
    private static final Logger log = LoggerFactory.getLogger(SharepointUrlConnection.class);
    private final String token;
    private RestURLStreamProvider contentStreamProvider;
    private RestURLStreamProvider newFileStreamProvider;
    private String webFullUrl;
    private final ChildrenRetriever childrenRetriever;

    public SharepointUrlConnection(URL url, String token) {
        super(url);
        this.token = token;
        this.childrenRetriever = new ChildrenRetriever(url, token);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return this.getContentStreamProvider().getInputStream(false);
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        Map<String, List<String>> requestProperties = this.getRequestProperties();
        List<String> saveType = requestProperties.get("oxygen_save_type");
        boolean createNewFile = saveType != null && saveType.contains("save_as");
        HttpURLConnection conn = null;
        try {
            if (createNewFile) {
                conn = this.getNewFileStreamProvider().openConnectionForWrite();
            } else {
                conn = this.getContentStreamProvider().openConnectionForWrite();
                conn.setRequestProperty("X-HTTP-Method", "PUT");
            }
            return new ConnectionClosingOutputStream(conn);
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        return this.childrenRetriever.getChildren();
    }

    private void handleException(IOException e) throws UserActionRequiredException, IOException {
        if (e.getMessage().indexOf("401") == -1) {
            throw e;
        }
        String userInfo = this.url.getUserInfo();
        if (userInfo != null && !userInfo.isEmpty()) {
            String user = URLUtil.extractUser((String)this.url.toExternalForm());
            if (user != null && !user.trim().isEmpty()) {
                log.warn(() -> "Failed login attempt of user " + user + " for " + URLUtil.getDescription((URL)this.url));
            } else {
                log.warn("Failed login attempt for {}", new Supplier[]{() -> URLUtil.getDescription((URL)this.url)});
            }
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = e::getMessage;
        log.debug("Sharepoint not authorized exception {}", supplierArray);
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        throw new UserActionRequiredException(new WebappMessage(3, rb.getMessage("Authentication_required"), this.url.toExternalForm(), true));
    }

    public String getWebFullUrl() throws IOException {
        if (this.webFullUrl == null) {
            this.webFullUrl = RestUtil.getWebUrl(this.url.toString(), this.token);
        }
        return this.webFullUrl;
    }

    private RestURLStreamProvider getContentStreamProvider() throws IOException {
        String webUrl;
        if (this.contentStreamProvider == null && (webUrl = this.getWebFullUrl()) != null) {
            URL fileContentRestUrl = RestUrlPattern.FILE_CONTENT.getRestUrl(webUrl, this.url.getPath());
            this.contentStreamProvider = new RestURLStreamProvider(fileContentRestUrl, this.token, false);
        }
        return this.contentStreamProvider;
    }

    private RestURLStreamProvider getNewFileStreamProvider() throws IOException {
        String webUrl;
        if (this.newFileStreamProvider == null && (webUrl = this.getWebFullUrl()) != null) {
            URL parentURL = URLUtil.getParentURL((URL)this.url);
            String fileName = URLUtil.extractFileName((URL)this.url);
            if (parentURL == null || fileName == null) {
                throw new IOException("Cannot obtain REST URL for creating a ne file!");
            }
            URL newFileRestUrl = RestUrlPattern.NEW_FILE.getRestUrl(webUrl, parentURL.getPath(), fileName);
            this.newFileStreamProvider = new RestURLStreamProvider(newFileRestUrl, this.token, false);
        }
        return this.newFileStreamProvider;
    }
}

