/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint;

import com.oxygenxml.webapp.sharepoint.SPUrlUtil;
import com.oxygenxml.webapp.sharepoint.filehandler.FileHandlerUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public final class SharePointURIResolver
implements URIResolver {
    private static final Logger log = LoggerFactory.getLogger(SharePointURIResolver.class);
    static final String SHAREPOINT_COM_DOMAIN = "sharepoint.com";
    static final String SHAREPOINT_DOMAIN_NAME = "sharepoint_domain_name";
    private final String domainName;

    public SharePointURIResolver() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.domainName = optionsStorage.getOption(SHAREPOINT_DOMAIN_NAME, null);
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        PlainSource resolved;
        block10: {
            resolved = null;
            if (base != null && SPUrlUtil.isSharePointCustomUrl(base)) {
                if (href.startsWith("http://") || href.startsWith("https://")) {
                    try {
                        URL hrefUrl = new URL(href);
                        if (!this.isSharepointFileUrl(hrefUrl) || !SharePointURIResolver.haveSameHostAndPort(base, href)) break block10;
                        URL baseUrl = new URL(base);
                        URL hrefWithUserInfo = URLUtil.attachUserInfo((URL)hrefUrl, (String)baseUrl.getUserInfo(), null, (boolean)false);
                        String resolvedSystemID = SPUrlUtil.getSharePointCustomUrlFromHttpUrl(hrefWithUserInfo);
                        resolved = new PlainSource(resolvedSystemID);
                        if (log.isDebugEnabled()) {
                            log.debug("href: {}", (Object)href);
                            log.debug("base: {}", (Object)base);
                            log.debug("Resolved uri: {}", (Object)resolved.getSystemId());
                        }
                    }
                    catch (MalformedURLException | URISyntaxException hrefUrl) {}
                } else if (SPUrlUtil.isFileHandlerSpecificURL(base) && URLUtil.isRelativePath((String)href)) {
                    String cleanHttpBase = SPUrlUtil.getHttpUrlFromSharePointUrl(base);
                    try {
                        String baseRealUrl;
                        String sessionId = SPUrlUtil.getSessionIdFromUrl(cleanHttpBase);
                        if (sessionId != null && (baseRealUrl = FileHandlerUtil.getFileRealURL(cleanHttpBase = URLUtil.clearUserInfo((String)cleanHttpBase).toExternalForm(), sessionId)) != null) {
                            URL baseAbsUrl = new URL(baseRealUrl);
                            URL baseUrlWithUi = URLUtil.attachUserInfo((URL)baseAbsUrl, (String)sessionId, null, (boolean)false);
                            URL resolvedURL = new URL(baseUrlWithUi, href);
                            String resolvedSystemID = SPUrlUtil.getSharePointCustomUrlFromHttpUrl(resolvedURL);
                            resolved = new PlainSource(resolvedSystemID);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return resolved;
    }

    private static boolean haveSameHostAndPort(String uriA, String uriB) throws URISyntaxException {
        URI uriAObj = new URI(uriA);
        URI uriBObj = new URI(uriB);
        return uriAObj.getHost().equals(uriBObj.getHost()) && uriAObj.getPort() == uriBObj.getPort();
    }

    private boolean isSharepointFileUrl(URL fileUrl) {
        String host = fileUrl.getHost();
        return SharePointURIResolver.isHostSupported(host, this.domainName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isHostSupported(String host, String configuredDomainName) {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String[] defaultValues = new String[]{SHAREPOINT_COM_DOMAIN, "ditaexchange.com"};
        String[] sharepointHosts = optionsStorage.getStringArrayOption("sp-hosts", defaultValues);
        if (Arrays.stream(sharepointHosts).anyMatch(host::equals)) return true;
        if (Arrays.stream(sharepointHosts).map(h -> "." + h).anyMatch(host::endsWith)) return true;
        if (configuredDomainName == null) return false;
        if (host.equals(configuredDomainName)) return true;
        if (!("." + host).endsWith(configuredDomainName)) return false;
        return true;
    }

    private static final class PlainSource
    implements Source {
        private final String systemID;

        PlainSource(String systemID) {
            this.systemID = systemID;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getSystemId() {
            return this.systemID;
        }
    }
}

