/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.sharepoint;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import ro.sync.basic.util.URLUtil;

public final class SPUrlUtil {
    public static final String SHAREPOINT_PROTO_PREFIX = "spo-";
    private static final String FILE_HANDLER_URL_MARKER = "_vti_bin/wopi.ashx/files/";

    private SPUrlUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean isSharePointProtocol(String protocol) {
        return SPUrlUtil.isSharePointCustomUrl(protocol);
    }

    public static URL getHttpUrlFromSharePointUrl(URL url) {
        try {
            String urlStr = url.toExternalForm();
            if (SPUrlUtil.isSharePointCustomUrl(urlStr)) {
                urlStr = urlStr.substring(SHAREPOINT_PROTO_PREFIX.length());
                url = new URL(urlStr);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static String getHttpUrlFromSharePointUrl(String url) {
        if (SPUrlUtil.isSharePointCustomUrl(url)) {
            url = url.substring(SHAREPOINT_PROTO_PREFIX.length());
        }
        return url;
    }

    public static boolean isSharePointCustomUrl(String url) {
        return url.startsWith(SHAREPOINT_PROTO_PREFIX);
    }

    public static String getSharePointCustomUrlFromHttpUrl(URL httpUrl) {
        return SHAREPOINT_PROTO_PREFIX + httpUrl.toExternalForm();
    }

    public static String getSessionIdFromUrl(String urlStr) {
        String sessionId = null;
        try {
            URL u = new URL(urlStr);
            String userInfo = u.getUserInfo();
            if (userInfo != null) {
                sessionId = URLUtil.extractUser((String)userInfo);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return sessionId;
    }

    public static boolean isFileHandlerSpecificURL(String url) {
        return url != null && url.contains(FILE_HANDLER_URL_MARKER);
    }

    public static Map<String, String> parseUrlQuery(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>(params.length);
        for (String param : params) {
            String name;
            String value = null;
            if (param.contains("=")) {
                String[] pair = param.split("=");
                name = URLUtil.uncorrect((String)pair[0]);
                value = URLUtil.uncorrect((String)pair[1]);
            } else {
                name = param;
            }
            map.put(name, value);
        }
        return map;
    }
}

