/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.md;

import com.elovirta.dita.markdown.MDitaReader;
import com.elovirta.dita.markdown.MarkdownReader;
import com.oxygenxml.md.ExternalOptionProvider;
import com.oxygenxml.md.URLUtil;
import com.oxygenxml.md.XMLUtilities;
import com.oxygenxml.md.backmapping.ConversionContextProvider;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;

public final class MarkdownConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MarkdownConverter.class.getName());
    private static final String MD_TEST_CODE = "# Title\nEmail:\n<address@example.com>";
    private static final String MD_FAKE_SYSID = "file:/fake.md";

    private MarkdownConverter() {
    }

    public static XMLReader createMDToDITAXmlReader() {
        return new MarkdownReader();
    }

    public static XMLReader createMDToDITAXmlReader(ExternalOptionProvider externalOptionProvider) {
        return new MarkdownReader(externalOptionProvider);
    }

    public static XMLReader createMDToDITAXmlReaderWithBackmapping(String mdSystemID) {
        MarkdownReader markdownReader = new MarkdownReader();
        markdownReader.enableBackmappingData(mdSystemID);
        return markdownReader;
    }

    public static XMLReader createMDToDITAXmlReaderWithBackmapping(String mdSystemID, ExternalOptionProvider externalOptionProvider) {
        MarkdownReader markdownReader = new MarkdownReader(externalOptionProvider);
        markdownReader.enableBackmappingData(mdSystemID);
        return markdownReader;
    }

    public static XMLReader createMDToLwDITAXmlReaderWithBackmapping(String mdSystemID) {
        MDitaReader markdownReader = new MDitaReader();
        markdownReader.enableBackmappingData(mdSystemID);
        return markdownReader;
    }

    public static XMLReader createMDToLwDITAXmlReader() {
        return new MDitaReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTMLFragment(String mdContent, boolean embedBackmappingData, String systemID) {
        ConversionContextProvider instance = ConversionContextProvider.getInstance();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Convert to HTML, embedBackmappingData: {} sys: {}", (Object)embedBackmappingData, (Object)URLUtil.filterPasswords((String)systemID));
            }
            instance.set(new ConversionContextProvider.ConversionContext(embedBackmappingData, systemID));
            String string = MarkdownConverter.getHTMLFragment(mdContent);
            return string;
        }
        finally {
            instance.remove();
        }
    }

    public static boolean isHTMLBackMappingEnabled() {
        boolean isEnabled = false;
        try {
            MarkdownConverter.getHTMLFragment(MD_TEST_CODE, true, MD_FAKE_SYSID);
            isEnabled = true;
        }
        catch (Throwable t) {
            LOGGER.debug("Markdown back mapping information can't be embeded inside the HTML output because of {}", (Object)t.getMessage(), (Object)t);
        }
        return isEnabled;
    }

    public static boolean isDITABackMappingEnabled() {
        boolean isEnabled = false;
        try {
            XMLReader reader = MarkdownConverter.createMDToLwDITAXmlReaderWithBackmapping(MD_FAKE_SYSID);
            XMLUtilities.checkReader((String)MD_TEST_CODE, (XMLReader)reader);
            reader = MarkdownConverter.createMDToDITAXmlReaderWithBackmapping(MD_FAKE_SYSID);
            XMLUtilities.checkReader((String)MD_TEST_CODE, (XMLReader)reader);
            isEnabled = true;
        }
        catch (Throwable t) {
            LOGGER.debug("Markdown back mapping information can't be embeded inside the DITA output because of {}", (Object)t.getMessage(), (Object)t);
        }
        return isEnabled;
    }

    public static String getHTMLFragment(String mdContent) {
        String ret = null;
        mdContent = mdContent.replace("\r", "");
        try {
            MutableDataSet options = new MutableDataSet();
            options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), StrikethroughExtension.create(), TaskListExtension.create()));
            options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
            Parser parser = Parser.builder((DataHolder)options).build();
            HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
            Document document = parser.parse(mdContent);
            ret = renderer.render((Node)document);
        }
        catch (Exception e) {
            try (StringWriter wr = new StringWriter();
                 PrintWriter pr = new PrintWriter(wr);){
                e.printStackTrace(pr);
                ret = wr.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }
}

