/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.Emitter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxySaxon
extends Emitter
implements Locator {
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    protected Locator locator = this;
    private int depth = 0;
    protected boolean requireWellFormed = true;

    public void setUnderlyingContentHandler(ContentHandler handler) {
        this.handler = handler;
        if (handler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)handler);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setRequireWellFormed(boolean wellFormed) {
        this.requireWellFormed = wellFormed;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws TransformerException {
        if (this.handler == null) {
            throw new TransformerException("ContentHandlerProxy.startDocument(): no underlying handler provided");
        }
        try {
            this.handler.setDocumentLocator(this.locator);
            this.handler.startDocument();
        }
        catch (SAXException err) {
            throw new TransformerException(err);
        }
        this.depth = 0;
    }

    @Override
    public void endDocument() throws TransformerException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException err) {
            throw new TransformerException(err);
        }
    }

    @Override
    public void startElement(int nameCode, Attributes atts, int[] namespaces, int nscount) throws TransformerException {
        ++this.depth;
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                this.notifyNotWellFormed();
            }
            if (this.depth > 0 || !this.requireWellFormed) {
                for (int n = 0; n < nscount; ++n) {
                    String prefix = this.namePool.getPrefixFromNamespaceCode(namespaces[n]);
                    String uri = this.namePool.getURIFromNamespaceCode(namespaces[n]);
                    this.handler.startPrefixMapping(prefix, uri);
                }
                this.handler.startElement(this.namePool.getURI(nameCode), this.namePool.getLocalName(nameCode), this.namePool.getDisplayName(nameCode), atts);
            }
        }
        catch (SAXException err) {
            throw new TransformerException(err);
        }
    }

    @Override
    public void endElement(int nameCode) throws TransformerException {
        if (this.depth > 0) {
            try {
                this.handler.endElement(this.namePool.getURI(nameCode), this.namePool.getLocalName(nameCode), this.namePool.getDisplayName(nameCode));
            }
            catch (SAXException err) {
                throw new TransformerException(err);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    @Override
    public void characters(char[] chars, int start, int len) throws TransformerException {
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                boolean isWhite;
                boolean bl = isWhite = new String(chars, start, len).trim().length() == 0;
                if (!isWhite) {
                    this.notifyNotWellFormed();
                    if (!this.requireWellFormed) {
                        this.handler.characters(chars, start, len);
                    }
                }
            } else {
                this.handler.characters(chars, start, len);
            }
        }
        catch (SAXException err) {
            throw new TransformerException(err);
        }
    }

    protected void notifyNotWellFormed() throws SAXException {
        try {
            this.handler.processingInstruction("saxon:warning", "Output suppressed because it is not well-formed");
        }
        catch (SAXException err) {
            if (err.getMessage().equals("continue")) {
                this.requireWellFormed = false;
            }
            throw err;
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws TransformerException {
        try {
            this.handler.processingInstruction(target, data);
        }
        catch (SAXException err) {
            throw new TransformerException(err);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws TransformerException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(ch, start, length);
            }
        }
        catch (SAXException err) {
            throw new TransformerException(err);
        }
    }

    @Override
    public void setEscaping(boolean escaping) {
        try {
            this.handler.processingInstruction(escaping ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }
}

