/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.ArithmeticExpression;
import com.icl.saxon.expr.BooleanExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.ErrorExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterExpression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ParentNodeExpression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.RelationalExpression;
import com.icl.saxon.expr.RootExpression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Tokenizer;
import com.icl.saxon.expr.UnionExpression;
import com.icl.saxon.expr.VariableReference;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.BooleanFn;
import com.icl.saxon.functions.Ceiling;
import com.icl.saxon.functions.Concat;
import com.icl.saxon.functions.Contains;
import com.icl.saxon.functions.Count;
import com.icl.saxon.functions.Current;
import com.icl.saxon.functions.Document;
import com.icl.saxon.functions.ElementAvailable;
import com.icl.saxon.functions.Floor;
import com.icl.saxon.functions.FormatNumber;
import com.icl.saxon.functions.FunctionAvailable;
import com.icl.saxon.functions.GenerateId;
import com.icl.saxon.functions.Id;
import com.icl.saxon.functions.Key;
import com.icl.saxon.functions.Lang;
import com.icl.saxon.functions.Last;
import com.icl.saxon.functions.LocalName;
import com.icl.saxon.functions.NameFn;
import com.icl.saxon.functions.NamespaceURI;
import com.icl.saxon.functions.NormalizeSpace;
import com.icl.saxon.functions.Not;
import com.icl.saxon.functions.NumberFn;
import com.icl.saxon.functions.Position;
import com.icl.saxon.functions.Round;
import com.icl.saxon.functions.StartsWith;
import com.icl.saxon.functions.StringFn;
import com.icl.saxon.functions.StringLength;
import com.icl.saxon.functions.Substring;
import com.icl.saxon.functions.SubstringAfter;
import com.icl.saxon.functions.SubstringBefore;
import com.icl.saxon.functions.Sum;
import com.icl.saxon.functions.SystemProperty;
import com.icl.saxon.functions.Translate;
import com.icl.saxon.functions.UnparsedEntityURI;
import com.icl.saxon.om.Axis;
import com.icl.saxon.om.Name;
import com.icl.saxon.pattern.AnyChildNodePattern;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.IDPattern;
import com.icl.saxon.pattern.KeyPattern;
import com.icl.saxon.pattern.LocationPathPattern;
import com.icl.saxon.pattern.NamespaceTest;
import com.icl.saxon.pattern.NoNodeTest;
import com.icl.saxon.pattern.NodeTypeTest;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.pattern.UnionPattern;
import javax.xml.transform.TransformerException;

public final class ExpressionParser {
    private Tokenizer t;
    private StaticContext env;
    private static final int CHILD_AXIS = 0;
    private static final int ATTRIBUTE_AXIS = 1;

    private void expect(int token) throws XPathException {
        if (this.t.currentToken != token) {
            this.grumble("expected \"" + Tokenizer.tokens[token] + "\", found \"" + Tokenizer.tokens[this.t.currentToken] + "\"");
        }
    }

    private void grumble(String message) throws XPathException {
        throw new XPathException("Error in expression " + this.t.pattern + ": " + message);
    }

    public Expression parse(String expression, StaticContext env) throws XPathException {
        this.env = env;
        this.t = new Tokenizer();
        this.t.tokenize(expression);
        Expression exp = this.parseExpression();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " beyond end of expression");
        }
        exp.setStaticContext(env);
        return exp;
    }

    public Pattern parsePattern(String pattern, StaticContext env) throws XPathException {
        this.env = env;
        this.t = new Tokenizer();
        this.t.tokenize(pattern);
        Pattern pat = this.parseUnionPattern();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " beyond end of pattern");
        }
        pat.setStaticContext(env);
        return pat;
    }

    private Expression parseExpression() throws XPathException {
        Expression exp = this.parseAndExpression();
        while (this.t.currentToken == 18) {
            this.t.next();
            exp = new BooleanExpression(exp, 18, this.parseAndExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parseAndExpression() throws XPathException {
        Expression exp = this.parseEqualityExpression();
        while (this.t.currentToken == 19) {
            this.t.next();
            exp = new BooleanExpression(exp, 19, this.parseEqualityExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parseEqualityExpression() throws XPathException {
        Expression exp = this.parseRelationalExpression();
        while (this.t.currentToken == 11 || this.t.currentToken == 34) {
            int op = this.t.currentToken;
            this.t.next();
            exp = new RelationalExpression(exp, op, this.parseRelationalExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parseRelationalExpression() throws XPathException {
        Expression exp = this.parseAdditiveExpression();
        while (this.t.currentToken == 22 || this.t.currentToken == 21 || this.t.currentToken == 24 || this.t.currentToken == 23) {
            int op = this.t.currentToken;
            this.t.next();
            exp = new RelationalExpression(exp, op, this.parseAdditiveExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parseAdditiveExpression() throws XPathException {
        Expression exp = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 25 || this.t.currentToken == 26) {
            int op = this.t.currentToken;
            this.t.next();
            exp = new ArithmeticExpression(exp, op, this.parseMultiplicativeExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parseMultiplicativeExpression() throws XPathException {
        Expression exp = this.parseUnaryExpression();
        while (this.t.currentToken == 27 || this.t.currentToken == 28 || this.t.currentToken == 29) {
            int op = this.t.currentToken;
            this.t.next();
            exp = new ArithmeticExpression(exp, op, this.parseUnaryExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression exp;
        if (this.t.currentToken == 26) {
            this.t.next();
            exp = new ArithmeticExpression(new NumericValue(0.0), 99, this.parseUnaryExpression());
            exp.setStaticContext(this.env);
        } else {
            exp = this.parseUnionExpression();
        }
        return exp;
    }

    private Expression parseUnionExpression() throws XPathException {
        Expression exp = this.parsePathExpression();
        while (this.t.currentToken == 4) {
            this.t.next();
            exp = new UnionExpression(exp, this.parsePathExpression());
            exp.setStaticContext(this.env);
        }
        return exp;
    }

    private Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 5: {
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: 
                    case 6: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 32: 
                    case 33: {
                        return this.parseRelativePath(new RootExpression());
                    }
                }
                return new RootExpression();
            }
            case 16: {
                return this.parsePathContinuation(new RootExpression());
            }
            case 12: {
                this.t.next();
                return this.parsePathContinuation(new ContextNodeExpression());
            }
            case 13: {
                this.t.next();
                return this.parsePathContinuation(new ParentNodeExpression());
            }
            case 1: 
            case 6: 
            case 14: 
            case 17: 
            case 32: 
            case 33: {
                return this.parseRelativePath(new ContextNodeExpression());
            }
        }
        Expression start = this.parseFilterExpression();
        Expression continuation = this.parsePathContinuation(start);
        continuation.setStaticContext(this.env);
        return continuation;
    }

    private Expression parseFilterExpression() throws XPathException {
        Expression primary = this.parsePrimaryExpression();
        while (this.t.currentToken == 7) {
            this.t.next();
            Expression predicate = this.parseExpression();
            this.expect(8);
            primary = new FilterExpression(primary, predicate);
            primary.setStaticContext(this.env);
            this.t.next();
        }
        return primary;
    }

    private Expression parsePrimaryExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 31: {
                this.t.next();
                this.expect(1);
                String var = this.t.currentTokenValue;
                this.t.next();
                int vtest = this.env.makeNameCode(var, false) & 0xFFFFF;
                return new VariableReference(vtest, this.env);
            }
            case 9: {
                this.t.next();
                Expression exp = this.parseExpression();
                this.expect(10);
                this.t.next();
                return exp;
            }
            case 3: {
                StringValue literal = new StringValue(this.t.currentTokenValue);
                this.t.next();
                return literal;
            }
            case 20: {
                NumericValue number = new NumericValue(this.t.currentTokenValue);
                this.t.next();
                return number;
            }
            case 2: {
                return this.parseFunctionCall();
            }
        }
        this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " in expression");
        return null;
    }

    private Expression parsePathContinuation(Expression start) throws XPathException {
        switch (this.t.currentToken) {
            case 5: {
                this.t.next();
                return this.parseRelativePath(start);
            }
            case 16: {
                PathExpression exp = new PathExpression(start, new Step(5, AnyNodeTest.getInstance()));
                exp.setStaticContext(this.env);
                this.t.next();
                return this.parseRelativePath(exp);
            }
        }
        return start;
    }

    private Expression parseRelativePath(Expression start) throws XPathException {
        Step step = this.parseStep();
        PathExpression exp = new PathExpression(start, step);
        exp.setStaticContext(this.env);
        return this.parsePathContinuation(exp);
    }

    private Step parseStep() throws XPathException {
        Step step = null;
        switch (this.t.currentToken) {
            case 12: {
                step = new Step(12, AnyNodeTest.getInstance());
                this.t.next();
                break;
            }
            case 13: {
                step = new Step(9, AnyNodeTest.getInstance());
                this.t.next();
                break;
            }
            case 1: {
                step = new Step(3, this.env.makeNameTest((short)1, this.t.currentTokenValue, false));
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 17: {
                NamespaceTest nstest1 = this.env.makeNamespaceTest((short)1, this.t.currentTokenValue);
                step = new Step(3, nstest1);
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 14: {
                step = new Step(3, new NodeTypeTest(1));
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 6: {
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: {
                        step = new Step(2, this.env.makeNameTest((short)2, this.t.currentTokenValue, false));
                        this.t.next();
                        break;
                    }
                    case 17: {
                        NamespaceTest nstest2 = this.env.makeNamespaceTest((short)2, this.t.currentTokenValue);
                        step = new Step(2, nstest2);
                        this.t.next();
                        break;
                    }
                    case 14: {
                        step = new Step(2, AnyNodeTest.getInstance());
                        this.t.next();
                        break;
                    }
                    case 32: {
                        String nodetype = this.t.currentTokenValue;
                        this.t.next();
                        if (nodetype == "text") {
                            step = new Step(2, NoNodeTest.getInstance());
                        } else if (nodetype == "node") {
                            step = new Step(2, AnyNodeTest.getInstance());
                        } else if (nodetype == "comment") {
                            step = new Step(2, NoNodeTest.getInstance());
                        } else if (nodetype == "processing-instruction") {
                            if (this.t.currentToken == 3) {
                                this.t.next();
                            }
                            step = new Step(2, NoNodeTest.getInstance());
                        }
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    default: {
                        this.grumble("@ must be followed by a NameTest or NodeTest");
                    }
                }
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 32: {
                String nodetype = this.t.currentTokenValue;
                this.t.next();
                if (nodetype == "text") {
                    step = new Step(3, new NodeTypeTest(3));
                } else if (nodetype == "node") {
                    step = new Step(3, AnyNodeTest.getInstance());
                } else if (nodetype == "comment") {
                    step = new Step(3, new NodeTypeTest(8));
                } else if (nodetype == "processing-instruction") {
                    if (this.t.currentToken == 3) {
                        step = Name.isNCName(this.t.currentTokenValue) ? new Step(3, this.env.makeNameTest((short)7, this.t.currentTokenValue, false)) : new Step(3, NoNodeTest.getInstance());
                        this.t.next();
                    } else {
                        step = new Step(3, new NodeTypeTest(7));
                    }
                }
                this.expect(10);
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 33: {
                byte axis = Axis.getAxisNumber(this.t.currentTokenValue);
                short principalNodeType = Axis.principalNodeType[axis];
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: {
                        step = new Step(axis, this.env.makeNameTest(principalNodeType, this.t.currentTokenValue, false));
                        this.t.next();
                        break;
                    }
                    case 17: {
                        NamespaceTest nstest3 = this.env.makeNamespaceTest(principalNodeType, this.t.currentTokenValue);
                        step = new Step(axis, nstest3);
                        this.t.next();
                        break;
                    }
                    case 14: {
                        step = new Step(axis, new NodeTypeTest(principalNodeType));
                        this.t.next();
                        break;
                    }
                    case 32: {
                        String nt = this.t.currentTokenValue;
                        this.t.next();
                        if (nt == "node") {
                            step = new Step(axis, AnyNodeTest.getInstance());
                        } else if (nt == "text") {
                            step = new Step(axis, new NodeTypeTest(3));
                        } else if (nt == "comment") {
                            step = new Step(axis, new NodeTypeTest(8));
                        } else if (nt == "processing-instruction") {
                            if (this.t.currentToken == 3) {
                                step = Name.isNCName(this.t.currentTokenValue) ? new Step(axis, this.env.makeNameTest((short)7, this.t.currentTokenValue, false)) : new Step(axis, NoNodeTest.getInstance());
                                this.t.next();
                            } else {
                                step = new Step(axis, new NodeTypeTest(7));
                            }
                        } else {
                            this.grumble("Unsupported node type");
                        }
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    default: {
                        this.grumble("Unexpected token [" + Tokenizer.tokens[this.t.currentToken] + "] after axis name");
                    }
                }
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            default: {
                this.grumble("Unexpected token [" + Tokenizer.tokens[this.t.currentToken] + "] in path expression");
            }
        }
        return step;
    }

    private Step parseStepPredicate(Step start) throws XPathException {
        this.t.next();
        Expression predicate = this.parseExpression();
        this.expect(8);
        this.t.next();
        return start.addFilter(predicate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Expression parseFunctionCall() throws XPathException {
        String fname = this.t.currentTokenValue;
        Function f = null;
        int colon = fname.indexOf(":");
        if (colon < 0) {
            Expression e = ExpressionParser.makeSystemFunction(fname);
            if (e == null) {
                this.grumble("Unknown system function: " + fname);
            }
            e.setStaticContext(this.env);
            if (!(e instanceof Function)) {
                this.t.next();
                this.expect(10);
                this.t.next();
                return e;
            }
            f = (Function)e;
        } else {
            f = this.env.getStyleSheetFunction(this.env.makeNameCode(fname, false) & 0xFFFFF);
        }
        if (f == null) {
            f = new FunctionProxy();
        }
        f.setStaticContext(this.env);
        this.t.next();
        if (this.t.currentToken != 10) {
            Expression arg = this.parseExpression();
            f.addArgument(arg);
            while (this.t.currentToken == 15) {
                this.t.next();
                arg = this.parseExpression();
                f.addArgument(arg);
            }
            this.expect(10);
        }
        this.t.next();
        if (f instanceof FunctionProxy) {
            String uri = this.env.getURIForPrefix(fname.substring(0, colon));
            String lname = fname.substring(colon + 1);
            Class className = null;
            try {
                className = this.env.getExternalJavaClass(uri);
            }
            catch (TransformerException err) {
                XPathException xx = new XPathException("Failed to load external Java class for uri " + uri);
                return new ErrorExpression(xx);
            }
            if (className == null) {
                XPathException xx = new XPathException("The URI " + uri + " does not identify an external Java class");
                return new ErrorExpression(xx);
            }
            ((FunctionProxy)f).setFunctionName(className, lname);
        }
        return f;
    }

    public static Expression makeSystemFunction(String name) {
        if (name == "last") {
            return new Last();
        }
        if (name == "position") {
            return new Position();
        }
        if (name == "count") {
            return new Count();
        }
        if (name == "current") {
            return new Current();
        }
        if (name == "id") {
            return new Id();
        }
        if (name == "key") {
            return new Key();
        }
        if (name == "document") {
            return new Document();
        }
        if (name == "local-name") {
            return new LocalName();
        }
        if (name == "namespace-uri") {
            return new NamespaceURI();
        }
        if (name == "name") {
            return new NameFn();
        }
        if (name == "generate-id") {
            return new GenerateId();
        }
        if (name == "not") {
            return new Not();
        }
        if (name == "true") {
            return new BooleanValue(true);
        }
        if (name == "false") {
            return new BooleanValue(false);
        }
        if (name == "boolean") {
            return new BooleanFn();
        }
        if (name == "lang") {
            return new Lang();
        }
        if (name == "number") {
            return new NumberFn();
        }
        if (name == "floor") {
            return new Floor();
        }
        if (name == "ceiling") {
            return new Ceiling();
        }
        if (name == "round") {
            return new Round();
        }
        if (name == "sum") {
            return new Sum();
        }
        if (name == "string") {
            return new StringFn();
        }
        if (name == "starts-with") {
            return new StartsWith();
        }
        if (name == "string-length") {
            return new StringLength();
        }
        if (name == "substring") {
            return new Substring();
        }
        if (name == "contains") {
            return new Contains();
        }
        if (name == "substring-before") {
            return new SubstringBefore();
        }
        if (name == "substring-after") {
            return new SubstringAfter();
        }
        if (name == "normalize-space") {
            return new NormalizeSpace();
        }
        if (name == "translate") {
            return new Translate();
        }
        if (name == "concat") {
            return new Concat();
        }
        if (name == "format-number") {
            return new FormatNumber();
        }
        if (name == "system-property") {
            return new SystemProperty();
        }
        if (name == "function-available") {
            return new FunctionAvailable();
        }
        if (name == "element-available") {
            return new ElementAvailable();
        }
        if (name == "unparsed-entity-uri") {
            return new UnparsedEntityURI();
        }
        return null;
    }

    private Pattern parseUnionPattern() throws XPathException {
        Pattern exp1 = this.parsePathPattern();
        while (this.t.currentToken == 4) {
            this.t.next();
            Pattern exp2 = this.parsePathPattern();
            exp1 = new UnionPattern(exp1, exp2);
            exp1.setStaticContext(this.env);
            exp2.setStaticContext(this.env);
        }
        return exp1;
    }

    private Pattern parsePathPattern() throws XPathException {
        LocationPathPattern lppat = new LocationPathPattern();
        lppat.setStaticContext(this.env);
        Pattern pat = lppat;
        Pattern prev = null;
        int connector = -1;
        boolean rootonly = false;
        switch (this.t.currentToken) {
            case 5: {
                connector = this.t.currentToken;
                this.t.next();
                prev = new NodeTypeTest(9);
                rootonly = true;
                break;
            }
            case 16: {
                connector = this.t.currentToken;
                this.t.next();
                prev = new NodeTypeTest(9);
                rootonly = false;
                break;
            }
        }
        boolean more = true;
        while (more) {
            switch (this.t.currentToken) {
                case 33: {
                    if (this.t.currentTokenValue.equals("child")) {
                        this.t.next();
                        pat = this.patternStep(0, lppat, prev, connector);
                        break;
                    }
                    if (this.t.currentTokenValue.equals("attribute")) {
                        this.t.next();
                        pat = this.patternStep(1, lppat, prev, connector);
                        break;
                    }
                    this.grumble("Axis in pattern must be child or attribute");
                    break;
                }
                case 1: 
                case 14: 
                case 17: 
                case 32: {
                    pat = this.patternStep(0, lppat, prev, connector);
                    break;
                }
                case 6: {
                    this.t.next();
                    pat = this.patternStep(1, lppat, prev, connector);
                    break;
                }
                case 2: {
                    if (prev != null) {
                        this.grumble("Function may appear only at the start of a pattern");
                    }
                    if (this.t.currentTokenValue.equals("id")) {
                        this.t.next();
                        this.expect(3);
                        pat = new IDPattern(this.t.currentTokenValue);
                        pat.setStaticContext(this.env);
                        this.t.next();
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    if (this.t.currentTokenValue.equals("key")) {
                        this.t.next();
                        this.expect(3);
                        String keyname = this.t.currentTokenValue;
                        this.t.next();
                        this.expect(15);
                        this.t.next();
                        this.expect(3);
                        if (!this.env.allowsKeyFunction()) {
                            this.grumble("key() function cannot be used here");
                        }
                        pat = new KeyPattern(this.env.makeNameCode(keyname, false), this.t.currentTokenValue);
                        pat.setStaticContext(this.env);
                        this.t.next();
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    this.grumble("The only functions allowed in a pattern are id() and key()");
                    break;
                }
                default: {
                    if (rootonly) {
                        return prev;
                    }
                    this.grumble("Unexpected token in pattern, found " + Tokenizer.tokens[this.t.currentToken]);
                }
            }
            connector = this.t.currentToken;
            rootonly = false;
            more = connector == 5 || connector == 16;
            if (!more) continue;
            prev = pat;
            lppat = new LocationPathPattern();
            lppat.setStaticContext(this.env);
            if (connector == 5) {
                lppat.parentPattern = prev;
            } else {
                lppat.ancestorPattern = prev;
            }
            this.t.next();
        }
        pat.setStaticContext(this.env);
        return pat;
    }

    private Pattern patternStep(int axis, LocationPathPattern lppat, Pattern prev, int connector) throws XPathException {
        if (axis == 0) {
            if (this.t.currentToken == 14) {
                lppat.nodeTest = new NodeTypeTest(1);
            } else if (this.t.currentToken == 1) {
                lppat.nodeTest = this.env.makeNameTest((short)1, this.t.currentTokenValue, false);
            } else if (this.t.currentToken == 17) {
                lppat.nodeTest = this.env.makeNamespaceTest((short)1, this.t.currentTokenValue);
            } else if (this.t.currentToken == 32) {
                String nodetype = this.t.currentTokenValue;
                this.t.next();
                if (nodetype == "text") {
                    lppat.nodeTest = new NodeTypeTest(3);
                } else if (nodetype == "node") {
                    lppat.nodeTest = new AnyChildNodePattern();
                } else if (nodetype == "comment") {
                    lppat.nodeTest = new NodeTypeTest(8);
                } else if (nodetype == "processing-instruction") {
                    if (this.t.currentToken == 3) {
                        lppat.nodeTest = Name.isNCName(this.t.currentTokenValue) ? this.env.makeNameTest((short)7, this.t.currentTokenValue, false) : NoNodeTest.getInstance();
                        this.t.next();
                    } else {
                        lppat.nodeTest = new NodeTypeTest(7);
                    }
                }
                this.expect(10);
            } else {
                this.grumble("Unexpected token in pattern, found " + Tokenizer.tokens[this.t.currentToken]);
            }
            if (prev != null) {
                if (connector == 5) {
                    lppat.parentPattern = prev;
                } else {
                    lppat.ancestorPattern = prev;
                }
            }
            this.t.next();
            this.parseFilters(lppat);
            return lppat;
        }
        if (axis == 1) {
            if (this.t.currentToken == 14) {
                lppat.nodeTest = new NodeTypeTest(2);
            } else if (this.t.currentToken == 1) {
                lppat.nodeTest = this.env.makeNameTest((short)2, this.t.currentTokenValue, false);
            } else if (this.t.currentToken == 17) {
                lppat.nodeTest = this.env.makeNamespaceTest((short)2, this.t.currentTokenValue);
            } else if (this.t.currentToken == 32) {
                String nodetype = this.t.currentTokenValue;
                this.t.next();
                if (nodetype == "text") {
                    lppat.nodeTest = NoNodeTest.getInstance();
                } else if (nodetype == "node") {
                    lppat.nodeTest = new NodeTypeTest(2);
                } else if (nodetype == "comment") {
                    lppat.nodeTest = NoNodeTest.getInstance();
                } else if (nodetype == "processing-instruction") {
                    lppat.nodeTest = NoNodeTest.getInstance();
                    if (this.t.currentToken == 3) {
                        this.t.next();
                    }
                }
                this.expect(10);
            } else {
                this.grumble("@ in pattern not followed by NameTest or NodeTest");
            }
            this.t.next();
            this.parseFilters(lppat);
            return lppat;
        }
        this.grumble("Axis in pattern must be child or attribute");
        return null;
    }

    private void parseFilters(LocationPathPattern path) throws XPathException {
        while (this.t.currentToken == 7) {
            this.t.next();
            Expression qual = this.parseExpression();
            this.expect(8);
            this.t.next();
            path.addFilter(qual);
        }
    }

    public void checkPatternFiltersUsesCurrent(Pattern pat) throws XPathException {
        if (pat instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pat;
            this.checkPatternFiltersUsesCurrent(unionPattern.getLHS());
            this.checkPatternFiltersUsesCurrent(unionPattern.getRHS());
        } else if (pat instanceof LocationPathPattern) {
            LocationPathPattern locationPathPattern = (LocationPathPattern)pat;
            Expression[] filters = locationPathPattern.getFilters();
            int numberOfFilters = locationPathPattern.getNumberOfFilters();
            if (numberOfFilters > 0 && filters != null && numberOfFilters <= filters.length) {
                for (int i = 0; i < numberOfFilters; ++i) {
                    if (filters[i] == null || !filters[i].usesCurrent()) continue;
                    this.grumble("The current() function may not be used in a pattern");
                }
            }
        }
    }
}

