/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Properties;
import ro.sync.licensemanager.base.LicenseInformation;
import ro.sync.licensemanager.base.LicenseMalformedException;

public final class LicenseFixupUtil {
    private static final String START_LICENSE_KEY = "START-LICENSE-KEY";
    private static final String END_LICENSE_KEY = "END-LICENSE-KEY";

    private LicenseFixupUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static String filterOutIllegalCharacters(String licenseText) throws LicenseMalformedException {
        if (licenseText == null) {
            throw new LicenseMalformedException("The license cannot be null");
        }
        StringBuilder lic = new StringBuilder();
        try {
            String line;
            ByteArrayInputStream bis = new ByteArrayInputStream(licenseText.getBytes(StandardCharsets.ISO_8859_1));
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(bis));
            while ((line = buffReader.readLine()) != null) {
                int pos = 0;
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (Character.isLetterOrDigit(c)) {
                        pos = i;
                        break;
                    }
                    if (i != line.length() - 1) continue;
                    pos = -1;
                }
                line = pos != -1 ? line.substring(pos) : "";
                lic.append(line).append('\n');
            }
        }
        catch (IOException ex) {
            throw new LicenseMalformedException("The license cannot be read due to: " + ex.getMessage());
        }
        return lic.toString();
    }

    private static String addNewLinesBeforeKeys(String licenseText) {
        int equalIndex = ((String)licenseText).indexOf(61);
        while (equalIndex != -1) {
            String licenseKey = null;
            boolean goNext = false;
            for (int charIndex = equalIndex - 1; charIndex >= 0; --charIndex) {
                char licenseChar = ((String)licenseText).charAt(charIndex);
                switch (licenseChar) {
                    case '\t': 
                    case ' ': {
                        licenseKey = ((String)licenseText).substring(charIndex + 1, equalIndex);
                        goNext = true;
                        break;
                    }
                    case '\n': {
                        goNext = true;
                    }
                }
                if (licenseKey != null && LicenseInformation.getLicenseKeys().contains(licenseKey)) {
                    licenseText = ((String)licenseText).substring(0, charIndex) + "\n" + ((String)licenseText).substring(charIndex + 1);
                    break;
                }
                if (goNext) break;
            }
            equalIndex = ((String)licenseText).indexOf(61, equalIndex + 1);
        }
        return licenseText;
    }

    public static String mergeBrokenLines(String licenseText) {
        StringBuilder result = new StringBuilder();
        String[] licenseLines = licenseText.split("\n");
        for (int i = 0; i < licenseLines.length; ++i) {
            boolean shouldMergeWithPreviousLine;
            String currentLineContent = licenseLines[i];
            boolean isKeyValueLine = currentLineContent.contains("=");
            boolean bl = shouldMergeWithPreviousLine = !isKeyValueLine && !LicenseFixupUtil.isLicenseLineIgnored(currentLineContent) && !currentLineContent.isBlank() && result.length() != 0;
            if (shouldMergeWithPreviousLine) {
                result.deleteCharAt(result.length() - 1);
            }
            result.append(currentLineContent);
            if (i >= licenseLines.length - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    private static boolean isLicenseLineIgnored(String currentLineContent) {
        return currentLineContent.toUpperCase(Locale.ROOT).contains(START_LICENSE_KEY) || currentLineContent.toUpperCase(Locale.ROOT).contains(END_LICENSE_KEY) || currentLineContent.contains("<pre>") || currentLineContent.contains("</pre>");
    }

    public static Properties getLicenseProperties(String licenseText) throws LicenseMalformedException {
        licenseText = LicenseFixupUtil.filterOutIllegalCharacters(licenseText);
        licenseText = LicenseFixupUtil.addNewLinesBeforeKeys(licenseText);
        licenseText = LicenseFixupUtil.mergeBrokenLines(licenseText);
        Properties properties = new Properties();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(licenseText.getBytes(StandardCharsets.ISO_8859_1));){
            properties.load(bis);
        }
        catch (IOException ex) {
            throw new LicenseMalformedException("The license cannot be read due to: " + ex.getMessage());
        }
        return properties;
    }
}

