/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.signature;

public class ServerSignature {
    public static final String MAC = "0";
    public static final String WILDCARD = "1";
    public static final String MAC_AND_SERVER_URL = "2";
    private String hardwareSignatureHash;
    private String serverUrlHash;
    private String type;

    public ServerSignature(String hashOfHardwareSignature, String hashOfServerUrl) {
        if (hashOfHardwareSignature == null) {
            throw new IllegalStateException();
        }
        this.hardwareSignatureHash = hashOfHardwareSignature;
        this.serverUrlHash = hashOfServerUrl;
        this.type = hashOfServerUrl != null ? MAC_AND_SERVER_URL : MAC;
    }

    public ServerSignature(String signature) {
        this.type = signature.substring(0, 1);
        String noPrefixSignature = signature.substring(1);
        if (MAC.equals(this.getType()) || WILDCARD.equals(this.getType())) {
            this.hardwareSignatureHash = noPrefixSignature;
        } else if (MAC_AND_SERVER_URL.equals(this.getType())) {
            int componentLength = noPrefixSignature.length() / 2;
            this.hardwareSignatureHash = noPrefixSignature.substring(0, componentLength);
            this.serverUrlHash = noPrefixSignature.substring(componentLength);
        }
    }

    public String toString() {
        return this.getType() + this.getHardwareSignatureHash() + (this.getServerUrlHash() != null ? this.getServerUrlHash() : "");
    }

    public String getHardwareSignatureHash() {
        return this.hardwareSignatureHash;
    }

    public String getServerUrlHash() {
        return this.serverUrlHash;
    }

    public String getType() {
        return this.type;
    }
}

