/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.base;

import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.StringListUtil;
import ro.sync.licensemanager.base.BasicLicenseInformationValidator;
import ro.sync.licensemanager.base.LicenseMalformedException;
import ro.sync.licensemanager.signature.ActivationSignature;

public class LicenseInformation {
    public static final int LICENSE_TYPE_8_DAYS = 8;
    public static final int LICENSE_TYPE_15_DAYS = 15;
    public static final int LICENSE_TYPE_31_DAYS = 31;
    public static final int LICENSE_TYPE_61_DAYS = 61;
    public static final int LICENSE_TYPE_75_DAYS = 75;
    public static final int LICENSE_TYPE_91_DAYS = 91;
    public static final int LICENSE_TYPE_121_DAYS = 121;
    public static final int LICENSE_TYPE_181_DAYS = 181;
    public static final int LICENSE_TYPE_183_DAYS = 183;
    public static final int LICENSE_TYPE_365_DAYS = 365;
    public static final int LICENSE_TYPE_366_DAYS = 366;
    public static final int LICENSE_NFR_366_DAYS = 366;
    public static final int LICENSE_NFR_183_DAYS = 183;
    public static final String SAXON_EE_LICENSED_ENV = "SAXON_EE_LICENSED_ENV";
    public static final String OXYGEN_LICENSED_ENV = "OXYGEN_LICENSED_ENV";
    private static final String REDUNDANCY_MARKER = " - Redundancy";
    public static final String CATEGORY_SUFFIX_ACADEMIC_CLASSROOM = "-Classroom";
    public static final String CATEGORY_SUFFIX_ACADEMIC_DEPARTMENTAL = "-Departmental";
    public static final String CATEGORY_SUFFIX_FLOATING = "-Floating";
    public static final String CATEGORY_SUFFIX_SITE = "-Site";
    public static final String CATEGORY_SUFFIX_CORPORATE = "-Corporate";
    private static final String EXTRA_INFO_START = " <<";
    private static final String EXTRA_INFO_END = ">>";
    private static final int LICENSE_COMPONENTS_EXPANED_YEAR = 2025;
    private static final Map<String, List<String>> IMPLICIT_COMPONENTS_MAP = Map.of("Web-Author", new ArrayList<String>(List.of("Author-WebApp", "Git", "Conc", "AI-Positron", "Diff-Srv")), "Content-Fusion", new ArrayList<String>(List.of("Conc", "AI-Positron", "Diff-Srv")));
    int numberOfLicenses;
    int numberOfSites;
    int numberOfAuthors;
    int numberOfSMEs;
    String registrationName;
    String company;
    private LicenseKind licenseKind = LicenseKind.TRIAL;
    int duration;
    Date startDate;
    private Date expireDate;
    String version;
    List<String> components;
    List<String> implicitComponents;
    String category;
    String signature;
    public static final String LI_REGISTRATION_NAME = "Registration_Name";
    public static final String LI_COMPANY = "Company";
    public static final String LI_CATEGORY = "Category";
    public static final String LI_NUMBER_OF_SITES = "Number_of_Sites";
    public static final String LI_NUMBER_OF_LICENSES = "Number_of_Licenses";
    public static final String PERSONAL_USE_STRING = "Personal Use";
    public static final String LI_VERSION = "Version";
    public static final String LI_COMPONENT = "Component";
    public static final String LI_START_DATE = "Date";
    public static final String LI_TRIAL = "Trial";
    public static final String LI_SUBSCRIPTION = "Subscription";
    public static final String LI_NFR = "Not-For-Resale";
    public static final String LI_DEVELOPMENT = "Development";
    public static final String LI_IS_EVALUATION = "EvaluationOnly";
    public static final String LI_MAINTENANCE = "Maintenance";
    public static final String LI_SIGNATURE = "SGN";
    public static final String LI_NUMBER_OF_AUTHORS = "Number_of_Authors";
    public static final String LI_NUMBER_OF_SMES = "Number_of_SMEs";
    private URL licenseLocation;
    private static final String BUY_SUBSCRIPTION_RENEWAL_PHP = "http://oxygenxml.com/subscription_management/buy_renewal.php";
    private Properties additionalProperties;
    private static final Map<LicenseKind, String> LICENSE_KIND_TO_STRING_MAP;
    private static final List<String> MANAGED_NAMED_USER_LICENSE_CATEGORIES;
    private static final Map<LicenseKind, String> LICENSE_KIND_TO_LICENSE_INFO_KEY_MAP;
    private static final List<String> LICENSE_KEYS;

    public LicenseInformation(Properties properties) throws LicenseMalformedException {
        this.setRegistrationName(properties.getProperty(LI_REGISTRATION_NAME));
        this.setCompany(properties.getProperty(LI_COMPANY));
        if ("Personal".equals(properties.getProperty(LI_CATEGORY))) {
            if (!"1".equals(properties.getProperty(LI_NUMBER_OF_LICENSES))) {
                throw new LicenseMalformedException("Number of licenses cannot be different than 1 if license category is Personal");
            }
            this.setCompany(PERSONAL_USE_STRING);
        }
        BasicLicenseInformationValidator.checkLicenseInformation(properties);
        this.signature = properties.getProperty(LI_SIGNATURE);
        DateFormat dateFormat = LicenseInformation.getDateFormat();
        try {
            String dateString = properties.getProperty(LI_START_DATE).trim();
            Date date = dateFormat.parse(dateString);
            this.setStartDate(date, dateFormat);
        }
        catch (ParseException ex) {
            throw new LicenseMalformedException("Unparsable date: " + properties.getProperty(LI_START_DATE));
        }
        this.setAndValidateQuantity(properties);
        int trialDuration = this.setLicenseKindAndDuration(properties);
        List extractedComponents = StringListUtil.extractStringList((String)properties.getProperty(LI_COMPONENT), (boolean)true, (boolean)false, null);
        this.setComponents(extractedComponents);
        this.implicitComponents = this.getImplicitLicenseComponents(extractedComponents);
        this.setVersion((String)StringListUtil.extractStringList((String)properties.getProperty(LI_VERSION), (boolean)true, (boolean)false, null).get(0));
        this.setCategory(properties.getProperty(LI_CATEGORY));
        this.setExpireDate(this.startDate, trialDuration, dateFormat);
        this.additionalProperties = new Properties();
        this.additionalProperties.putAll((Map<?, ?>)properties);
        this.additionalProperties.remove(LI_REGISTRATION_NAME);
        this.additionalProperties.remove(LI_COMPANY);
        this.additionalProperties.remove(LI_CATEGORY);
        this.additionalProperties.remove(LI_NUMBER_OF_LICENSES);
        this.additionalProperties.remove(LI_SIGNATURE);
        this.additionalProperties.remove(LI_START_DATE);
        this.additionalProperties.remove(LI_COMPONENT);
        this.additionalProperties.remove(LI_VERSION);
        this.additionalProperties.remove(LI_COMPANY);
        this.additionalProperties.remove(LI_TRIAL);
        this.additionalProperties.remove(LI_SUBSCRIPTION);
        this.additionalProperties.remove(LI_NFR);
        this.additionalProperties.remove(LI_DEVELOPMENT);
        this.additionalProperties.remove(LI_IS_EVALUATION);
        this.additionalProperties.remove(LI_MAINTENANCE);
        ArrayList<Object> keysToRemove = new ArrayList<Object>();
        for (Object key : this.additionalProperties.keySet()) {
            String keyString = ((String)key).trim().toUpperCase();
            if (!keyString.contains("START-LICENSE-KEY") && !keyString.contains("END-LICENSE-KEY")) continue;
            keysToRemove.add(key);
        }
        for (Object key : keysToRemove) {
            this.additionalProperties.remove(key);
        }
    }

    private void setAndValidateQuantity(Properties properties) throws LicenseMalformedException {
        if (properties.containsKey(LI_NUMBER_OF_LICENSES)) {
            try {
                this.numberOfLicenses = NumberParserUtil.parseInt((String)properties.getProperty(LI_NUMBER_OF_LICENSES).trim());
            }
            catch (ro.sync.basic.util.NumberFormatException ex) {
                throw new LicenseMalformedException("Unparsable number of licenses: " + properties.getProperty(LI_NUMBER_OF_LICENSES));
            }
        } else if (properties.containsKey(LI_NUMBER_OF_SITES)) {
            try {
                this.numberOfSites = NumberParserUtil.parseInt((String)properties.getProperty(LI_NUMBER_OF_SITES).trim());
            }
            catch (ro.sync.basic.util.NumberFormatException ex) {
                throw new LicenseMalformedException("Unparsable number of sites: " + properties.getProperty(LI_NUMBER_OF_SITES));
            }
        } else if (properties.containsKey(LI_NUMBER_OF_AUTHORS)) {
            this.setAndValidateDualUsersQuantity(properties);
        }
    }

    private void setAndValidateDualUsersQuantity(Properties properties) throws LicenseMalformedException {
        try {
            this.numberOfAuthors = NumberParserUtil.parseInt((String)properties.getProperty(LI_NUMBER_OF_AUTHORS).trim());
        }
        catch (ro.sync.basic.util.NumberFormatException ex) {
            throw new LicenseMalformedException("Unparsable number of Authors: " + properties.getProperty(LI_NUMBER_OF_AUTHORS));
        }
        try {
            this.numberOfSMEs = NumberParserUtil.parseInt((String)properties.getProperty(LI_NUMBER_OF_SMES).trim());
        }
        catch (ro.sync.basic.util.NumberFormatException ex) {
            throw new LicenseMalformedException("Unparsable number of SMEs: " + properties.getProperty(LI_NUMBER_OF_SMES));
        }
    }

    private int setLicenseKindAndDuration(Properties properties) throws LicenseMalformedException {
        LicenseKind licKind = null;
        int durationDays = 0;
        boolean useDurationDays = true;
        String evaluation = properties.getProperty(LI_IS_EVALUATION, "false");
        String trial = properties.getProperty(LI_TRIAL);
        String subscription = properties.getProperty(LI_SUBSCRIPTION);
        String nfr = properties.getProperty(LI_NFR);
        String development = properties.getProperty(LI_DEVELOPMENT);
        String maintenance = properties.getProperty(LI_MAINTENANCE);
        if (Boolean.parseBoolean(evaluation.trim())) {
            licKind = LicenseKind.EVALUATION;
            durationDays = 366;
        } else {
            if (trial != null) {
                licKind = LicenseKind.TRIAL;
                try {
                    durationDays = NumberParserUtil.parseInt((String)trial.trim());
                }
                catch (ro.sync.basic.util.NumberFormatException ex) {
                    throw new LicenseMalformedException("Unparsable trial duration: " + trial);
                }
            }
            if (subscription != null) {
                licKind = LicenseKind.SUBSCRIPTION;
                try {
                    durationDays = NumberParserUtil.parseInt((String)subscription.trim());
                }
                catch (ro.sync.basic.util.NumberFormatException ex) {
                    throw new LicenseMalformedException("Unparsable license subscription: " + subscription);
                }
            }
            if (nfr != null) {
                licKind = LicenseKind.NOT_FOR_RESALE;
                durationDays = 366;
                try {
                    durationDays = NumberParserUtil.parseInt((String)nfr.trim());
                }
                catch (ro.sync.basic.util.NumberFormatException ex) {}
            } else if (development != null) {
                licKind = LicenseKind.DEVELOPMENT;
                durationDays = 366;
                try {
                    durationDays = NumberParserUtil.parseInt((String)development.trim());
                }
                catch (ro.sync.basic.util.NumberFormatException ex) {}
            } else {
                licKind = LicenseKind.PERMANENT;
                try {
                    durationDays = NumberParserUtil.parseInt((String)maintenance.trim());
                }
                catch (ro.sync.basic.util.NumberFormatException ex) {
                    throw new LicenseMalformedException("Unparsable license maintenance: " + maintenance);
                }
                useDurationDays = false;
            }
        }
        this.setLicenseKind(licKind);
        this.setDuration(durationDays);
        return useDurationDays ? durationDays : 0;
    }

    @Deprecated
    public LicenseInformation(String name, String company, LicenseKind licenseKind, int duration, Date startDate, List<String> components, String version, String category, int numberOfLicenses) throws LicenseMalformedException {
        this(name, company, licenseKind, duration, startDate, components, version, category, numberOfLicenses, LicenseInformation.computeAdditionalPropertiesForFeedback(components, numberOfLicenses));
    }

    @Deprecated
    private static Properties computeAdditionalPropertiesForFeedback(List<String> components, int numberOfLicenses) {
        Properties additionalProperties = new Properties();
        if (components.get(0).equals("Feedback")) {
            additionalProperties.put(LI_NUMBER_OF_SITES, String.valueOf(numberOfLicenses));
        }
        return additionalProperties;
    }

    public LicenseInformation(String name, String company, LicenseKind licenseKind, int duration, Date startDate, List<String> components, String version, String category, int numberOfLicenses, Properties additionalProperties) throws LicenseMalformedException {
        this.additionalProperties = additionalProperties;
        if (licenseKind == LicenseKind.EVALUATION) {
            duration = 366;
        }
        this.setRegistrationName(name);
        this.setCompany(company);
        this.setLicenseKind(licenseKind);
        this.setDuration(duration);
        this.setComponents(components);
        this.setVersion(version);
        if (category.startsWith("SVN-")) {
            category = category.substring("SVN-".length());
        }
        this.setCategory(category);
        this.setExpireDate(startDate, licenseKind != LicenseKind.PERMANENT ? duration : 0, LicenseInformation.getDateFormat());
        if (components.get(0).equals("Feedback")) {
            this.numberOfSites = numberOfLicenses;
        } else {
            this.numberOfLicenses = numberOfLicenses;
        }
        this.implicitComponents = this.getImplicitLicenseComponents(components);
        if (additionalProperties.containsKey(LI_NUMBER_OF_AUTHORS)) {
            numberOfLicenses = 0;
            this.numberOfAuthors = Integer.parseInt(additionalProperties.getProperty(LI_NUMBER_OF_AUTHORS));
            this.numberOfSMEs = Integer.parseInt(additionalProperties.getProperty(LI_NUMBER_OF_SMES));
        }
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("MM-dd-yyyy", Locale.US);
    }

    private void setRegistrationName(String registrationName) throws LicenseMalformedException {
        if (registrationName != null) {
            registrationName = registrationName.trim();
        }
        if (registrationName == null || registrationName.isEmpty()) {
            throw new LicenseMalformedException("Registration name cannot be void");
        }
        this.registrationName = registrationName;
    }

    private List<String> getImplicitLicenseComponents(List<String> extractedComponents) {
        Calendar calendar = new Calendar.Builder().setLocale(Locale.US).setInstant(this.startDate.toInstant().toEpochMilli()).build();
        if (calendar.get(1) < 2025) {
            boolean isWebAuthorLicense = extractedComponents.stream().anyMatch(component -> component.split("@")[0].equals("Web-Author"));
            if (isWebAuthorLicense) {
                return IMPLICIT_COMPONENTS_MAP.get("Web-Author");
            }
            for (Map.Entry<String, List<String>> entry : IMPLICIT_COMPONENTS_MAP.entrySet()) {
                if (!extractedComponents.contains(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return new ArrayList<String>();
    }

    public void setComponents(List<String> components) throws LicenseMalformedException {
        if (components == null || components.isEmpty()) {
            throw new LicenseMalformedException("Components cannot be null");
        }
        for (int i = 0; i < components.size(); ++i) {
            components.set(i, components.get(i).trim());
        }
        this.components = components;
    }

    private void setCompany(String company) {
        this.company = company == null ? "" : company.trim();
    }

    private void setVersion(String version) throws LicenseMalformedException {
        if (version == null || version.trim().isEmpty()) {
            throw new LicenseMalformedException("Version cannot be void");
        }
        this.version = version.trim();
    }

    private void setLicenseKind(LicenseKind licenseKind) {
        this.licenseKind = licenseKind;
    }

    private void setDuration(int duration) {
        this.duration = duration;
    }

    private void setStartDate(Date startDate, DateFormat dateFormat) {
        try {
            this.startDate = dateFormat.parse(dateFormat.format(startDate));
        }
        catch (NumberFormatException | ParseException ex) {
            this.startDate = startDate;
        }
    }

    private void setExpireDate(Date startDate, int duration, DateFormat dateFormat) {
        this.setStartDate(startDate, dateFormat);
        long end = this.startDate.getTime();
        if (duration > 0) {
            end += (long)duration * 86400000L;
        }
        this.expireDate = new Date(end);
    }

    private void setCategory(String category) throws LicenseMalformedException {
        if (category == null || category.trim().isEmpty()) {
            throw new LicenseMalformedException("License category cannot be void");
        }
        this.category = category.trim();
    }

    public void setActivation(ActivationSignature activationSignature) {
        if (activationSignature != null) {
            this.registrationName = this.registrationName + EXTRA_INFO_START + activationSignature.toString() + EXTRA_INFO_END;
        }
    }

    public String getName() {
        return this.registrationName;
    }

    public String getNameForDisplay() {
        String name = this.registrationName;
        int index = this.registrationName.indexOf(EXTRA_INFO_START);
        if (index > 0) {
            name = this.registrationName.substring(0, index);
        }
        if ((index = name.lastIndexOf(REDUNDANCY_MARKER)) > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public String getCompany() {
        return this.company;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getComponents() {
        if (this.implicitComponents != null && !this.implicitComponents.isEmpty()) {
            ArrayList<String> allCompomnents = new ArrayList<String>(this.components);
            allCompomnents.addAll(this.implicitComponents);
            return allCompomnents;
        }
        return this.components;
    }

    public List<String> getComponentsRaw() {
        return this.components;
    }

    public int getDuration() {
        return this.duration;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public String getCategory() {
        return this.category;
    }

    public String getActivation() {
        String activationPart;
        int index;
        String activation = null;
        if (this.registrationName != null && (index = this.registrationName.lastIndexOf(EXTRA_INFO_START)) > 0 && (activationPart = this.registrationName.substring(index + EXTRA_INFO_START.length())).endsWith(EXTRA_INFO_END)) {
            activation = activationPart.substring(0, activationPart.length() - EXTRA_INFO_END.length());
        }
        return activation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(126).append("License for: ").append(this.registrationName).append("\nLicense category: ").append(this.category).append("\nCompany: ").append(this.company).append('\n');
        String kindString = LICENSE_KIND_TO_STRING_MAP.get((Object)this.getLicenseKind());
        if (kindString != null) {
            stringBuilder.append(kindString);
        }
        if (!this.isNotForResale() && !this.isSubscription()) {
            stringBuilder.append(this.getLicenseKind() != LicenseKind.PERMANENT ? "Duration: " : "Maintenance: ");
            stringBuilder.append(this.duration).append('\n');
        }
        stringBuilder.append("Licenses: ").append(this.numberOfLicenses).append("\nComponents: ").append(this.components).append("\nVersion: ").append(this.version).append("\nStart date: ").append(this.startDate).append("\nExpire date: ").append(this.expireDate).append('\n');
        return stringBuilder.toString();
    }

    public int getNumberOfLicenses() {
        return this.numberOfLicenses;
    }

    public int getNumberOfSites() {
        return this.numberOfSites;
    }

    public boolean equals(Object obj) {
        boolean same;
        boolean bl = same = this == obj;
        if (!same && obj != null && obj.getClass() == this.getClass()) {
            LicenseInformation other = (LicenseInformation)obj;
            same = this.getLicenseKind() == other.getLicenseKind() && this.duration == other.duration && this.numberOfLicenses == other.numberOfLicenses && Equaler.verifyEquals((Object)this.registrationName, (Object)other.registrationName) && Equaler.verifyEquals((Object)this.company, (Object)other.company) && Equaler.verifyEquals((Object)this.startDate, (Object)other.startDate) && Equaler.verifyEquals(this.components, other.components) && Equaler.verifyEquals((Object)this.version, (Object)other.version) && Equaler.verifyEquals((Object)this.category, (Object)other.category);
        }
        return same;
    }

    public int hashCode() {
        int hashCode = this.getLicenseKind().hashCode() + this.duration;
        if (this.registrationName != null) {
            hashCode += this.registrationName.hashCode();
        }
        if (this.category != null) {
            hashCode += this.category.hashCode();
        }
        return hashCode;
    }

    public static boolean isFloatingLicense(String category) {
        return category != null && category.endsWith(CATEGORY_SUFFIX_FLOATING);
    }

    public static boolean isManagedNamedUserLicense(String category) {
        return MANAGED_NAMED_USER_LICENSE_CATEGORIES.contains(category);
    }

    public void store(Properties properties) {
        properties.put(LI_REGISTRATION_NAME, this.registrationName);
        properties.put(LI_COMPANY, this.company);
        properties.put(LI_START_DATE, LicenseInformation.getDateFormat().format(this.startDate));
        this.putLicenseInfoData(properties, this.getLicenseKind());
        if (this.numberOfSites <= 0 && this.numberOfAuthors <= 0 && this.numberOfLicenses > 0) {
            properties.put(LI_NUMBER_OF_LICENSES, String.valueOf(this.numberOfLicenses));
        }
        properties.put(LI_CATEGORY, this.category);
        properties.put(LI_SIGNATURE, this.signature);
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            buf1.append(this.components.get(i));
            if (i >= size - 1) continue;
            buf1.append(", ");
        }
        buf2.append(this.version);
        properties.put(LI_COMPONENT, buf1.toString());
        properties.put(LI_VERSION, buf2.toString());
        properties.putAll((Map<?, ?>)this.additionalProperties);
    }

    private void putLicenseInfoData(Properties properties, LicenseKind liKind) {
        switch (liKind) {
            case TRIAL: 
            case PERMANENT: 
            case SUBSCRIPTION: 
            case NOT_FOR_RESALE: 
            case DEVELOPMENT: {
                properties.put(LICENSE_KIND_TO_LICENSE_INFO_KEY_MAP.get((Object)liKind), String.valueOf(this.duration));
                break;
            }
            case EVALUATION: {
                properties.put(LI_IS_EVALUATION, "true");
                break;
            }
            default: {
                System.err.println("Unknown type of license: " + liKind);
            }
        }
    }

    public String getVersion(String component) {
        if (component != null && this.components.contains(component)) {
            return this.version;
        }
        return null;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean isPermanentLicense() {
        return this.getLicenseKind() == LicenseKind.PERMANENT;
    }

    public boolean isEvaluationOnly() {
        return this.getLicenseKind() == LicenseKind.EVALUATION;
    }

    public boolean isSubscription() {
        return this.getLicenseKind() == LicenseKind.SUBSCRIPTION;
    }

    public boolean isNotForResale() {
        return this.getLicenseKind() == LicenseKind.NOT_FOR_RESALE;
    }

    public boolean isTrial() {
        return this.getLicenseKind() == LicenseKind.TRIAL;
    }

    public boolean isDevelopmentOnly() {
        return this.getLicenseKind() == LicenseKind.DEVELOPMENT;
    }

    public boolean isFloating() {
        return LicenseInformation.isFloatingLicense(this.category);
    }

    public boolean isManagedNamedUser() {
        return LicenseInformation.isManagedNamedUserLicense(this.category);
    }

    public boolean isForRedundancy() {
        String name = this.registrationName;
        int index = name.indexOf(EXTRA_INFO_START);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name.endsWith(REDUNDANCY_MARKER);
    }

    public static List<String> getLicenseKeys() {
        return LICENSE_KEYS;
    }

    public void setLicenseExternalLocation(URL licenseLocation) {
        this.licenseLocation = licenseLocation;
    }

    public URL getLicenseExternalLocation() {
        return this.licenseLocation;
    }

    public String generateBuyLink() {
        StringBuilder buyLink = new StringBuilder(BUY_SUBSCRIPTION_RENEWAL_PHP);
        if (this.getLicenseKind() == LicenseKind.SUBSCRIPTION) {
            String params = "?Category={0}&Component={1}&Number_of_Licenses={2}&Subscription={3}";
            buyLink.append(MessageFormat.format(params, this.category, this.components, this.numberOfLicenses, 366));
        }
        return buyLink.toString();
    }

    public LicenseKind getLicenseKind() {
        return this.licenseKind;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }

    static {
        HashMap<LicenseKind, String> liKindToStringMap = new HashMap<LicenseKind, String>(5);
        liKindToStringMap.put(LicenseKind.TRIAL, "IsTrial: true\n");
        liKindToStringMap.put(LicenseKind.SUBSCRIPTION, "IsSubscription: true\n");
        liKindToStringMap.put(LicenseKind.EVALUATION, "IsEvaluation: true\n");
        liKindToStringMap.put(LicenseKind.NOT_FOR_RESALE, "IsNot-For-Resale: true\n");
        liKindToStringMap.put(LicenseKind.DEVELOPMENT, "IsDevelopment: true\n");
        LICENSE_KIND_TO_STRING_MAP = Collections.unmodifiableMap(liKindToStringMap);
        MANAGED_NAMED_USER_LICENSE_CATEGORIES = Arrays.asList("Professional", "Enterprise");
        EnumMap<LicenseKind, String> kindToKeyMap = new EnumMap<LicenseKind, String>(LicenseKind.class);
        kindToKeyMap.put(LicenseKind.TRIAL, LI_TRIAL);
        kindToKeyMap.put(LicenseKind.PERMANENT, LI_MAINTENANCE);
        kindToKeyMap.put(LicenseKind.EVALUATION, LI_IS_EVALUATION);
        kindToKeyMap.put(LicenseKind.SUBSCRIPTION, LI_SUBSCRIPTION);
        kindToKeyMap.put(LicenseKind.NOT_FOR_RESALE, LI_NFR);
        kindToKeyMap.put(LicenseKind.DEVELOPMENT, LI_DEVELOPMENT);
        LICENSE_KIND_TO_LICENSE_INFO_KEY_MAP = Collections.unmodifiableMap(kindToKeyMap);
        LICENSE_KEYS = Collections.unmodifiableList(Arrays.asList(LI_COMPANY, LI_CATEGORY, LI_COMPONENT, LI_VERSION, LI_NUMBER_OF_LICENSES, LI_REGISTRATION_NAME, LI_START_DATE, LI_TRIAL, LI_SUBSCRIPTION, LI_MAINTENANCE, LI_NFR, LI_DEVELOPMENT, LI_IS_EVALUATION, LI_NUMBER_OF_SITES, LI_SIGNATURE));
    }

    public static enum LicenseKind {
        PERMANENT,
        TRIAL,
        SUBSCRIPTION,
        EVALUATION,
        NOT_FOR_RESALE,
        DEVELOPMENT;

    }
}

