/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.base;

import java.util.Properties;
import ro.sync.licensemanager.base.LicenseMalformedException;

public final class BasicLicenseInformationValidator {
    private BasicLicenseInformationValidator() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static void checkNotNull(Object toCheck, String message) throws LicenseMalformedException {
        if (toCheck == null) {
            throw new LicenseMalformedException(message);
        }
    }

    private static void checkAnyNotNull(Object[] objects, String message) throws LicenseMalformedException {
        boolean empty = true;
        for (Object object : objects) {
            if (object == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            throw new LicenseMalformedException(message);
        }
    }

    private static void checkStartDate(String startDate) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(startDate, "Start date cannot be void");
    }

    private static void checkNumberOfLicenses(String licensesNo) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(licensesNo, "Number of licenses cannot be void");
    }

    private static void checkNumberOfSites(String sitesNo) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(sitesNo, "Number of sites cannot be void");
    }

    private static void checkDuration(String[] duration) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkAnyNotNull(duration, "No Trial, Subscription, NFR, Development or Maintenance period specified");
    }

    private static void checkComponent(String component) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(component, "Component is not specified");
    }

    private static void checkVersion(String version) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(version, "Version is not specified");
    }

    private static void checkSignature(String signature) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(signature, "The signature is not specified.");
    }

    public static void checkLicenseInformation(Properties properties) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkStartDate(properties.getProperty("Date"));
        if (properties.containsKey("Number_of_Sites")) {
            BasicLicenseInformationValidator.checkNumberOfSites(properties.getProperty("Number_of_Sites"));
        } else if (properties.containsKey("Number_of_Authors")) {
            String numbeOfAuthorsPropertyValue = properties.getProperty("Number_of_Authors");
            BasicLicenseInformationValidator.checkNumberOfAuthors(numbeOfAuthorsPropertyValue);
            String numbeOfSMEsPropertyValue = properties.getProperty("Number_of_SMEs");
            BasicLicenseInformationValidator.checkNumberOfSMEs(numbeOfSMEsPropertyValue);
        } else {
            BasicLicenseInformationValidator.checkNumberOfLicenses(properties.getProperty("Number_of_Licenses"));
        }
        BasicLicenseInformationValidator.checkDuration(new String[]{properties.getProperty("Trial"), properties.getProperty("Subscription"), properties.getProperty("Not-For-Resale"), properties.getProperty("Development"), properties.getProperty("Maintenance"), properties.getProperty("EvaluationOnly")});
        BasicLicenseInformationValidator.checkComponent(properties.getProperty("Component"));
        BasicLicenseInformationValidator.checkVersion(properties.getProperty("Version"));
        BasicLicenseInformationValidator.checkSignature(properties.getProperty("SGN"));
    }

    private static void checkNumberOfAuthors(String numbeOfAuthorsPropertyValue) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(numbeOfAuthorsPropertyValue, "Number of Authors cannot be void");
    }

    private static void checkNumberOfSMEs(String numbeOfSMEsPropertyValue) throws LicenseMalformedException {
        BasicLicenseInformationValidator.checkNotNull(numbeOfSMEsPropertyValue, "Number of SMEs cannot be void");
    }
}

