/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.samples;

import com.oxygenxml.samples.SamplesFile;
import com.oxygenxml.samples.SamplesFileProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;

class SamplesURLConnection
extends URLConnection
implements FileBrowsingConnection {
    private boolean isReadOnly;
    private SamplesFileProvider samplesFileProvider;

    public SamplesURLConnection(SamplesFileProvider samplesFileProvider, URL url) {
        super(url);
        this.samplesFileProvider = samplesFileProvider;
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String option = optionsStorage.getOption("samples_readonly", "off");
        this.isReadOnly = "on".equals(option);
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException, UserActionRequiredException {
        SamplesFile samplesFile = this.samplesFileProvider.getTargetFile(this.url.getFile());
        Set<String> relativePaths = this.listFiles(samplesFile, this.samplesFileProvider.getOriginalFilesRootDir());
        return relativePaths.stream().sorted().map(FolderEntryDescriptor::new).collect(Collectors.toList());
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        SamplesFile samplesFile = this.samplesFileProvider.getTargetFile(this.url.getPath());
        if (samplesFile.getModifiedFile().exists()) {
            byte[] encryptedBytes = Files.readAllBytes(samplesFile.getModifiedFile().toPath());
            String encryptedBytesAsString = new String(encryptedBytes, StandardCharsets.UTF_8);
            String decyptedString = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(encryptedBytesAsString);
            byte[] base64Bytes = decyptedString.getBytes(StandardCharsets.UTF_8);
            byte[] rawBytes = Base64.getDecoder().decode(base64Bytes);
            return new ByteArrayInputStream(rawBytes);
        }
        return new FileInputStream(samplesFile.getOriginalFile());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isReadOnly) {
            throw new IOException("sample document is read-only");
        }
        SamplesFile samplesFile = this.samplesFileProvider.getTargetFile(this.url.getPath());
        final File modifiedFile = samplesFile.getModifiedFile();
        modifiedFile.getParentFile().mkdirs();
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                byte[] rawBytes = this.toByteArray();
                byte[] base64Bytes = Base64.getEncoder().encode(rawBytes);
                String bytesAsString = new String(base64Bytes, StandardCharsets.UTF_8);
                String encryptedString = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(bytesAsString);
                byte[] encryptedBytes = encryptedString.getBytes(StandardCharsets.UTF_8);
                try (FileOutputStream fileOutputStream = new FileOutputStream(modifiedFile);){
                    fileOutputStream.write(encryptedBytes);
                }
            }
        };
    }

    private Set<String> listFiles(SamplesFile samplesFile, File rootDir) throws FileNotFoundException {
        HashSet<String> relativePaths = new HashSet<String>();
        if (!samplesFile.getOriginalFile().exists() && !samplesFile.getOriginalFile().exists()) {
            throw new FileNotFoundException();
        }
        if (samplesFile.getOriginalFile().exists()) {
            relativePaths.addAll(this.list(samplesFile.getOriginalFile(), rootDir));
        }
        if (samplesFile.getModifiedFile().exists()) {
            relativePaths.addAll(this.list(samplesFile.getModifiedFile(), rootDir));
        }
        return relativePaths;
    }

    private List<String> list(File dir, File rootDir) {
        File[] files;
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory() && file.getName().startsWith(".")) continue;
            Path relativize = rootDir.toPath().relativize(file.toPath());
            Object relativePath = relativize.toFile().getPath().replaceAll("\\\\", "/");
            if (file.isDirectory()) {
                relativePath = (String)relativePath + "/";
            }
            relativePaths.add((String)relativePath);
        }
        return relativePaths;
    }
}

