/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.samples;

import com.oxygenxml.samples.SamplesFile;
import com.oxygenxml.samples.SamplesFileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletOutputStream;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.plugin.PluginContext;

public class SamplesServlet
extends ServletPluginExtension {
    @PluginContext
    private SamplesFileProvider samplesFileProvider;

    public String getPath() {
        return "samples-files";
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Description", "File-Transfer");
        String sampleFileParam = request.getParameter("sampleFilePath");
        SamplesFile samplesFile = this.samplesFileProvider.getTargetFile(sampleFileParam);
        File targetFile = samplesFile.getModifiedFile().exists() ? samplesFile.getModifiedFile() : samplesFile.getOriginalFile();
        String fileName = targetFile.getName();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        try (FileInputStream in = new FileInputStream(targetFile);
             ServletOutputStream out = response.getOutputStream();){
            int numBytesRead;
            byte[] buffer = new byte[1024];
            while ((numBytesRead = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, numBytesRead);
            }
        }
        super.doGet(request, response);
    }
}

