/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.samples;

import com.oxygenxml.samples.SamplesFile;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import ro.sync.basic.io.FileSystemUtil;

public class SamplesFileProvider {
    private File samplesDir;
    private File samplesModifiedDir;

    public void initRootDir(File rootDir) {
        try {
            this.samplesDir = rootDir.getCanonicalFile();
            this.samplesModifiedDir = new File(this.samplesDir, ".modified");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public File getOriginalFilesRootDir() {
        return this.samplesDir;
    }

    public File getModifiedFilesRootDir() {
        return this.samplesModifiedDir;
    }

    public SamplesFile getTargetFile(String filePath) {
        File originalFile = new File(this.samplesDir, filePath);
        this.validateFile(originalFile);
        File modifiedFile = new File(this.samplesModifiedDir, filePath);
        return new SamplesFile(originalFile, modifiedFile);
    }

    private void validateFile(File targetFile) {
        try {
            boolean isInsideSamples = FileSystemUtil.isAncestor((File)this.samplesDir, (File)targetFile.getCanonicalFile());
            if (!isInsideSamples) {
                throw new IllegalArgumentException();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

