/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.samples;

import com.oxygenxml.samples.SamplesFileProvider;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginConfigExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.exml.plugin.PluginContext;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class SamplesConfigExtension
extends ServletPluginConfigExtension {
    private static final Logger log = LoggerFactory.getLogger(SamplesConfigExtension.class);
    public static final String READONLY_MODE = "samples_readonly";
    @PluginContext
    private SamplesFileProvider samplesRootDirProvider;

    public void init() throws ServletException {
        super.init();
        HashMap<String, String> defaultOptions = new HashMap<String, String>();
        defaultOptions.put(READONLY_MODE, "off");
        this.setDefaultOptions(defaultOptions);
        File dataDir = (File)this.config.getServletContext().getAttribute("OXYGEN_WEBAPP_DATA_DIR");
        File samplesDir = new File(dataDir, "samples/");
        if (!samplesDir.exists() || samplesDir.listFiles().length == 0) {
            log.warn("No sample document found at {}", (Object)samplesDir);
        }
        this.samplesRootDirProvider.initRootDir(samplesDir);
    }

    public String getOptionsForm() {
        boolean readonly = "on".equals(this.getOption(READONLY_MODE, "off"));
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        String form = "<div style='font-family:robotolight, Arial, Helvetica, sans-serif;font-size:0.85em;font-weight: lighter'><form style='text-align:left;line-height: 1.7em;'><label style='margin-bottom:6px;display:block;overflow:hidden'><input name='samples_readonly' type='checkbox' value='on'" + (readonly ? " checked" : "") + ">" + rb.getMessage("Readonly_mode") + "</label>";
        return form;
    }

    public String getOptionsJson() {
        return "{\"samples_readonly\": \"" + this.getOption(READONLY_MODE, "off") + "\"}";
    }

    public String getPath() {
        return "samples-options";
    }
}

