/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ForceUniqueFilter
extends AbstractXMLFilter {
    private final Map<URI, Integer> topicrefCount = new HashMap<URI, Integer>();
    private final Deque<Boolean> ignoreStack = new ArrayDeque<Boolean>();
    public final Map<Job.FileInfo, Job.FileInfo> copyToMap = new HashMap<Job.FileInfo, Job.FileInfo>();
    private TempFileNameScheme tempFileNameScheme;
    private final Deque<Optional<String>> classElementStack = new ArrayDeque<Optional<String>>();
    private final Deque<ParentTopicref> topicrefParentsStack = new ArrayDeque<ParentTopicref>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.ignoreStack.push(Constants.MAP_RELTABLE.matches(atts) ? false : this.ignoreStack.isEmpty() || this.ignoreStack.peek() != false);
        String classValue = atts.getValue("class");
        this.classElementStack.addFirst(Optional.ofNullable(classValue));
        Attributes res = atts;
        if (this.ignoreStack.peek().booleanValue() && Constants.MAP_TOPICREF.matches(res)) {
            URI href = URLUtils.toURI(res.getValue("href"));
            URI copyTo = URLUtils.toURI(res.getValue("copy-to"));
            URI source = copyTo != null ? copyTo : href;
            String currentScope = res.getValue("scope");
            String scope = this.getCascadingScope(currentScope);
            String format = res.getValue("format");
            String currentProcesingResource = res.getValue("processing-role");
            String processingRole = this.getCascadingProcessingRole(currentProcesingResource);
            Job.FileInfo dstFi = null;
            if (source != null && DitaUtils.isLocalScope(scope) && (format == null || format.equals("dita")) && (processingRole == null || processingRole.equals("normal"))) {
                Job.FileInfo srcFi;
                Comparable<Integer> parentHref;
                URI file = URLUtils.stripFragment(source);
                Integer count = this.topicrefCount.getOrDefault(file, 0);
                ParentTopicref parentTopicref = this.topicrefParentsStack.peek();
                boolean parentTopicHasEmbededSubtopics = false;
                if (parentTopicref != null && parentTopicref.href != null) {
                    parentHref = URLUtils.stripFragment(parentTopicref.href);
                    boolean bl = parentTopicHasEmbededSubtopics = href != null && ((URI)parentHref).equals(file) && href.getFragment() != null;
                }
                if (parentTopicHasEmbededSubtopics) {
                    dstFi = parentTopicref.dstFi;
                } else {
                    parentHref = count;
                    count = count + 1;
                    this.topicrefCount.put(file, count);
                }
                if (count > 1 && (srcFi = this.job.getFileInfo(this.currentFile.resolve(URLUtils.stripFragment(source)))) != null) {
                    if (dstFi == null) {
                        dstFi = this.generateCopyToTarget(srcFi, count);
                    }
                    this.copyToMap.put(dstFi, srcFi);
                    URI dstTempAbs = this.job.tempDirURI.resolve(dstFi.uri);
                    URI targetRel = URLUtils.getRelativePath(this.currentFile, dstTempAbs);
                    URI target = URLUtils.setFragment(targetRel, href.getFragment());
                    AttributesImpl buf = new AttributesImpl(atts);
                    XMLUtils.addOrSetAttribute(buf, "copy-to", target.toString());
                    res = buf;
                }
            }
            this.topicrefParentsStack.push(new ParentTopicref(href, dstFi, currentScope, currentProcesingResource));
        }
        this.getContentHandler().startElement(uri, localName, qName, res);
    }

    private String getCascadingScope(String currentScope) {
        String scope = currentScope;
        if (scope == null) {
            Iterator<ParentTopicref> iter = this.topicrefParentsStack.descendingIterator();
            while (iter.hasNext()) {
                ParentTopicref parentTopicref = iter.next();
                if (parentTopicref.scope == null) continue;
                scope = parentTopicref.scope;
                break;
            }
        }
        return scope;
    }

    private String getCascadingProcessingRole(String currentProcessingRole) {
        String processingRole = currentProcessingRole;
        if (processingRole == null) {
            Iterator<ParentTopicref> iter = this.topicrefParentsStack.descendingIterator();
            while (iter.hasNext()) {
                ParentTopicref parentTopicref = iter.next();
                if (parentTopicref.processingRole == null) continue;
                processingRole = parentTopicref.processingRole;
                break;
            }
        }
        return processingRole;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getContentHandler().endElement(uri, localName, qName);
        Optional<String> classValue = this.classElementStack.removeFirst();
        if (classValue.isPresent() && this.ignoreStack.peek().booleanValue() && Constants.MAP_TOPICREF.matches(classValue.get())) {
            this.topicrefParentsStack.pop();
        }
        this.ignoreStack.pop();
    }

    private Job.FileInfo generateCopyToTarget(Job.FileInfo srcFi, int count) {
        int i = 0;
        while (true) {
            StringBuilder ext = new StringBuilder();
            ext.append('_');
            ext.append(Integer.toString(count));
            if (i > 0) {
                ext.append('_');
                ext.append(Integer.toString(i));
            }
            ext.append('.');
            ext.append(FileUtils.getExtension(srcFi.result.toString()));
            URI dstResult = URLUtils.toURI(FileUtils.replaceExtension(srcFi.result.toString(), ext.toString()));
            URI dstTemp = this.tempFileNameScheme.generateTempFileName(dstResult);
            if (this.job.getFileInfo(dstTemp) == null) {
                return new Job.FileInfo.Builder(srcFi).uri(dstTemp).result(dstResult).build();
            }
            ++i;
        }
    }

    public void setTempFileNameScheme(TempFileNameScheme tempFileNameScheme) {
        this.tempFileNameScheme = tempFileNameScheme;
    }

    private record ParentTopicref(URI href, Job.FileInfo dstFi, String scope, String processingRole) {
    }
}

