/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.filter;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.sf.saxon.s9api.XdmNode;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.BranchFilterModule;
import org.dita.dost.module.filter.AbstractBranchFilterModule;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapBranchFilterModule
extends AbstractBranchFilterModule {
    public static final String BRANCH_COPY_TO = "filter-copy-to";
    private URI map;
    private URI ditavalFile;

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Job.FileInfo fi = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (!"ditamap".equals(fi.format)) {
            return null;
        }
        this.processMap(fi);
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize job configuration: " + e.getMessage(), e);
        }
        return null;
    }

    protected void processMap(Job.FileInfo fi) {
        Document doc;
        SubjectScheme subjectSchemeMap;
        this.map = fi.uri;
        this.currentFile = this.job.tempDirURI.resolve(this.map);
        this.ditavalFile = Optional.of(new File(this.job.tempDir, "ditaot.generated.ditaval")).filter(File::exists).map(File::toURI).orElse(null);
        this.logger.info("Processing " + String.valueOf(this.currentFile));
        try {
            this.logger.debug("Reading " + String.valueOf(this.currentFile));
            XdmNode node = this.job.getStore().getImmutableNode(this.currentFile);
            subjectSchemeMap = this.getSubjectScheme(node.getOutermostElement());
            doc = this.xmlUtils.cloneDocument(node);
        }
        catch (IOException e) {
            this.logger.error("Failed to parse " + String.valueOf(this.currentFile), e);
            return;
        }
        this.logger.debug("Split branches and generate copy-to");
        this.splitBranches(doc.getDocumentElement(), BranchFilterModule.Branch.EMPTY);
        this.logger.debug("Filter map");
        this.filterBranches(doc.getDocumentElement(), subjectSchemeMap);
        this.logger.debug("Rewrite duplicate topic references");
        this.rewriteDuplicates(doc.getDocumentElement());
        this.logger.debug("Writing " + String.valueOf(this.currentFile));
        try {
            this.job.getStore().writeDocument(doc, this.currentFile);
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize " + this.map.toString() + ": " + e.getMessage(), e);
        }
    }

    private void rewriteDuplicates(Element root) {
        HashMap<URI, Map> refs = new HashMap<URI, Map>();
        for (Element element : this.getTopicrefs(root)) {
            Attr attr = element.getAttributeNode(BRANCH_COPY_TO);
            if (attr == null && (attr = element.getAttributeNode("copy-to")) == null) {
                attr = element.getAttributeNode("href");
            }
            if (attr == null) continue;
            URI h = URLUtils.stripFragment(this.map.resolve(attr.getValue()));
            Map attrsMap = refs.computeIfAbsent(h, k -> new HashMap());
            Set<URI> currentFilter = this.getBranchFilters(element);
            List attrs = attrsMap.computeIfAbsent(currentFilter, k -> new ArrayList());
            attrs.add(attr);
        }
        for (Map.Entry entry : refs.entrySet()) {
            Map attrsMaps = (Map)entry.getValue();
            if (attrsMaps.size() <= 1) continue;
            if (attrsMaps.containsKey(Collections.EMPTY_LIST)) {
                attrsMaps.remove(Collections.EMPTY_LIST);
            } else {
                Set first = (Set)attrsMaps.keySet().iterator().next();
                attrsMaps.remove(first);
            }
            int i = 1;
            for (Map.Entry attrsMap : attrsMaps.entrySet()) {
                String suffix = "-" + i;
                List attrs = (List)attrsMap.getValue();
                for (Attr attr : attrs) {
                    URI absTarget;
                    Job.FileInfo hrefFileInfo;
                    URI dstUri;
                    String gen = MapBranchFilterModule.addSuffix(attr.getValue(), suffix);
                    this.logger.info(MessageUtils.getMessage("DOTJ065I", attr.getValue(), gen).setLocation(attr.getOwnerElement()).toString());
                    if (attr.getName().equals(BRANCH_COPY_TO)) {
                        attr.setValue(gen);
                    } else {
                        attr.getOwnerElement().setAttribute(BRANCH_COPY_TO, gen);
                    }
                    if ((dstUri = URLUtils.stripFragment(this.map.resolve(gen))) == null || (hrefFileInfo = this.job.getFileInfo(absTarget = URLUtils.stripFragment(this.currentFile.resolve(attr.getValue())))) == null) continue;
                    URI newResult = MapBranchFilterModule.addSuffix(hrefFileInfo.result, suffix);
                    Job.FileInfo.Builder dstBuilder = new Job.FileInfo.Builder(hrefFileInfo).uri(dstUri).result(newResult);
                    if (hrefFileInfo.format == null) {
                        dstBuilder.format("dita");
                    }
                    Job.FileInfo dstFileInfo = dstBuilder.build();
                    this.job.add(dstFileInfo);
                }
                ++i;
            }
        }
    }

    private Set<URI> getBranchFilters(Element e) {
        HashSet<URI> res = new HashSet<URI>();
        Element current = e;
        while (current != null) {
            Node parent;
            List<Element> ditavalref = XMLUtils.getChildElements(current, Constants.DITAVAREF_D_DITAVALREF);
            if (!ditavalref.isEmpty()) {
                res.add(URLUtils.toURI(ditavalref.get(0).getAttribute("href")));
            }
            if ((parent = current.getParentNode()) == null || parent.getNodeType() != 1) break;
            current = (Element)parent;
        }
        return res;
    }

    private static String addSuffix(String href, String suffix) {
        int idx = href.lastIndexOf(".");
        return idx != -1 ? href.substring(0, idx) + suffix + href.substring(idx) : href + suffix;
    }

    private static URI addSuffix(URI href, String suffix) {
        return URI.create(MapBranchFilterModule.addSuffix(href.toString(), suffix));
    }

    private List<Element> getTopicrefs(Element root) {
        ArrayList<Element> res = new ArrayList<Element>();
        NodeList all = root.getElementsByTagName("*");
        for (int i = 0; i < all.getLength(); ++i) {
            Element elem = (Element)all.item(i);
            if (!Constants.MAP_TOPICREF.matches(elem) || !this.isDitaFormat(elem.getAttributeNode("format")) || elem.getAttribute("scope").equals("external")) continue;
            res.add(elem);
        }
        return res;
    }

    private boolean isDitaFormat(Attr formatAttr) {
        return formatAttr == null || "dita".equals(formatAttr.getNodeValue()) || "ditamap".equals(formatAttr.getNodeValue());
    }

    private void filterBranches(Element root, SubjectScheme subjectSchemeMap) {
        String domains = root.getAttribute("domains");
        String specializations = root.getAttribute("specializations");
        QName[][] props = !domains.isEmpty() ? StringUtils.getExtProps(domains) : StringUtils.getExtPropsFromSpecializations(specializations);
        List<FilterUtils> baseFilter = this.getBaseFilter(subjectSchemeMap);
        this.filterBranches(root, baseFilter, props, subjectSchemeMap);
    }

    private List<FilterUtils> getBaseFilter(SubjectScheme subjectSchemeMap) {
        if (this.ditavalFile != null && !subjectSchemeMap.subjectSchemeMap().isEmpty()) {
            FilterUtils f = this.getFilterUtils(this.ditavalFile).refine(subjectSchemeMap);
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    private void filterBranches(Element elem, List<FilterUtils> filters, QName[][] props, SubjectScheme subjectSchemeMap) {
        FilterUtils f2;
        List<FilterUtils> fs = this.combineFilterUtils(elem, filters, subjectSchemeMap);
        boolean exclude = false;
        Iterator<FilterUtils> iterator = fs.iterator();
        while (iterator.hasNext() && !(exclude = (f2 = iterator.next()).needExclude(elem, props))) {
        }
        if (exclude) {
            elem.getParentNode().removeChild(elem);
        } else {
            List<Element> childElements = XMLUtils.getChildElements(elem);
            Set flags = fs.stream().flatMap(f -> f.getFlags(elem, props).stream()).map(f -> f.adjustPath(this.currentFile, this.job)).collect(Collectors.toSet());
            for (FilterUtils.Flag flag : flags) {
                Element startElement = (Element)elem.getOwnerDocument().importNode(flag.getStartFlag(), true);
                Node firstChild = elem.getFirstChild();
                if (firstChild != null) {
                    elem.insertBefore(startElement, firstChild);
                } else {
                    elem.appendChild(startElement);
                }
                Element endElement = (Element)elem.getOwnerDocument().importNode(flag.getEndFlag(), true);
                elem.appendChild(endElement);
            }
            for (Element child : childElements) {
                this.filterBranches(child, fs, props, subjectSchemeMap);
            }
        }
    }

    void splitBranches(Element elem, BranchFilterModule.Branch filter) {
        List<Element> ditavalRefs = XMLUtils.getChildElements(elem, Constants.DITAVAREF_D_DITAVALREF);
        if (ditavalRefs.size() > 0) {
            int i;
            for (Element branch : ditavalRefs) {
                elem.removeChild(branch);
            }
            ArrayList<Element> branches = new ArrayList<Element>(ditavalRefs.size());
            branches.add(elem);
            Node next = elem.getNextSibling();
            for (i = 1; i < ditavalRefs.size(); ++i) {
                Element clone = (Element)elem.cloneNode(true);
                if (next != null) {
                    elem.getParentNode().insertBefore(clone, next);
                } else {
                    elem.getParentNode().appendChild(clone);
                }
                branches.add(clone);
            }
            for (i = 0; i < branches.size(); ++i) {
                Element branch = (Element)branches.get(i);
                Element ditavalref = ditavalRefs.get(i);
                branch.insertBefore(ditavalref, branch.getFirstChild());
                BranchFilterModule.Branch currentFilter = filter.merge(ditavalref);
                this.processAttributes(branch, currentFilter);
                BranchFilterModule.Branch childFilter = new BranchFilterModule.Branch(currentFilter.resourcePrefix, currentFilter.resourceSuffix, Optional.empty(), Optional.empty());
                for (Element child : XMLUtils.getChildElements(branch, Constants.MAP_TOPICREF)) {
                    if (Constants.DITAVAREF_D_DITAVALREF.matches(child)) continue;
                    this.splitBranches(child, childFilter);
                }
            }
        } else {
            this.processAttributes(elem, filter);
            for (Element child : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                this.splitBranches(child, filter);
            }
        }
    }

    private void processAttributes(Element elem, BranchFilterModule.Branch filter) {
        if (filter.resourcePrefix.isPresent() || filter.resourceSuffix.isPresent()) {
            String href = elem.getAttribute("href");
            String copyTo = elem.getAttribute("copy-to");
            String scope = elem.getAttribute("scope");
            if (!(href.isEmpty() && copyTo.isEmpty() || scope.equals("external"))) {
                Job.FileInfo hrefFileInfo = this.job.getFileInfo(this.currentFile.resolve(href));
                Job.FileInfo copyToFileInfo = !copyTo.isEmpty() ? this.job.getFileInfo(this.currentFile.resolve(copyTo)) : null;
                URI dstSource = MapBranchFilterModule.generateCopyTo((copyToFileInfo != null ? copyToFileInfo : hrefFileInfo).result, filter);
                URI dstTemp = this.tempFileNameScheme.generateTempFileName(dstSource);
                Job.FileInfo.Builder dstBuilder = new Job.FileInfo.Builder(hrefFileInfo).result(dstSource).uri(dstTemp);
                if (dstBuilder.build().format == null) {
                    dstBuilder.format("dita");
                }
                if (hrefFileInfo.src == null && href != null && copyToFileInfo != null) {
                    dstBuilder.src(copyToFileInfo.src);
                }
                Job.FileInfo dstFileInfo = dstBuilder.build();
                elem.setAttribute(BRANCH_COPY_TO, dstTemp.toString());
                if (!copyTo.isEmpty()) {
                    elem.removeAttribute("copy-to");
                }
                this.job.add(dstFileInfo);
            }
        }
        if (filter.keyscopePrefix.isPresent() || filter.keyscopeSuffix.isPresent()) {
            StringBuilder buf = new StringBuilder();
            String keyscope = elem.getAttribute("keyscope");
            if (!keyscope.isEmpty()) {
                for (String key : keyscope.trim().split("\\s+")) {
                    filter.keyscopePrefix.ifPresent(buf::append);
                    buf.append(key);
                    filter.keyscopeSuffix.ifPresent(buf::append);
                    buf.append(' ');
                }
            } else {
                filter.keyscopePrefix.ifPresent(buf::append);
                filter.keyscopeSuffix.ifPresent(buf::append);
            }
            elem.setAttribute("keyscope", buf.toString().trim());
        }
    }

    static URI generateCopyTo(URI href, BranchFilterModule.Branch filter) {
        StringBuilder buf = new StringBuilder(href.toString());
        Optional<String> suffix = filter.resourceSuffix;
        suffix.ifPresent(s -> {
            int sep = buf.lastIndexOf("/");
            int i = buf.lastIndexOf(".");
            if (i != -1 && (sep == -1 || i > sep)) {
                buf.insert(i, (String)s);
            } else {
                buf.append((String)s);
            }
        });
        Optional<String> prefix = filter.resourcePrefix;
        prefix.ifPresent(s -> {
            int i = buf.lastIndexOf("/");
            if (i != -1) {
                buf.insert(i + 1, (String)s);
            } else {
                buf.insert(0, (String)s);
            }
        });
        return URLUtils.toURI(buf.toString());
    }
}

