/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.chunk;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.chunk.ChunkOperation;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChunkModule
extends AbstractPipelineModuleImpl {
    static final String GEN_CHUNK_PREFIX = "Chunk";
    static final String GEN_UNIQUE_PREFIX = "unique_";
    static final String SPLIT_CHUNK_DUPLICATE_SUFFIX = "1";
    private TempFileNameScheme tempFileNameScheme;
    private String rootChunkOverride;

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        this.init(input);
        try {
            Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
            URI mapFile = this.job.tempDirURI.resolve(in.uri);
            Document mapDoc = this.getInputMap(mapFile);
            Float ditaVersion = DitaUtils.getDitaVersion(mapDoc.getDocumentElement());
            if (ditaVersion == null || ditaVersion.floatValue() < 2.0f) {
                return null;
            }
            this.logger.info("Processing {0}", mapFile);
            List<ChunkOperation> chunks = this.collectChunkOperations(mapFile, mapDoc);
            Map<URI, URI> combineRewriteMap = this.processCombine(mapFile, mapDoc, chunks);
            Map<URI, URI> splitRewriteMap = this.processSplit(mapFile, mapDoc, chunks);
            this.rewriteLinks(combineRewriteMap, splitRewriteMap);
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        return null;
    }

    private void removeChunkAttributes(Element map, ChunkOperation.Operation operation) {
        if (map.getAttribute("chunk").equals(operation.name)) {
            map.removeAttribute("chunk");
        }
        for (Element topicref : XMLUtils.getChildElements(map, Constants.MAP_TOPICREF, true)) {
            if (!topicref.getAttribute("chunk").equals(operation.name)) continue;
            topicref.removeAttribute("chunk");
        }
    }

    private void rewriteLinks(Map<URI, URI> combineRewriteMap, Map<URI, URI> splitRewriteMap) {
        if (!combineRewriteMap.isEmpty() && !splitRewriteMap.isEmpty()) {
            HashMap<URI, URI> rewriteMap = new HashMap<URI, URI>(combineRewriteMap);
            rewriteMap.putAll(splitRewriteMap);
            Map<URI, URI> rewriteMapAll = Collections.unmodifiableMap(rewriteMap);
            Collection<Job.FileInfo> topics = this.job.getFileInfo(DitaUtils::isDitaFormat);
            (this.parallel ? topics.parallelStream() : topics.stream()).forEach(fi -> {
                try {
                    URI uri = this.job.tempDirURI.resolve(fi.uri);
                    Document doc = this.job.getStore().getDocument(uri);
                    this.rewriteTopicLinks(doc, uri, rewriteMapAll);
                    this.job.getStore().writeDocument(doc, uri);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void rewriteTopicLinks(Document doc, URI src, Map<URI, URI> rewriteMap) {
        List<Element> elements = XMLUtils.toList(doc.getDocumentElement().getElementsByTagName("*"));
        for (Element link : elements) {
            URI rel;
            if (!Constants.TOPIC_LINK.matches(link) && !Constants.TOPIC_XREF.matches(link)) continue;
            URI href = URLUtils.toURI(link.getAttribute("href"));
            URI abs = src.resolve(href);
            URI rewrite = rewriteMap.get(abs);
            if (rewrite != null) {
                rel = URLUtils.getRelativePath(src.resolve("."), rewrite);
                link.setAttribute("href", rel.toString());
                continue;
            }
            rel = URLUtils.getRelativePath(src.resolve("."), abs);
            link.setAttribute("href", rel.toString());
        }
    }

    private Map<URI, URI> processCombine(URI mapFile, Document mapDoc, List<ChunkOperation> chunks) throws IOException {
        if (chunks.stream().anyMatch(c -> c.operation().equals((Object)ChunkOperation.Operation.COMBINE))) {
            HashMap<URI, URI> rewriteMap = new HashMap<URI, URI>();
            Set<URI> normalTopicRefs = this.getNormalTopicRefs(mapFile, mapDoc);
            List<ChunkOperation> rewrittenChunks = this.rewriteCombineChunks(mapFile, mapDoc, normalTopicRefs, rewriteMap, chunks);
            this.rewriteTopicrefs(mapFile, rewrittenChunks);
            this.removeChunkAttributes(mapDoc.getDocumentElement(), ChunkOperation.Operation.COMBINE);
            this.logger.info("Writing {0}", mapFile);
            this.job.getStore().writeDocument(mapDoc, mapFile);
            this.generateChunks(rewrittenChunks, Collections.unmodifiableMap(rewriteMap));
            this.removeChunkSources(normalTopicRefs, rewrittenChunks);
            return Collections.unmodifiableMap(rewriteMap);
        }
        return Collections.emptyMap();
    }

    private Map<URI, URI> processSplit(URI mapFile, Document mapDoc, List<ChunkOperation> chunks) throws IOException {
        if (chunks.stream().anyMatch(c -> c.operation().equals((Object)ChunkOperation.Operation.SPLIT))) {
            List<ChunkOperation> rewrittenChunks = this.rewriteSplitChunks(mapFile, mapDoc, chunks);
            HashMap<URI, URI> rewriteMap = new HashMap<URI, URI>();
            mapDoc.getDocumentElement().removeAttribute("chunk");
            for (ChunkOperation chunk : rewrittenChunks) {
                if (chunk.operation() != ChunkOperation.Operation.SPLIT) continue;
                this.logger.info("Split {0}", chunk.src());
                Job.FileInfo fileInfo = this.job.getFileInfo(chunk.src());
                Document doc = this.job.getStore().getDocument(chunk.src());
                List<Element> topicrefs = this.splitNestedTopic(fileInfo, doc.getDocumentElement(), chunk.topicref(), rewriteMap);
                if (doc.getDocumentElement().getTagName().equals("dita")) {
                    this.processSplitDitabase(chunk, topicrefs);
                    continue;
                }
                this.processSplitTopic(chunk, doc, topicrefs, fileInfo);
            }
            this.removeChunkAttributes(mapDoc.getDocumentElement(), ChunkOperation.Operation.SPLIT);
            this.logger.info("Writing {0}", mapFile);
            this.job.getStore().writeDocument(mapDoc, mapFile);
            return rewriteMap;
        }
        return Collections.emptyMap();
    }

    private List<ChunkOperation> rewriteSplitChunks(URI mapFile, Document mapDoc, List<ChunkOperation> chunks) {
        Set<URI> normalTopicRefs = this.getNormalTopicRefs(mapFile, mapDoc);
        ArrayList<ChunkOperation> res = new ArrayList<ChunkOperation>(chunks.size());
        for (ChunkOperation chunk : chunks) {
            ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(chunk);
            if (normalTopicRefs.contains(chunk.src())) {
                builder.dst(this.addSuffixToPath(chunk.src(), SPLIT_CHUNK_DUPLICATE_SUFFIX));
            } else {
                builder.dst(chunk.src());
            }
            res.add(builder.build());
        }
        return res;
    }

    private Set<URI> getNormalTopicRefs(URI mapFile, Document mapDoc) {
        if (mapDoc.getDocumentElement().getAttribute("chunk").equals(ChunkOperation.Operation.SPLIT.name)) {
            return Collections.emptySet();
        }
        HashSet<URI> res = new HashSet<URI>();
        this.getNormalTopicRefsWalker(mapFile, mapDoc.getDocumentElement(), res);
        return res;
    }

    private void getNormalTopicRefsWalker(URI mapFile, Element root, Set<URI> res) {
        if (Constants.MAP_TOPICREF.matches(root) || Constants.MAP_MAP.matches(root)) {
            String chunk = root.getAttribute("chunk");
            String href = root.getAttribute("href");
            if (chunk.isEmpty() && !href.isEmpty() && DitaUtils.isNormalProcessRole(root) && DitaUtils.isDitaFormat(root)) {
                res.add(URLUtils.removeFragment(mapFile.resolve(href)));
            }
            if (!chunk.equals(ChunkOperation.Operation.COMBINE.name)) {
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    this.getNormalTopicRefsWalker(mapFile, (Element)child, res);
                }
            }
        }
    }

    private void processSplitTopic(ChunkOperation chunk, Document doc, List<Element> topicrefs, Job.FileInfo fileInfo) throws IOException {
        this.logger.info("Write {0}", chunk.dst());
        if (chunk.dst() != null && !Objects.equals(chunk.src(), chunk.dst())) {
            URI src = this.job.tempDirURI.resolve(fileInfo.uri);
            URI dst = chunk.dst();
            URI tmp = this.job.tempDirURI.relativize(dst);
            URI result = this.addSuffixToPath(fileInfo.result, SPLIT_CHUNK_DUPLICATE_SUFFIX);
            Job.FileInfo adoptedFileInfo = new Job.FileInfo.Builder(fileInfo).uri(tmp).result(result).build();
            this.job.add(adoptedFileInfo);
        }
        for (Element topicref : topicrefs) {
            chunk.topicref().appendChild(topicref);
        }
        this.job.getStore().writeDocument(doc, chunk.dst());
    }

    private void processSplitDitabase(ChunkOperation chunk, List<Element> topicrefs) throws IOException {
        Element parentNode = (Element)chunk.topicref().getParentNode();
        if (topicrefs.isEmpty()) {
            List<Element> nestedTopicrefs = XMLUtils.getChildElements(chunk.topicref(), Constants.MAP_TOPICREF);
            for (Element nestedTopicref : nestedTopicrefs) {
                parentNode.insertBefore(chunk.topicref().removeChild(nestedTopicref), chunk.topicref());
            }
        } else {
            List<Element> nestedTopicrefs = XMLUtils.getChildElements(chunk.topicref(), Constants.MAP_TOPICREF);
            Element lastTopicref = topicrefs.get(topicrefs.size() - 1);
            for (Element nestedTopicref : nestedTopicrefs) {
                lastTopicref.appendChild(chunk.topicref().removeChild(nestedTopicref));
            }
            for (Element topicref : topicrefs) {
                parentNode.insertBefore(topicref, chunk.topicref());
            }
        }
        parentNode.removeChild(chunk.topicref());
        this.job.remove(this.job.getFileInfo(chunk.src()));
        this.logger.info("Delete {0}", chunk.src());
        this.job.getStore().delete(chunk.src());
    }

    private List<Element> splitNestedTopic(Job.FileInfo fileInfo, Element topic, Element topicref, Map<URI, URI> rewriteMap) {
        topicref.removeAttribute("chunk");
        return XMLUtils.getChildElements(topic, Constants.TOPIC_TOPIC).stream().map(nestedTopic -> {
            Element nestedTopicref = topicref.getOwnerDocument().createElement(Constants.MAP_TOPICREF.localName);
            nestedTopicref.setAttribute("class", Constants.MAP_TOPICREF.toString());
            List<Element> childTopicrefs = this.splitNestedTopic(fileInfo, (Element)nestedTopic, nestedTopicref, rewriteMap);
            for (Element childTopicref : childTopicrefs) {
                nestedTopicref.appendChild(childTopicref);
            }
            String id = nestedTopic.getAttribute("id");
            Element removedNestedTopic = (Element)topic.removeChild((Node)nestedTopic);
            Document doc = this.xmlUtils.newDocument();
            Element adoptedNestedTopic = (Element)doc.adoptNode(removedNestedTopic);
            doc.appendChild(adoptedNestedTopic);
            this.cascadeNamespaces(adoptedNestedTopic, topic);
            URI src = this.job.tempDirURI.resolve(fileInfo.uri);
            URI dst = this.addSuffixToPath(src, id);
            URI tmp = this.job.tempDirURI.relativize(dst);
            URI result = this.addSuffixToPath(fileInfo.result, id);
            Job.FileInfo adoptedFileInfo = new Job.FileInfo.Builder(fileInfo).uri(tmp).result(result).build();
            this.job.add(adoptedFileInfo);
            try {
                this.logger.info("Write {0}", dst);
                this.job.getStore().writeDocument(doc, dst);
            }
            catch (IOException e) {
                this.logger.error("Failed to write {0}", dst, e);
            }
            nestedTopicref.setAttribute("href", tmp.resolve(".").relativize(tmp).toString());
            rewriteMap.put(URLUtils.setFragment(src, id), dst);
            return nestedTopicref;
        }).collect(Collectors.toList());
    }

    private String generateSuffix(String id) {
        return "_" + id;
    }

    private URI addSuffixToPath(URI src, String id) {
        return URLUtils.addSuffixToPath(src, this.generateSuffix(id));
    }

    private void cascadeNamespaces(Element dst, Node src) {
        NamedNodeMap attributes;
        if (src.getParentNode() != null) {
            this.cascadeNamespaces(dst, src.getParentNode());
        }
        if ((attributes = src.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                if (!Objects.equals(attribute.getPrefix(), "xmlns")) continue;
                dst.setAttributeNode((Attr)dst.getOwnerDocument().importNode(attribute, false));
            }
        }
    }

    private void init(AbstractPipelineInput input) {
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(this.job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(this.job.getInputDir());
        if (input.getAttribute("root-chunk-override") != null) {
            this.rootChunkOverride = input.getAttribute("root-chunk-override");
        }
    }

    private Document getInputMap(URI mapFile) throws IOException {
        Document doc = this.job.getStore().getDocument(mapFile);
        if (this.rootChunkOverride != null) {
            this.logger.debug("Use override root chunk {0}", this.rootChunkOverride);
            doc.getDocumentElement().setAttribute("chunk", this.rootChunkOverride);
        }
        return doc;
    }

    private void removeChunkSources(Set<URI> normalTopicRefs, List<ChunkOperation> chunks) {
        Set<URI> sources = this.collectResources(chunks, ChunkOperation::src);
        Set<URI> destinations = this.collectResources(chunks, ChunkOperation::dst);
        Set<URI> removed = sources.stream().filter(dst -> !destinations.contains(dst) && !normalTopicRefs.contains(dst)).collect(Collectors.toSet());
        removed.forEach(tmp -> {
            this.logger.info("Remove {0}", tmp);
            try {
                this.job.getStore().delete((URI)tmp);
            }
            catch (IOException e) {
                this.logger.error("Failed to delete " + String.valueOf(tmp), e);
            }
            this.job.remove(this.job.getFileInfo((URI)tmp));
        });
        Set<URI> added = destinations.stream().filter(dst -> !sources.contains(dst)).collect(Collectors.toSet());
        added.forEach(tmp -> {
            if (this.job.getFileInfo((URI)tmp) == null) {
                Job.FileInfo src = chunks.stream().filter(chunk -> chunk.src() != null && chunk.dst() != null && URLUtils.removeFragment(chunk.dst()).equals(tmp)).findAny().flatMap(chunk -> Optional.ofNullable(this.job.getFileInfo(URLUtils.removeFragment(chunk.src())))).orElse(null);
                Job.FileInfo.Builder builder = src != null ? Job.FileInfo.builder(src) : Job.FileInfo.builder();
                URI dstRel = this.job.tempDirURI.relativize((URI)tmp);
                Job.FileInfo dstFi = builder.uri(dstRel).format("dita").build();
                this.job.add(dstFi);
            }
        });
    }

    private Set<URI> collectResources(List<ChunkOperation> chunks, Function<ChunkOperation, URI> pick) {
        HashSet<URI> sources = new HashSet<URI>();
        this.collectResources(chunks, pick, sources);
        return Collections.unmodifiableSet(sources);
    }

    private void collectResources(List<ChunkOperation> chunks, Function<ChunkOperation, URI> pick, Set<URI> res) {
        for (ChunkOperation chunk : chunks) {
            URI uri = pick.apply(chunk);
            if (uri != null) {
                res.add(URLUtils.removeFragment(uri));
            }
            this.collectResources(chunk.children(), pick, res);
        }
    }

    private void generateChunks(List<ChunkOperation> chunks, Map<URI, URI> rewriteMap) {
        (this.parallel ? (Stream)chunks.stream().parallel() : chunks.stream()).forEach(chunk -> {
            this.logger.info("Generate chunk {0}", URLUtils.removeFragment(chunk.dst()));
            try {
                Document chunkDoc = this.merge((ChunkOperation)chunk);
                this.rewriteLinks(chunkDoc, chunk.src(), rewriteMap);
                chunkDoc.normalizeDocument();
                URI dst = URLUtils.removeFragment(chunk.dst());
                this.logger.info("Writing {0}", dst);
                this.job.getStore().writeDocument(chunkDoc, dst);
            }
            catch (IOException e) {
                this.logger.error("Failed to generate chunk {0}", URLUtils.removeFragment(chunk.dst()), e);
            }
        });
    }

    private void rewriteTopicrefs(URI mapFile, List<ChunkOperation> chunks) {
        for (ChunkOperation chunk : chunks) {
            URI dst = URLUtils.getRelativePath(mapFile.resolve("."), chunk.dst());
            if (!Constants.MAP_MAP.matches(chunk.topicref())) {
                chunk.topicref().setAttribute("href", dst.toString());
            }
            if (Constants.MAPGROUP_D_TOPICGROUP.matches(chunk.topicref())) {
                chunk.topicref().setAttribute("class", Constants.MAP_TOPICREF.toString());
            }
            this.rewriteTopicrefs(mapFile, chunk.children());
        }
    }

    private void rewriteLinks(Document doc, URI src, Map<URI, URI> rewriteMap) {
        List<Element> elements = XMLUtils.toList(doc.getDocumentElement().getElementsByTagName("*"));
        for (Element link : elements) {
            URI rel;
            if (!Constants.TOPIC_LINK.matches(link) && !Constants.TOPIC_XREF.matches(link)) continue;
            URI href = URLUtils.toURI(link.getAttribute("href"));
            URI abs = src.resolve(href);
            URI rewrite = rewriteMap.get(abs);
            if (rewrite != null) {
                rel = URLUtils.getRelativePath(src.resolve("."), rewrite);
                link.setAttribute("href", rel.toString());
                continue;
            }
            rel = URLUtils.getRelativePath(src.resolve("."), abs);
            link.setAttribute("href", rel.toString());
        }
    }

    private List<ChunkOperation> rewriteCombineChunks(URI mapFile, Document mapDoc, Set<URI> normalTopicRefs, Map<URI, URI> rewriteMap, List<ChunkOperation> chunks) {
        return chunks.stream().filter(chunk -> chunk.operation() == ChunkOperation.Operation.COMBINE).map(chunk -> this.rewriteCombineChunk(mapFile, mapDoc, normalTopicRefs, rewriteMap, (ChunkOperation)chunk).build()).toList();
    }

    private ChunkOperation.ChunkBuilder rewriteCombineChunk(URI mapFile, Document mapDoc, Set<URI> normalTopicRefs, Map<URI, URI> rewriteMap, ChunkOperation rootChunk) {
        URI dst;
        String id = null;
        if (Constants.MAP_MAP.matches(rootChunk.topicref())) {
            id = rootChunk.topicref().getAttribute("id");
            if (id.isEmpty()) {
                id = FileUtils.replaceExtension(FileUtils.getName(mapFile.getPath()), "");
            }
            dst = URI.create(FileUtils.replaceExtension(mapFile.toString(), ".dita"));
            Collection<URI> collection = rewriteMap.values();
        } else {
            URI dstBase;
            if (rootChunk.src() != null && rootChunk.src().getFragment() != null) {
                id = rootChunk.src().getFragment();
            } else if (rootChunk.src() != null) {
                id = this.getRootTopicId(rootChunk.src());
            }
            if (id == null) {
                id = "Chunk1";
            }
            if (rootChunk.src() == null) {
                dstBase = mapFile.resolve("Chunk.dita");
                dst = URLUtils.addSuffix(dstBase, Integer.toString(1));
            } else {
                dst = dstBase = rootChunk.src();
            }
            dst = URLUtils.setFragment(dst, id);
            Collection<URI> values = rewriteMap.values();
            int i = 1;
            while (values.contains(dst) || normalTopicRefs.contains(URLUtils.removeFragment(dst))) {
                dst = URLUtils.addSuffix(dstBase, Integer.toString(i));
                dst = URLUtils.setFragment(dst, id);
                ++i;
            }
        }
        rewriteMap.put(rootChunk.src(), dst);
        if (rootChunk.src() != null) {
            rewriteMap.put(URLUtils.setFragment(rootChunk.src(), id), dst);
        }
        ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(rootChunk.operation()).topicref(rootChunk.topicref()).src(rootChunk.src()).dst(dst).id(id);
        for (ChunkOperation child : rootChunk.children()) {
            ChunkOperation.ChunkBuilder childBuilder = this.rewriteChunkChild(rewriteMap, Objects.requireNonNull(dst), child);
            builder.addChild(childBuilder);
        }
        return builder;
    }

    private String generateChunkPrefix(int index) {
        return GEN_CHUNK_PREFIX + index;
    }

    private ChunkOperation.ChunkBuilder rewriteChunkChild(Map<URI, URI> rewriteMap, URI rootChunkDst, ChunkOperation chunk) {
        String id = chunk.src() != null && chunk.src().getFragment() != null ? chunk.src().getFragment() : (chunk.src() != null ? this.getRootTopicId(chunk.src()) : null);
        URI dst = URLUtils.setFragment(rootChunkDst, id);
        Collection<URI> values = rewriteMap.values();
        int i = 1;
        while (id == null || values.contains(dst)) {
            id = this.generateUniquePrefix(i);
            dst = URLUtils.setFragment(rootChunkDst, id);
            ++i;
        }
        rewriteMap.put(chunk.src(), dst);
        if (chunk.src() != null) {
            rewriteMap.put(URLUtils.setFragment(chunk.src(), id), dst);
        }
        ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(chunk.operation()).topicref(chunk.topicref()).src(chunk.src()).dst(dst).id(id);
        for (ChunkOperation child : chunk.children()) {
            builder.addChild(this.rewriteChunkChild(rewriteMap, rootChunkDst, child));
        }
        return builder;
    }

    private String generateUniquePrefix(int index) {
        return GEN_UNIQUE_PREFIX + index;
    }

    private String getRootTopicId(URI src) {
        this.logger.debug("Get root ID from {0}", src);
        try {
            XdmNode node = this.job.getStore().getImmutableNode(src);
            Step firstTopicId = Steps.descendant(Constants.TOPIC_TOPIC.matcher()).first().then(Steps.attribute((String)"id"));
            return node.select(firstTopicId).findFirst().map(XdmItem::getStringValue).orElse(null);
        }
        catch (IOException e) {
            this.logger.error("Failed to read root ID from {0}", src, e);
            return null;
        }
    }

    private Document merge(ChunkOperation rootChunk) throws IOException {
        Document doc;
        if (rootChunk.src() != null) {
            Element dstTopic = this.getElement(rootChunk.src());
            doc = dstTopic.getOwnerDocument();
            if (dstTopic.getNodeName().equals("dita")) {
                Element lastChildTopic = this.getLastChildTopic(dstTopic);
                if (lastChildTopic != null) {
                    dstTopic = lastChildTopic;
                }
            } else {
                Element ditaWrapper = this.createDita(doc);
                doc.replaceChild(ditaWrapper, doc.getDocumentElement());
                if (dstTopic.getParentNode() != null) {
                    dstTopic = (Element)dstTopic.getParentNode().removeChild(dstTopic);
                }
                ditaWrapper.appendChild(dstTopic);
            }
            this.mergeTopic(rootChunk, rootChunk, dstTopic);
        } else {
            Element navtitle = this.getNavtitle(rootChunk.topicref());
            if (navtitle != null) {
                doc = this.xmlUtils.newDocument();
                Element ditaWrapper = this.createDita(doc);
                doc.appendChild(ditaWrapper);
                Element topic = this.createTopic(doc, rootChunk.id());
                topic.appendChild(this.createTitle(doc, navtitle));
                ditaWrapper.appendChild(topic);
                this.mergeTopic(rootChunk, rootChunk, topic);
            } else {
                doc = this.xmlUtils.newDocument();
                Element ditaWrapper = this.createDita(doc);
                doc.appendChild(ditaWrapper);
                this.mergeTopic(rootChunk, rootChunk, ditaWrapper);
            }
        }
        return doc;
    }

    private Element createTitle(Document doc, Element src) {
        Element title = doc.createElement(Constants.TOPIC_TITLE.localName);
        title.setAttribute("class", Constants.TOPIC_TITLE.toString());
        List<Node> children = XMLUtils.toList(src.getChildNodes());
        for (Node child : children) {
            title.appendChild(doc.importNode(child, true));
        }
        return title;
    }

    private Element createDita(Document doc) {
        Element ditaWrapper = doc.createElement("dita");
        ditaWrapper.setAttributeNS("http://dita.oasis-open.org/architecture/2005/", "ditaarch:DITAArchVersion", "2.0");
        return ditaWrapper;
    }

    private void mergeTopic(ChunkOperation rootChunk, ChunkOperation chunk, Element dstTopic) throws IOException {
        for (ChunkOperation child : chunk.children()) {
            Element added;
            if (child.src() != null) {
                Element root = this.getElement(child.src());
                if (root.getNodeName().equals("dita")) {
                    List<Element> rootTopics = XMLUtils.getChildElements(root, Constants.TOPIC_TOPIC);
                    boolean i = true;
                    for (Element topic : rootTopics) {
                        Element imported = (Element)dstTopic.getOwnerDocument().importNode(topic, true);
                        this.rewriteTopicId(imported, child.id());
                        this.relativizeLinks(imported, child.src(), rootChunk.dst());
                        added = (Element)dstTopic.appendChild(imported);
                    }
                    this.mergeTopic(rootChunk, child, dstTopic);
                    continue;
                }
                Element imported = (Element)dstTopic.getOwnerDocument().importNode(root, true);
                this.rewriteTopicId(imported, child.id());
                this.relativizeLinks(imported, child.src(), rootChunk.dst());
                added = (Element)dstTopic.appendChild(imported);
                this.mergeTopic(rootChunk, child, added);
                continue;
            }
            Element imported = this.createTopic(dstTopic.getOwnerDocument(), child.id());
            Element navtitle = this.getNavtitle(child.topicref());
            if (navtitle != null) {
                imported.appendChild(this.createTitle(dstTopic.getOwnerDocument(), navtitle));
            }
            added = (Element)dstTopic.appendChild(imported);
            this.mergeTopic(rootChunk, child, added);
        }
    }

    private Element getElement(URI src) throws IOException {
        this.logger.info("Reading {0}", src);
        Document chunkDoc = this.job.getStore().getDocument(src);
        if (src.getFragment() != null) {
            NodeList children = chunkDoc.getElementsByTagName("*");
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!Constants.TOPIC_TOPIC.matches(child) || !((Element)child).getAttribute("id").equals(src.getFragment())) continue;
                return (Element)child;
            }
            return null;
        }
        return chunkDoc.getDocumentElement();
    }

    private Element getLastChildTopic(Element dita) {
        List<Element> childElements = XMLUtils.getChildElements(dita, Constants.TOPIC_TOPIC);
        if (childElements.isEmpty()) {
            return null;
        }
        return childElements.get(childElements.size() - 1);
    }

    private Element createTopic(Document doc, String id) {
        Element imported = doc.createElement(Constants.TOPIC_TOPIC.localName);
        imported.setAttribute("class", Constants.TOPIC_TOPIC.toString());
        imported.setAttribute("id", id);
        return imported;
    }

    private void rewriteTopicId(Element topic, String id) {
        topic.setAttribute("id", id);
    }

    private void relativizeLinks(Element topic, URI src, URI dst) {
        List<Element> elements = XMLUtils.toList(topic.getElementsByTagName("*"));
        for (Element link : elements) {
            if (!Constants.TOPIC_LINK.matches(link) && !Constants.TOPIC_XREF.matches(link)) continue;
            URI href = URLUtils.toURI(link.getAttribute("href"));
            URI abs = src.resolve(href);
            URI rel = URLUtils.getRelativePath(dst.resolve("."), abs);
            link.setAttribute("href", rel.toString());
        }
    }

    private List<ChunkOperation> collectChunkOperations(URI mapFile, Document mapDoc) {
        this.logger.debug("Collect chunk operations");
        ArrayList<ChunkOperation> chunks = new ArrayList<ChunkOperation>();
        this.collectChunkOperations(mapFile, mapDoc.getDocumentElement(), chunks, null);
        return Collections.unmodifiableList(chunks);
    }

    private void collectChunkOperations(URI mapFile, Element elem, List<ChunkOperation> chunks, ChunkOperation.Operation defaultOperation) {
        String chunk = elem.getAttribute("chunk");
        if (chunk.isEmpty() && defaultOperation != null) {
            chunk = defaultOperation.name().toLowerCase();
        }
        if (chunk.equals(ChunkOperation.Operation.COMBINE.name)) {
            if (Constants.MAP_MAP.matches(elem)) {
                URI href = URI.create(FileUtils.replaceExtension(mapFile.toString(), ".dita"));
                ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).dst(href).topicref(elem);
                XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF).stream().flatMap(child -> this.collectCombineChunks(mapFile, (Element)child).stream()).forEachOrdered(builder::addChild);
                chunks.add(builder.build());
            } else {
                Attr hrefNode = elem.getAttributeNode("href");
                URI href = hrefNode != null ? mapFile.resolve(hrefNode.getValue()) : null;
                ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).src(href).topicref(elem);
                XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF).stream().flatMap(child -> this.collectCombineChunks(mapFile, (Element)child).stream()).forEachOrdered(builder::addChild);
                chunks.add(builder.build());
            }
        } else if (chunk.equals(ChunkOperation.Operation.SPLIT.name)) {
            if (Constants.MAP_MAP.matches(elem)) {
                for (Element child2 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                    this.collectChunkOperations(mapFile, child2, chunks, ChunkOperation.Operation.SPLIT);
                }
            } else {
                Attr hrefNode = elem.getAttributeNode("href");
                if (hrefNode != null) {
                    URI href = URLUtils.setFragment(mapFile.resolve(hrefNode.getValue()), null);
                    ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.SPLIT).src(href).topicref(elem);
                    chunks.add(builder.build());
                } else {
                    this.logger.warn(MessageUtils.getMessage("DOTJ086W", elem.getTagName()).setLocation(elem).toString());
                }
                for (Element child3 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                    this.collectChunkOperations(mapFile, child3, chunks, defaultOperation);
                }
            }
        } else {
            for (Element child4 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                this.collectChunkOperations(mapFile, child4, chunks, defaultOperation);
            }
        }
    }

    private List<ChunkOperation.ChunkBuilder> collectCombineChunks(URI mapFile, Element elem) {
        if (!elem.getAttribute("chunk").isEmpty()) {
            this.logger.warn(MessageUtils.getMessage("DOTJ087W", elem.getAttribute("chunk")).setLocation(elem).toString());
            elem.removeAttribute("chunk");
        }
        Attr hrefNode = elem.getAttributeNode("href");
        Element navtitle = this.getNavtitle(elem);
        if (hrefNode != null && DitaUtils.isDitaFormat(elem) && DitaUtils.isLocalScope(elem)) {
            URI href = mapFile.resolve(hrefNode.getValue());
            ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).src(href).topicref(elem);
            for (Element child2 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                for (ChunkOperation.ChunkBuilder chunkBuilder : this.collectCombineChunks(mapFile, child2)) {
                    builder.addChild(chunkBuilder);
                }
            }
            return Collections.singletonList(builder);
        }
        if (navtitle != null) {
            ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).topicref(elem);
            for (Element child3 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                for (ChunkOperation.ChunkBuilder chunkBuilder : this.collectCombineChunks(mapFile, child3)) {
                    builder.addChild(chunkBuilder);
                }
            }
            return Collections.singletonList(builder);
        }
        return XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF).stream().flatMap(child -> this.collectCombineChunks(mapFile, (Element)child).stream()).collect(Collectors.toList());
    }

    private Element getNavtitle(Element topicref) {
        if (topicref != null) {
            return XMLUtils.getChildElement(topicref, Constants.MAP_TOPICMETA).flatMap(topicmeta -> XMLUtils.getChildElement(topicmeta, Constants.TOPIC_NAVTITLE)).orElse(null);
        }
        return null;
    }
}

