/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xsd.documentation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.editor.xmleditor.ErrorListException;
import ro.sync.exml.gc;
import ro.sync.exml.options.je;
import ro.sync.g.e.c;
import ro.sync.options.k;
import ro.sync.util.fb;
import ro.sync.xsd.documentation.XSDDocumentationOptions;
import ro.sync.xsd.documentation.i;
import ro.sync.xsd.documentation.n;
import ro.sync.xsd.documentation.w;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class XSDSchemaDocumentationGenerator {
    private static final String g = "-openInBrowser:";
    private static final String f = "-out:";
    private static final String d = "-xsl:";
    private static final String c = "-format:";
    private static final String e = "-split";
    private static final String b = "-cfg:";

    private static void f(boolean bl) {
        System.out.println();
        if (PlatformDetector.isWin()) {
            System.out.print("schemaDocumentation ");
        } else {
            System.out.print("sh schemaDocumentation.sh ");
        }
        System.out.println("schemaFile [-cfg:configFile] [-out:outputFile] [-format:<value>] [-xsl:xslFile] [-split:<value>] [-openInBrowser:<value>] | [--help | -help | --h | -h]\n");
        System.out.println("Where:");
        System.out.println("   schemaFile = the XML Schema file");
        System.out.println("   -cfg:configfile = the configuration file.      It contains the output file, split method, output format options\n     and some advanced options regarding the included components and components details.\n     The other supplied arguments override the options from this external configuration file.\n     You can create such a file in the Oxygen \"Schema Documentation\" dialog. See the Oxygen user manual for additional information on how to create one.\n");
        System.out.println("   -out:outputFile = the file where the generated documentation will be saved.\n     By default it is the name of the schema file with 'html' extension.");
        System.out.println("   -format:<value> = the output format type used when generating the documentation.\n     value = [html | pdf | docbook | dita | custom]\n             html    = generate documentation in HTML format.\n             pdf     = generate documentation in PDF format.\n             docbook = generate documentation in DocBook format.\n             dita    = generate documentation in DITA format.\n             custom  = generate documentation in a custom format. Note that this value requires the use of the '-xsl' parameter.\n");
        System.out.println("   -xsl:<xslFile> = the custom XSL file to be applied on the intermediate xml format. \n     Note that this parameter is used by the XML Schema documentation generator only if the '-format' parameter is set to 'custom'.");
        System.out.println("   -split:<value>  = the split method used when generating the documentation. Splitting is recommended for large schemas\n     value = [none | namespace | | component | location].\n             none      = generate one single output file.\n             namespace = generate an output file for every namespace in the schema.\n             component = generate an output file for every component in the schema.\n             location  = generate an output file for every schema location.\n     By default the used method is 'none'");
        System.out.println("   -openInBrowser:<value> = open the result of the transformation in browser.\n     value = [true | false].\n             true = open the resulted file in browser.\n             false = do not open the resulted file in browser.\n     By default the value is false.\n\n   --help | -help | --h | -h = show this help.");
        System.out.println();
        System.out.println("Examples: ");
        System.out.print("          ");
        if (PlatformDetector.isWin()) {
            System.out.print("schemaDocumentation ");
        } else {
            System.out.print("sh schemaDocumentation.sh ");
        }
        System.out.println("example.xsd -out:schemaDocumentation.html -format:custom -xsl:example.xsl -split:namespace");
        System.out.print("          ");
        if (PlatformDetector.isWin()) {
            System.out.print("schemaDocumentation ");
        } else {
            System.out.print("sh schemaDocumentation.sh ");
        }
        System.out.println("example.xsd -cfg configurationFile.xml -out:schemaDocumentation.html");
        System.exit(bl ? 0 : 1);
    }

    private static int e(String string) {
        int n2 = -1;
        if ("none".equals(string = string.substring(string.indexOf(58) + 1))) {
            n2 = 1;
        } else if ("namespace".equals(string)) {
            n2 = 2;
        } else if ("location".equals(string)) {
            n2 = 3;
        } else if ("component".equals(string)) {
            n2 = 4;
        } else {
            System.err.println("Invalid split method!");
            XSDSchemaDocumentationGenerator.f(false);
        }
        return n2;
    }

    private static int i(String string) {
        int n2 = -1;
        if ("html".equals(string = string.substring(string.indexOf(58) + 1))) {
            n2 = 1;
        } else if ("pdf".equals(string)) {
            n2 = 2;
        } else if ("docbook".equals(string)) {
            n2 = 3;
        } else if ("dita".equals(string)) {
            n2 = 5;
        } else if ("custom".equals(string)) {
            n2 = 4;
        } else {
            System.err.println("Invalid output format type!");
            XSDSchemaDocumentationGenerator.f(false);
        }
        return n2;
    }

    public static void main(String[] stringArray) throws MalformedURLException, IOException, ParserConfigurationException, TransformerException {
        try {
            fb.k("XML schema documentation generation", true, true, true);
        }
        catch (gc | c exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        if (stringArray.length < 1 || stringArray.length > 7) {
            System.err.println("Invalid number of arguments!");
            XSDSchemaDocumentationGenerator.f(false);
        } else if (stringArray.length == 1 && ("--help".equals(stringArray[0]) || "--h".equals(stringArray[0]) || "-help".equals(stringArray[0]) || "-h".equals(stringArray[0]))) {
            XSDSchemaDocumentationGenerator.f(true);
        } else {
            XSDSchemaDocumentationGenerator.b(stringArray);
        }
        System.exit(0);
    }

    private static void b(String[] stringArray) {
        URL uRL = null;
        XSDDocumentationOptions xSDDocumentationOptions = null;
        Object object = stringArray[0];
        if (((String)object).startsWith("www")) {
            object = "http://" + (String)object;
        }
        String string = null;
        try {
            uRL = new URL(URLUtil.correct((String)object, (boolean)false));
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File((String)object);
            if (file.isFile() && file.exists()) {
                try {
                    uRL = URLUtil.correct((File)file);
                }
                catch (MalformedURLException malformedURLException2) {}
            }
            string = "Specified schema file does not exist: " + file.getAbsolutePath();
        }
        if (uRL == null) {
            if (string != null) {
                System.err.println(string);
            } else {
                XSDSchemaDocumentationGenerator.f(false);
            }
        } else {
            xSDDocumentationOptions = XSDSchemaDocumentationGenerator.c(stringArray, uRL);
        }
        if (xSDDocumentationOptions != null) {
            i i2 = new i();
            i2.u(new w());
            try {
                i2.nb(xSDDocumentationOptions, uRL);
                System.out.println("XML schema documentation generation successful.");
            }
            catch (ErrorListException errorListException) {
                System.err.println(n.k(errorListException.getErrorList(), "XML schema documentation generation failed: "));
                System.exit(1);
            }
        } else {
            System.err.println("XML schema documentation generation failed.");
            System.exit(1);
        }
    }

    static XSDDocumentationOptions c(String[] stringArray, URL uRL) {
        Map<String, Object> map = XSDSchemaDocumentationGenerator.h(stringArray);
        XSDDocumentationOptions xSDDocumentationOptions = null;
        File file = (File)map.get(b);
        if (file != null) {
            if (file.exists()) {
                try {
                    k k2 = new k(false, je.b);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    k2.load(bufferedInputStream);
                    xSDDocumentationOptions = (XSDDocumentationOptions)k2.getObjectProperty("xsd.documentation.options");
                    if (xSDDocumentationOptions == null) {
                        System.err.println("Invalid configuration file format!");
                    }
                }
                catch (IOException iOException) {
                    System.err.print("Invalid configuration file: ");
                    iOException.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.err.println("The configuration file '" + file + "' could not be found!");
            }
        }
        if (xSDDocumentationOptions == null) {
            xSDDocumentationOptions = new XSDDocumentationOptions();
            xSDDocumentationOptions.setFormat(1);
            xSDDocumentationOptions.setSplitMethod(1);
            xSDDocumentationOptions.setOpenOutputInBrowser(false);
        }
        xSDDocumentationOptions = XSDSchemaDocumentationGenerator.d(uRL, map, xSDDocumentationOptions);
        xSDDocumentationOptions = XSDSchemaDocumentationGenerator.g(xSDDocumentationOptions, file);
        return xSDDocumentationOptions;
    }

    private static XSDDocumentationOptions d(URL uRL, Map<String, Object> map, XSDDocumentationOptions xSDDocumentationOptions) {
        String string;
        Integer n2;
        Object object;
        String string2;
        Integer n3 = (Integer)map.get(c);
        if (n3 != null) {
            xSDDocumentationOptions.setFormat(n3);
        }
        if ((string2 = (String)map.get(f)) != null) {
            object = new File(string2);
            if (!uRL.getProtocol().equals("file") && !((File)object).isAbsolute()) {
                System.err.println("Relative output is not supported for remote schemas. Please specify a local output file!");
                XSDSchemaDocumentationGenerator.f(false);
            }
            xSDDocumentationOptions.setOutputFile(string2);
        }
        n3 = xSDDocumentationOptions.getFormat();
        object = (String)map.get(d);
        if (n3 == 4 && object != null) {
            try {
                xSDDocumentationOptions.setCustomXSL(URLUtil.correct((File)new File((String)object)));
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Invalid XSL file: ");
                malformedURLException.printStackTrace();
            }
        }
        if ((n2 = (Integer)map.get(e)) != null && (n3 == 1 || n3 == 4)) {
            xSDDocumentationOptions.setSplitMethod(n2);
        }
        if ((string = (String)map.get(g)) != null) {
            xSDDocumentationOptions.setOpenOutputInBrowser(Boolean.valueOf(string));
        }
        return xSDDocumentationOptions;
    }

    private static XSDDocumentationOptions g(XSDDocumentationOptions xSDDocumentationOptions, File file) {
        Object object;
        int n2 = xSDDocumentationOptions.getFormat();
        if (file == null && n2 == 4) {
            object = xSDDocumentationOptions.getXSL();
            boolean bl = false;
            if (object != null) {
                String string = URLUtil.extractFileName((URL)object);
                if (string == null || string.trim().isEmpty()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                System.err.println("Stylesheet file for custom output format not specified!");
                System.err.println("Use the '-xsl' parameter as indicated below.");
                XSDSchemaDocumentationGenerator.f(false);
            }
        }
        if ((object = xSDDocumentationOptions.getUnexpandedOutputFile()) == null) {
            switch (n2) {
                case 1: {
                    object = "${cfn}.html";
                    break;
                }
                case 2: {
                    object = "${cfn}.pdf";
                    break;
                }
                case 3: {
                    object = "${cfn}.xml";
                    break;
                }
                case 5: {
                    object = "${cfn}.ditamap";
                    break;
                }
                case 4: {
                    object = "${cfn}.xml";
                }
            }
            xSDDocumentationOptions.setOutputFile((String)object);
        }
        return xSDDocumentationOptions;
    }

    private static Map<String, Object> h(String[] stringArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.startsWith(b)) {
                String string2 = stringArray[1].substring(5);
                if (!string2.isEmpty()) {
                    hashMap.put(b, new File(string2));
                    continue;
                }
                System.err.println("Invalid configuration file name!");
                XSDSchemaDocumentationGenerator.f(false);
                continue;
            }
            if (string.startsWith(e)) {
                if (!hashMap.containsKey(e)) {
                    hashMap.put(e, XSDSchemaDocumentationGenerator.e(string));
                    continue;
                }
                System.err.println("Split method already specified!");
                XSDSchemaDocumentationGenerator.f(false);
                continue;
            }
            if (string.startsWith(c)) {
                if (!hashMap.containsKey(c)) {
                    hashMap.put(c, XSDSchemaDocumentationGenerator.i(string));
                    continue;
                }
                System.err.println("Output format type already specified!");
                XSDSchemaDocumentationGenerator.f(false);
                continue;
            }
            if (string.startsWith(d)) {
                if (!hashMap.containsKey(d)) {
                    hashMap.put(d, string.substring(d.length()));
                    continue;
                }
                System.err.println("Stylesheet file already specified!");
                XSDSchemaDocumentationGenerator.f(false);
                continue;
            }
            if (string.startsWith(f)) {
                if (!hashMap.containsKey(f)) {
                    hashMap.put(f, string.substring(f.length()));
                    continue;
                }
                System.err.println("Output file already specified!");
                XSDSchemaDocumentationGenerator.f(false);
                continue;
            }
            if (string.startsWith(g)) {
                if (!hashMap.containsKey(g)) {
                    hashMap.put(g, string.substring(g.length()));
                    continue;
                }
                System.err.println("Open in browser already specified!");
                XSDSchemaDocumentationGenerator.f(false);
                continue;
            }
            System.err.println("Invalid argument: " + string);
            XSDSchemaDocumentationGenerator.f(false);
        }
        return hashMap;
    }
}

