/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.generator;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.gc;
import ro.sync.g.e.c;
import ro.sync.util.fb;
import ro.sync.xml.generator.p;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class XMLInstanceGenerator {
    protected static final String[] c = new String[]{"-verbose", "-s", "-n", "-r", "-o", "-f", "-i"};
    protected static final String[] b = new String[]{"verbose", "schema", "nameSpace", "root", "outDir", "fileName", "instancesNo"};

    public static void main(String[] stringArray) {
        XMLInstanceGenerator.checkLicense();
        XMLInstanceGenerator.generate(stringArray);
        System.exit(0);
    }

    public static void generate(String[] stringArray) {
        if (stringArray.length > 0) {
            XMLInstanceGenerator.processArgsAndGenerateXMLInstances(stringArray);
        } else {
            System.err.println("No arguments found in the command line.\n");
            XMLInstanceGenerator.c();
            System.exit(1);
        }
    }

    public static void checkLicense() {
        try {
            fb.k("XML instance generation", true, true, true);
        }
        catch (gc | c exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
    }

    public static void processArgsAndGenerateXMLInstances(String[] stringArray) {
        boolean bl;
        String string = stringArray[0];
        boolean bl2 = bl = "--help".equals(string) || "-help".equals(string) || "--h".equals(string) || "-h".equals(string);
        if (stringArray.length == 1 && bl) {
            XMLInstanceGenerator.c();
            System.exit(1);
        } else {
            List<String> list = Arrays.asList(c);
            File file = null;
            if (!list.contains(string) && !(file = new File(string)).exists()) {
                System.err.println("\nCannot find the specified file: " + string + ".\n");
                XMLInstanceGenerator.c();
                System.exit(1);
            }
            XMLInstanceGenerator.b(stringArray, file);
        }
    }

    private static void b(String[] stringArray, File file) {
        try {
            Map<String, String> map = XMLInstanceGenerator.d(stringArray, file != null);
            boolean bl = XMLInstanceGenerator.areRealOptionsProvided(map);
            if (file == null) {
                XMLInstanceGenerator.checkOptions(map, bl);
            }
            p p2 = new p(file, map.get(b[0]) != null);
            p2.nb(bl ? map : null);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Argument list wrongly provided.\n");
            XMLInstanceGenerator.c();
            System.exit(1);
        }
    }

    public static void checkOptions(Map<String, String> map, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (map.get(b[1]) == null) {
                System.err.println("No XML schema specified.\n");
                bl2 = true;
            } else if (map.get(b[3]) == null) {
                System.err.println("No root element specified.\n");
                bl2 = true;
            } else if (map.get(b[4]) == null) {
                String string = map.get(b[1]);
                if (map.get(b[1]).startsWith("file:")) {
                    map.put(b[4], new File(URLUtil.getDescription((URL)URLUtil.convertToURL((String)string))).getParent());
                } else {
                    System.err.println("No output directory specified.\n");
                    bl2 = true;
                }
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            XMLInstanceGenerator.c();
            System.exit(1);
        }
    }

    public static boolean areRealOptionsProvided(Map<String, String> map) {
        boolean bl = false;
        Set<String> set = map.keySet();
        for (String string : set) {
            if (b[0].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Map<String, String> d(String[] stringArray, boolean bl) {
        int n2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n3 = n2 = bl ? 1 : 0;
        while (n2 < stringArray.length) {
            if (c[0].equals(stringArray[n2])) {
                hashMap.put(b[0], "true");
            } else if (c[1].equals(stringArray[n2])) {
                String string = stringArray[++n2];
                hashMap.put(b[1], new File(string).exists() ? URLUtil.convertToURL((String)string).toExternalForm() : string);
            } else if (c[2].equals(stringArray[n2])) {
                hashMap.put(b[2], stringArray[++n2]);
            } else if (c[3].equals(stringArray[n2])) {
                hashMap.put(b[3], stringArray[++n2]);
            } else if (c[4].equals(stringArray[n2])) {
                hashMap.put(b[4], new File(stringArray[++n2]).getAbsolutePath());
            } else if (c[5].equals(stringArray[n2])) {
                hashMap.put(b[5], stringArray[++n2]);
            } else if (c[6].equals(stringArray[n2])) {
                hashMap.put(b[6], stringArray[++n2]);
            }
            ++n2;
        }
        return hashMap;
    }

    private static void c() {
        System.out.println("Script for generating XML instances using the oXygen XML Editor instance generator.\n");
        String string = " [[path_of_CFG_file] [-s XML_schema_path -r root [-n ns] [-o output_dir] [-f instance_name] [-i no_of_instances]] [-verbose]] | [-help | --help | -h | --h]";
        System.err.println((PlatformDetector.isWin() ? "xmlGenerator.bat" : "sh xmlGenerator.sh") + string);
        System.out.println();
        System.out.println("Where:\n" + "  path_of_CFG_file = the path of the file containing the configuration to be used\n" + "  -s XML_schema_path = the path of the XML schema used for XML file(s) generation\n" + "  -n ns = the namespace used for XML namespace declaration\n" + "  -r root = the root element for the generated file(s)\n" + "  -o output_dir = the output directory for storing the generated file(s)\n" + "  -f instance_name = the pattern name for the generated file(s) (usually name + extension)\n" + "  -i no_of_instances = the number of generated XML files\n" + "  -verbose = information about the process will be provided during the instance generation\n" + "  -help | --help | -h | --h = shows this help.\n" + "\nAny value specified by -s, -n, -r, -o, -f, -i arguments complements/overrides the corresponding " + "values from the configuration file, if that file is specified in the command line as first argument.");
    }
}

