/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util.editorvars;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.ExceptCVSAndSVNFileFilter;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.Formatter;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.options.Options;
import ro.sync.exml.options.me;
import ro.sync.exml.workspace.api.util.EditorVariableDescription;
import ro.sync.exml.workspace.api.util.EditorVariablesResolver;
import ro.sync.io.TemporaryFilesFactory;
import ro.sync.options.NotifyableMap;
import ro.sync.security.Sandbox;
import ro.sync.util.ab;
import ro.sync.util.eb;
import ro.sync.util.editorvars.EditorVariablesBase;
import ro.sync.util.editorvars.UserEditorVariablePO;
import ro.sync.util.editorvars.b;
import ro.sync.util.editorvars.e;
import ro.sync.util.editorvars.expander.EditorVariableExpander;
import ro.sync.util.editorvars.expander.EditorVariableResolver;
import ro.sync.util.editorvars.expander.EditorVariableUtil;
import ro.sync.util.editorvars.expander.ErrorListener;
import ro.sync.util.editorvars.expander.OperationCancelledException;
import ro.sync.util.editorvars.g;
import ro.sync.util.editorvars.i;
import ro.sync.util.editorvars.k;
import ro.sync.util.editorvars.o;
import ro.sync.util.editorvars.parser.ParseException;
import ro.sync.util.editorvars.parser.model.EditorVariable;
import ro.sync.util.editorvars.parser.model.LexicalItem;
import ro.sync.util.h;
import ro.sync.util.jb;
import ro.sync.util.m;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public final class EditorVariables
extends EditorVariablesBase {
    private static final Logger logger = LoggerFactory.getLogger((String)EditorVariables.class.getName());
    static AtomicBoolean frameworksDirInitialized = new AtomicBoolean(false);
    static final ImmutableSet<String> EDITOR_VARIABLES_SET = ImmutableSet.builder().add((Object)"${cfd}").add((Object)"${cfdu}").add((Object)"${cf}").add((Object)"${currentFileURL}").add((Object)"${cfu}").add((Object)"${cfn}").add((Object)"${cfne}").add((Object)"${pdu}").add((Object)"${pd}").add((Object)"${pn}").add((Object)"${frameworks}").add((Object)"${frameworksDir}").add((Object)"${configured.ditaot.dir}").add((Object)"${configured.ditaot.dir.url}").add((Object)"${rootMapURL}").add((Object)"${rootMapFile}").add((Object)"${rootMapDir}").add((Object)"${rootMapDirURL}").add((Object)"${activeConditionSet}").add((Object)"${xmlCatalogFilesList}").add((Object)"${baseFramework}").add((Object)"${baseFrameworkDir}").add((Object)"${home}").add((Object)"${homeDir}").add((Object)"${oxygenInstallDir}").add((Object)"${oxygenHome}").add((Object)"${ds}").add((Object)"${dsu}").add((Object)"${tsf}").add((Object)"${dbgXML}").add((Object)"${dbgXSL}").add((Object)"${method}").add((Object)"${ah_method}").add((Object)"${fo}").add((Object)"${out}").add((Object)"${outu}").add((Object)"${xml}").add((Object)"${xsl}").add((Object)"${sql}").add((Object)"${xq}").add((Object)"${xproc}").add((Object)"${xmlu}").add((Object)"${xslu}").add((Object)"${sqlu}").add((Object)"${xqu}").add((Object)"${xprocu}").add((Object)"${ps}").add((Object)"${timeStamp}").add((Object)"${uuid}").add((Object)"${id}").add((Object)"<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>").add((Object)"${afn}").add((Object)"${afne}").add((Object)"${af}").add((Object)"${afu}").add((Object)"${afd}").add((Object)"${afdu}").add((Object)"${frameworkDir}").add((Object)"${framework}").add((Object)"${author.name}").build();
    private static m projectURLProvider;
    private static ro.sync.util.i archiveURLProvider;
    private static me additionalFrameworksProvider;
    private static File userUploadedFrameworksDir;
    private static final List<EditorVariablesResolver> customResolvers;
    private static ro.sync.util.editorvars.m catalogUtilsAccess;
    private static URL frameworksURLForTests;
    private static ThreadLocal<Boolean> frameworksDirInitializing;
    static URL DEFAULT_FRAMEWORK_URL;
    private static File frameworksDirForTests;
    private static File cachedCustomFrameworksDir;
    private static boolean isLoadedFromOptions;
    private static g conditionSetNameResolver;
    private static URL lastFrameworksURL;
    private static File lastFrameworksDir;

    public static String getDescription(String string) {
        String string2 = (String)o.b.get((Object)string);
        if (string2 == null) {
            List<EditorVariableDescription> list;
            UserEditorVariablePO[] userEditorVariablePOArray = (UserEditorVariablePO[])Options.getInstance().getObjectArrayProperty("user.defined.editor.variables", UserEditorVariablePO.class);
            for (int i2 = 0; i2 < userEditorVariablePOArray.length; ++i2) {
                String string3 = userEditorVariablePOArray[i2].getVarName();
                if (!string3.equals(string)) continue;
                string2 = userEditorVariablePOArray[i2].getVarShortDescription();
                break;
            }
            if (string2 == null && (list = EditorVariables.getAllCustomResolvedEditorVariables()) != null) {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    String string4 = list.get(i3).getName();
                    if (string4 == null || !string4.equals(string)) continue;
                    string2 = list.get(i3).getShortDescription();
                    break;
                }
            }
        }
        return string2 != null ? string2 : "";
    }

    public static boolean possiblyContainsEditorVariable(String string) {
        return string != null && string.contains("${");
    }

    public static boolean containsXPathEvalEditorVariable(String string) {
        return string != null && string.contains("${xpath_eval(");
    }

    public static boolean containsInteractiveVariable(String string) {
        return string != null && (string.contains("${ask(") || string.contains("${answer("));
    }

    public static boolean containsEditorVariable(String string) {
        boolean bl = false;
        if (EditorVariables.possiblyContainsEditorVariable(string)) {
            for (UserEditorVariablePO[] userEditorVariablePOArray : EDITOR_VARIABLES_SET) {
                if (!string.contains((CharSequence)userEditorVariablePOArray)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                UserEditorVariablePO[] userEditorVariablePOArray;
                userEditorVariablePOArray = (UserEditorVariablePO[])Options.getInstance().getObjectArrayProperty("user.defined.editor.variables", UserEditorVariablePO.class);
                for (int i2 = 0; i2 < userEditorVariablePOArray.length; ++i2) {
                    String string2 = userEditorVariablePOArray[i2].getVarName();
                    if (!string.contains(string2)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl && (string.contains("${env(") || string.contains("${system(") || string.contains("${date(") || string.contains("${xpath_eval(") || string.contains("${makeRelative(") || string.contains("${framework(") || string.contains("${frameworkDir(") || string.contains("${pluginDir(") || string.contains("${pluginDirURL(")) && string.contains(")}")) {
                bl = true;
            }
        }
        return bl;
    }

    public static String expandEditorVariablesAsFilePath(String string, String string2) {
        String string3 = EditorVariables.expandEditorVariables(string, string2);
        if (string3 != null && string3.contains(":/")) {
            try {
                File file = URLUtil.getCanonicalFileFromFileUrl((URL)new URL(string3));
                if (file != null) {
                    string3 = file.getAbsolutePath();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string3;
    }

    public static URL expandEditorVariablesAsURL(String string, String string2) {
        URL uRL;
        block4: {
            String string3 = EditorVariables.expandEditorVariables(string, string2);
            uRL = null;
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                if (string2 == null) break block4;
                try {
                    uRL = new URL(new URL(string2), string3);
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
        }
        return uRL;
    }

    public static String expandEditorVariables(String string, String string2) {
        try {
            string = EditorVariables.expandEditorVariables(string, string2, null, null);
        }
        catch (OperationCancelledException | ParseException throwable) {
            logger.error((Object)throwable, throwable);
        }
        return string;
    }

    public static String expandEditorVariables(String string, String string2, Map<String, EditorVariableResolver> map, ErrorListener errorListener) throws ParseException, OperationCancelledException {
        Object object;
        int n2;
        if (string == null || string.isEmpty() || !EditorVariables.possiblyContainsEditorVariable(string)) {
            return string;
        }
        if (!customResolvers.isEmpty()) {
            int n3 = customResolvers.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = customResolvers.get(n2);
                String string3 = ((EditorVariablesResolver)object).resolveEditorVariables(string, string2);
                if (string3 == null) continue;
                string = string3;
            }
        }
        if (!EditorVariables.containsEditorVariable(string) && !EditorVariables.containsAdditionalEditorVariables(string, map)) {
            return string;
        }
        EditorVariableExpander editorVariableExpander = new EditorVariableExpander();
        if (errorListener != null) {
            editorVariableExpander.addErrorListener(errorListener);
        }
        editorVariableExpander.addErrorListener(new ErrorListener(){

            public void error(String string, ParseException parseException) {
                logger.debug((Object)parseException, (Throwable)parseException);
            }
        });
        editorVariableExpander.register("", editorVariable -> {
            Object object;
            block133: {
                Object object2;
                object = null;
                UserEditorVariablePO[] userEditorVariablePOArray = (UserEditorVariablePO[])Options.getInstance().getObjectArrayProperty("user.defined.editor.variables", UserEditorVariablePO.class);
                String string2 = editorVariable.getName();
                for (int i2 = 0; i2 < userEditorVariablePOArray.length; ++i2) {
                    object2 = userEditorVariablePOArray[i2];
                    if (!EditorVariables.getName(((UserEditorVariablePO)object2).getVarName()).equals(string2)) continue;
                    object = ((UserEditorVariablePO)object2).getVarValue();
                    break;
                }
                if (object == null) {
                    if (EditorVariables.fastEquals(string2, "${xmlCatalogFilesList}")) {
                        if (catalogUtilsAccess != null) {
                            object = catalogUtilsAccess.b();
                        }
                    } else {
                        if (EditorVariables.fastEquals(string2, "${configured.ditaot.dir.url}")) {
                            object = "";
                            try {
                                String string3 = EditorVariables.expandEditorVariables(Options.getInstance().getStringProperty("dita.ot.directory"), string2);
                                object2 = URLUtil.correct((File)new File(string3)).toString();
                                if (object2 != null && ((String)object2).endsWith("/")) {
                                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                                }
                                object = object2;
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)malformedURLException, (Throwable)malformedURLException);
                                }
                                break block133;
                            }
                        }
                        if (EditorVariables.fastEquals(string2, "${configured.ditaot.dir}")) {
                            object = Options.getInstance().getStringProperty("dita.ot.directory");
                        } else if (EditorVariables.fastEquals(string2, "${rootMapURL}")) {
                            b b2 = EditorVariables.getRootMapResolver();
                            Object object3 = object2 = b2 != null ? b2.getRootMapLocation() : null;
                            object = object2 != null ? ((URL)object2).toExternalForm() : "";
                        } else if (EditorVariables.fastEquals(string2, "${rootMapFile}")) {
                            File file;
                            b b3 = EditorVariables.getRootMapResolver();
                            Object object4 = object2 = b3 != null ? b3.getRootMapLocation() : null;
                            object = object2 != null ? ((file = URLUtil.getFileFromFileUrl((URL)object2, (boolean)false, (boolean)true, (boolean)true)) != null ? file.getAbsolutePath() : "") : "";
                        } else if (EditorVariables.fastEquals(string2, "${rootMapDir}")) {
                            File file;
                            b b4 = EditorVariables.getRootMapResolver();
                            Object object5 = object2 = b4 != null ? b4.getRootMapLocation() : null;
                            object = object2 != null ? ((file = URLUtil.getFileFromFileUrl((URL)object2, (boolean)false, (boolean)true, (boolean)true)) != null ? file.getParentFile().getAbsolutePath() : "") : "";
                        } else if (EditorVariables.fastEquals(string2, "${rootMapDirURL}")) {
                            b b5 = EditorVariables.getRootMapResolver();
                            object = "";
                            Object object6 = object2 = b5 != null ? b5.getRootMapLocation() : null;
                            if (object2 != null) {
                                try {
                                    object = URLUtil.getParentURL((URL)object2).toExternalForm();
                                }
                                catch (MalformedURLException malformedURLException) {}
                            }
                        } else if (EditorVariables.fastEquals(string2, "${activeConditionSet}")) {
                            String string4;
                            String string5 = string4 = conditionSetNameResolver != null ? conditionSetNameResolver.getCurrentConditionSetName(string2) : null;
                            object = string4 != null ? string4 : "";
                        } else if (EditorVariables.fastEquals(string2, "${author.name}")) {
                            object = Options.getInstance().getStringProperty("change.tracking.author");
                        } else if (EditorVariables.fastEquals(string2, "${framework(")) {
                            String string6 = null;
                            object2 = EditorVariables.getFrameworkLocationResolver();
                            List list = editorVariable.getParams();
                            if (!list.isEmpty()) {
                                String string7;
                                String string8 = ((LexicalItem)list.get(0)).getStringValue();
                                String string9 = string7 = object2 != null ? object2.getFrameworkLocation(string8) : null;
                                if (string7 != null) {
                                    try {
                                        string6 = URLUtil.correct((File)new File(string7).getParentFile()).toExternalForm();
                                        if (string6.endsWith("/")) {
                                            string6 = string6.substring(0, string6.length() - 1);
                                        }
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                                    }
                                } else {
                                    string6 = "";
                                }
                            }
                            object = string6;
                        } else if (EditorVariables.fastEquals(string2, "${frameworkDir(")) {
                            String string10 = null;
                            object2 = EditorVariables.getFrameworkLocationResolver();
                            List list = editorVariable.getParams();
                            if (!list.isEmpty()) {
                                String string11;
                                String string12 = ((LexicalItem)list.get(0)).getStringValue();
                                String string13 = string11 = object2 != null ? object2.getFrameworkLocation(string12) : null;
                                if (string11 != null) {
                                    string10 = new File(string11).getParentFile().getAbsolutePath().replace('\\', '/');
                                }
                            }
                            object = string10;
                        } else if (EditorVariables.fastEquals(string2, "${pluginDirURL(")) {
                            String string14 = "";
                            object2 = EditorVariables.getPluginLocationResolver();
                            List list = editorVariable.getParams();
                            if (!list.isEmpty()) {
                                String string15;
                                String string16 = ((LexicalItem)list.get(0)).getStringValue();
                                String string17 = string15 = object2 != null ? object2.getPluginFolderLocation(string16) : null;
                                if (string15 != null) {
                                    try {
                                        string14 = URLUtil.correct((File)new File(string15)).toExternalForm();
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                                    }
                                }
                            }
                            object = string14;
                        } else if (EditorVariables.fastEquals(string2, "${pluginDir(")) {
                            String string18 = "";
                            object2 = EditorVariables.getPluginLocationResolver();
                            List list = editorVariable.getParams();
                            if (!list.isEmpty()) {
                                String string19;
                                String string20 = ((LexicalItem)list.get(0)).getStringValue();
                                String string21 = string19 = object2 != null ? object2.getPluginFolderLocation(string20) : null;
                                if (string19 != null) {
                                    string18 = new File(string19).getAbsolutePath().replace('\\', '/');
                                }
                            }
                            object = string18;
                        } else if (EditorVariables.fastEquals(string2, "${date(")) {
                            String string22 = "";
                            try {
                                object2 = editorVariable.getParams();
                                if (!object2.isEmpty()) {
                                    String string23 = ((LexicalItem)object2.get(0)).getStringValue();
                                    if (string23.equalsIgnoreCase("xs:date")) {
                                        Calendar calendar = Calendar.getInstance();
                                        calendar.setTime(new Date());
                                        string22 = DatatypeConverter.printDate((Calendar)calendar);
                                    } else if (string23.equalsIgnoreCase("xs:dateTime")) {
                                        Calendar calendar = Calendar.getInstance();
                                        calendar.setTime(new Date());
                                        string22 = DatatypeConverter.printDateTime((Calendar)calendar);
                                    } else {
                                        string22 = new SimpleDateFormat(string23).format(new Date());
                                    }
                                }
                                object = string22;
                            }
                            catch (Exception exception) {
                                logger.warn((Object)exception, (Throwable)exception);
                                object = "";
                            }
                        } else if (EditorVariables.fastEquals(string2, "${pd}")) {
                            File file = EditorVariables.getProjectDirectory(string2);
                            if (file != null) {
                                object2 = file.toString();
                                if (((String)object2).endsWith("/")) {
                                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                                }
                                object = object2;
                            } else {
                                object = "";
                            }
                        } else if (EditorVariables.fastEquals(string2, "${pn}")) {
                            String string24 = EditorVariables.getProjectName(string2);
                            object = string24 != null ? string24 : "";
                        } else if (EditorVariables.fastEquals(string2, "${pdu}")) {
                            int n2;
                            object = "";
                            URL uRL = EditorVariables.getCurrentProjectURL(string2);
                            if (uRL != null && (n2 = ((String)(object2 = uRL.toString())).lastIndexOf(47)) != -1) {
                                object = object2 = ((String)object2).substring(0, n2);
                            }
                        } else if (EditorVariables.fastEquals(string2, "${afn}")) {
                            object = "";
                            URL uRL = EditorVariables.getCurrentArchiveURL(string2);
                            if (uRL != null && (object2 = URLUtil.extractFileName((URL)uRL)) != null) {
                                int n3 = ((String)(object2 = URLUtil.uncorrect((String)object2))).lastIndexOf(46);
                                if (n3 != -1) {
                                    object2 = ((String)object2).substring(0, n3);
                                }
                                object = object2;
                            }
                        } else if (EditorVariables.fastEquals(string2, "${afne}")) {
                            object = "";
                            URL uRL = EditorVariables.getCurrentArchiveURL(string2);
                            if (uRL != null && (object2 = URLUtil.extractFileName((URL)uRL)) != null) {
                                object = object2 = URLUtil.uncorrect((String)object2);
                            }
                        } else if (EditorVariables.fastEquals(string2, "${af}")) {
                            object = "";
                            URL uRL = EditorVariables.getCurrentArchiveURL(string2);
                            if (uRL != null && (object2 = URLUtil.getCanonicalFileFromFileUrl((URL)uRL)) != null) {
                                object = ((File)object2).getAbsolutePath();
                            }
                        } else if (EditorVariables.fastEquals(string2, "${afu}")) {
                            object = "";
                            URL uRL = EditorVariables.getCurrentArchiveURL(string2);
                            if (uRL != null) {
                                object = uRL.toString();
                            }
                        } else if (EditorVariables.fastEquals(string2, "${afd}")) {
                            object = "";
                            URL uRL = EditorVariables.getCurrentArchiveURL(string2);
                            if (uRL != null && (object2 = URLUtil.getCanonicalFileFromFileUrl((URL)uRL)) != null) {
                                object = ((File)object2).getParentFile().getAbsolutePath();
                            }
                        } else if (EditorVariables.fastEquals(string2, "${afdu}")) {
                            object = "";
                            URL uRL = EditorVariables.getCurrentArchiveURL(string2);
                            if (uRL != null && (object2 = URLUtil.getCanonicalFileFromFileUrl((URL)uRL)) != null) {
                                try {
                                    object = URLUtil.correct((File)((File)object2).getParentFile()).toString();
                                }
                                catch (MalformedURLException malformedURLException) {
                                    logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                                }
                            }
                        } else if (EditorVariables.fastEquals(string2, "${home}")) {
                            object = "";
                            try {
                                object = URLUtil.correct((File)new File(System.getProperty("user.home"))).toExternalForm();
                            }
                            catch (MalformedURLException malformedURLException) {
                                logger.error("Cannot convert user.home to URL." + malformedURLException, (Throwable)malformedURLException);
                            }
                        } else if (EditorVariables.fastEquals(string2, "${homeDir}")) {
                            object = new File(System.getProperty("user.home")).toString();
                        } else {
                            if (EditorVariables.fastEquals(string2, "${frameworks}")) {
                                object = "";
                                String string25 = System.getProperty("com.oxygenxml.editor.home.url");
                                try {
                                    object2 = EditorVariables.getFrameworksUrl();
                                    object = ((URL)object2).toString();
                                }
                                catch (MalformedURLException malformedURLException) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + string25);
                                    }
                                    break block133;
                                }
                            }
                            if (EditorVariables.fastEquals(string2, "${frameworksDir}")) {
                                object = "";
                                String string26 = System.getProperty("com.oxygenxml.editor.home.url");
                                try {
                                    object2 = EditorVariables.getFrameworksDir();
                                    if (object2 != null) {
                                        object = ((File)object2).toString();
                                    }
                                    break block133;
                                }
                                catch (MalformedURLException malformedURLException) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + string26);
                                    }
                                    break block133;
                                }
                            }
                            if (EditorVariables.fastEquals(string2, "${oxygenInstallDir}")) {
                                object = ab.c();
                            } else if (EditorVariables.fastEquals(string2, "${oxygenHome}")) {
                                object = System.getProperty("com.oxygenxml.editor.home.url");
                            } else if (EditorVariables.fastEquals(string2, "${ps}")) {
                                object = EditorVariables.getSystemPathSeparator();
                            } else if (EditorVariables.fastEquals(string2, "${timeStamp}")) {
                                object = EditorVariables.getTimeStamp();
                            } else if (EditorVariables.fastEquals(string2, "${uuid}")) {
                                object = UUID.randomUUID().toString();
                            } else if (EditorVariables.fastEquals(string2, "${id}")) {
                                object = h.c();
                            } else if (EditorVariables.fastEquals(string2, "${makeRelative(")) {
                                String string27 = null;
                                object2 = editorVariable.getParams();
                                if (object2.size() == 2) {
                                    String string28 = ((LexicalItem)object2.get(0)).getStringValue();
                                    String string29 = ((LexicalItem)object2.get(1)).getStringValue();
                                    try {
                                        string27 = URLUtil.makeRelative((URL)new URL(string28), (URL)new URL(string29));
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        try {
                                            URL uRL = URLUtil.correct((File)new File(string28));
                                            if (string28.endsWith("/")) {
                                                uRL = new URL(uRL + "/");
                                            }
                                            URL uRL2 = URLUtil.correct((File)new File(string29));
                                            if (string29.endsWith("/")) {
                                                uRL2 = new URL(uRL2 + "/");
                                            }
                                            string27 = URLUtil.makeRelative((URL)uRL, (URL)uRL2);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                object = string27;
                            } else if (EditorVariables.fastEquals(string2, "${xpath_eval(")) {
                                object = "";
                                List list = editorVariable.getParams();
                                if (!list.isEmpty()) {
                                    object2 = ((LexicalItem)list.get(0)).getStringValue();
                                    try {
                                        final k k2 = EditorVariables.getXpathEvaluator();
                                        if (k2 == null) break block133;
                                        try {
                                            String string30 = (String)Sandbox.runWithConnectConfirmation((String)("XPath execution tried to connect to {0}. XPath: " + (String)object2), (PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){
                                                final /* synthetic */ String d;
                                                final /* synthetic */ String b;
                                                {
                                                    this.d = string;
                                                    this.b = string2;
                                                }

                                                public String b() throws Exception {
                                                    return (String)Sandbox.runWithPerms((long)2311L, (PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                                                        public String b() throws Exception {
                                                            return k2.b(d, b);
                                                        }
                                                    });
                                                }
                                            });
                                            if (string30 != null) {
                                                object = string30;
                                            }
                                        }
                                        catch (PrivilegedActionException privilegedActionException) {
                                            throw privilegedActionException.getException();
                                        }
                                        catch (SecurityException securityException) {
                                            logger.error((Object)securityException, (Throwable)securityException);
                                        }
                                    }
                                    catch (Exception exception) {
                                        logger.warn((Object)exception, (Throwable)exception);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return object;
        });
        string = EditorVariables.slashifyIfNeeded(string, "${frameworks}");
        string = EditorVariables.slashifyIfNeeded(string, "${frameworksDir}");
        EditorVariables.registerEnvAndSystemResolver(editorVariableExpander);
        if (string2 != null && string2.length() > 0) {
            n2 = 0;
            try {
                object = new URL(string2);
                n2 = ((URL)object).getProtocol().equals("jar") ? 1 : 0;
            }
            catch (MalformedURLException malformedURLException) {
                logger.warn((Object)malformedURLException, (Throwable)malformedURLException);
            }
            if (n2 == 0) {
                string = EditorVariables.slashifyIfNeeded(string, "${cfdu}");
            }
            object = new _b(string2, string);
            editorVariableExpander.register(EditorVariables.getName("${cfdu}"), (EditorVariableResolver)object);
            editorVariableExpander.register(EditorVariables.getName("${cfd}"), (EditorVariableResolver)object);
            editorVariableExpander.register(EditorVariables.getName("${cfn}"), (EditorVariableResolver)object);
            editorVariableExpander.register(EditorVariables.getName("${cfne}"), (EditorVariableResolver)object);
            editorVariableExpander.register(EditorVariables.getName("${cf}"), (EditorVariableResolver)object);
            editorVariableExpander.register(EditorVariables.getName("${currentFileURL}"), editorVariable -> string2);
            editorVariableExpander.register(EditorVariables.getName("${cfu}"), editorVariable -> string2);
        }
        if (map != null) {
            Set<String> set = map.keySet();
            for (String string3 : set) {
                editorVariableExpander.register(string3, map.get(string3));
            }
        }
        return editorVariableExpander.expand(string);
    }

    private static boolean containsAdditionalEditorVariables(String string, Map<String, EditorVariableResolver> map) {
        boolean bl = false;
        if (map != null && !map.isEmpty()) {
            Set<String> set = map.keySet();
            for (String string2 : set) {
                if (!string.contains(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static String getProjectName(String string) {
        int n2;
        String string2 = null;
        URL uRL = EditorVariables.getCurrentProjectURL(string);
        if (PlatformDetector.isEclipse()) {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            if (file != null) {
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                string2 = file.getName();
            }
        } else if (uRL != null && (string2 = URLUtil.extractFileName((String)URLUtil.uncorrect((String)uRL.toString()))) != null && (n2 = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    private static File getProjectDirectory(String string) {
        block4: {
            URL uRL = EditorVariables.getCurrentProjectURL(string);
            if (uRL != null) {
                try {
                    File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
                    if (file != null && !file.isDirectory()) {
                        file = file.getParentFile();
                    }
                    return file;
                }
                catch (Throwable throwable) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Project dir could not be calculated: " + throwable, throwable);
                }
            }
        }
        return null;
    }

    public static String makeURLRelative2Frameworks(String string) {
        if (string != null) {
            try {
                String string2 = EditorVariables.getFrameworksUrl().toString();
                StringBuilder stringBuilder = new StringBuilder();
                if (string.startsWith(string2) && (string.length() == string2.length() || string2.endsWith("/") || string.charAt(string2.length()) == '/' || string.charAt(string2.length()) == '\\')) {
                    stringBuilder.append("${frameworks}");
                    if (string2.endsWith("/")) {
                        stringBuilder.append("/");
                    }
                    stringBuilder.append(string.substring(string2.length()));
                    string = stringBuilder.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String makeFileRelative2DITAOTDir(String string) {
        String string2 = null;
        if (string != null) {
            try {
                String string3 = EditorVariables.expandEditorVariables("${configured.ditaot.dir}", null);
                Object object = new File(string).getCanonicalPath();
                StringBuilder stringBuilder = new StringBuilder();
                if (object != null && string3 != null) {
                    object = ((String)object).replace('\\', '/');
                    string3 = string3.replace('\\', '/');
                    if (string.endsWith("/") || string.endsWith("\\")) {
                        object = (String)object + "/";
                    }
                    if (EditorVariables.isAncestorOrSame((String)object, string3)) {
                        stringBuilder.append("${configured.ditaot.dir}");
                        stringBuilder.append(((String)object).substring(string3.length()));
                        string2 = stringBuilder.toString();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    private static boolean isAncestorOrSame(String string, String string2) {
        return string.startsWith(string2) && (string.length() == string2.length() || string.charAt(string2.length()) == '/');
    }

    public static String makeFileRelative2Frameworks(String string) {
        if (string != null) {
            try {
                String string2 = EditorVariables.getFrameworksDir().getCanonicalPath();
                Object object = new File(string).getCanonicalPath();
                if (string2 != null && object != null) {
                    object = ((String)object).replace('\\', '/');
                    string2 = string2.replace('\\', '/');
                    if (string.endsWith("/") || string.endsWith("\\")) {
                        object = (String)object + "/";
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (EditorVariables.isAncestorOrSame((String)object, string2)) {
                        stringBuilder.append("${frameworksDir}");
                        stringBuilder.append(((String)object).substring(string2.length()));
                        string = stringBuilder.toString();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void setFrameworksURLForTest(URL uRL) {
        frameworksURLForTests = uRL;
    }

    public static URL getFrameworksUrl() throws MalformedURLException {
        if (frameworksURLForTests != null) {
            return frameworksURLForTests;
        }
        return EditorVariables.getCurrentFrameworksURL();
    }

    public static void resetFrameworksDir() {
        frameworksDirInitialized.set(false);
        cachedCustomFrameworksDir = null;
        if (isLoadedFromOptions) {
            System.clearProperty("com.oxygenxml.editor.frameworks.url");
        }
    }

    public static URL getCurrentFrameworksURL() throws MalformedURLException {
        return EditorVariables.getCurrentFrameworksURL(Options.getInstance());
    }

    public static URL getCurrentFrameworksURL(final NotifyableMap notifyableMap) throws MalformedURLException {
        try {
            return (URL)Sandbox.runWithAllPerms((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                public URL b() throws Exception {
                    URL uRL = null;
                    if (!Boolean.TRUE.equals(frameworksDirInitializing.get())) {
                        String string;
                        if (!Boolean.TRUE.equals(frameworksDirInitialized.get())) {
                            if (System.getenv("com.oxygenxml.editor.frameworks.url") != null) {
                                System.setProperty("com.oxygenxml.editor.frameworks.url", System.getenv("com.oxygenxml.editor.frameworks.url"));
                            }
                            isLoadedFromOptions = false;
                            cachedCustomFrameworksDir = null;
                            if (System.getProperty("com.oxygenxml.editor.frameworks.url") == null && notifyableMap.getBooleanProperty("use.custom.frameworks.directory.url")) {
                                string = notifyableMap.getStringProperty("frameworks.directory.url.with.editor.variables");
                                if (string != null) {
                                    try {
                                        frameworksDirInitializing.set(true);
                                        string = EditorVariables.expandEditorVariables(string, null);
                                    }
                                    finally {
                                        frameworksDirInitializing.set(false);
                                    }
                                    try {
                                        uRL = new URL(string);
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                                        try {
                                            uRL = URLUtil.correct((File)new File(string));
                                        }
                                        catch (MalformedURLException malformedURLException2) {
                                            logger.error((Object)malformedURLException2, (Throwable)malformedURLException2);
                                        }
                                    }
                                }
                                if (uRL == null) {
                                    uRL = notifyableMap.getURLProperty("frameworks.directory.url");
                                }
                                boolean bl = isLoadedFromOptions = uRL != null;
                            }
                            if (uRL != null) {
                                System.setProperty("com.oxygenxml.editor.frameworks.url", uRL.toString());
                                cachedCustomFrameworksDir = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
                            }
                            frameworksDirInitialized.set(true);
                        }
                        if ((string = System.getProperty("com.oxygenxml.editor.frameworks.url")) != null) {
                            try {
                                uRL = new URL(URLUtil.correct((String)string, (boolean)false));
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                    if (uRL == null) {
                        uRL = EditorVariables.getDefaultFrameworkURL();
                    }
                    return uRL;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MalformedURLException) {
                throw (MalformedURLException)exception;
            }
            MalformedURLException malformedURLException = new MalformedURLException(privilegedActionException.getMessage());
            malformedURLException.initCause(privilegedActionException);
            throw malformedURLException;
        }
    }

    public static URL getDefaultFrameworkURL() throws MalformedURLException {
        if (DEFAULT_FRAMEWORK_URL == null) {
            String string = System.getProperty("com.oxygenxml.editor.home.url");
            DEFAULT_FRAMEWORK_URL = new URL(new URL(URLUtil.correct((String)string, (boolean)false)), "frameworks");
        }
        return DEFAULT_FRAMEWORK_URL;
    }

    public static void resetDefaultFrameworkURL() {
        DEFAULT_FRAMEWORK_URL = null;
    }

    public static void setFrameworksDirForTest(File file) {
        frameworksDirForTests = file;
    }

    public static synchronized File getFrameworksDir() throws MalformedURLException {
        if (frameworksDirForTests != null) {
            return frameworksDirForTests;
        }
        if (cachedCustomFrameworksDir != null) {
            return cachedCustomFrameworksDir;
        }
        URL uRL = EditorVariables.getCurrentFrameworksURL();
        if (lastFrameworksDir == null || !Equaler.verifyEquals((Object)lastFrameworksURL, (Object)uRL)) {
            lastFrameworksDir = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            lastFrameworksURL = uRL;
        }
        return lastFrameworksDir;
    }

    public static File getBaseUserFrameworksDir() {
        File file = userUploadedFrameworksDir != null ? userUploadedFrameworksDir : new File(jb.e().c(), "frameworks");
        return file;
    }

    public static File[] getUserFrameworksDirs() {
        final File file = EditorVariables.getBaseUserFrameworksDir();
        return (File[])Sandbox.runWithAllPerms((PrivilegedAction)new PrivilegedAction<File[]>(){

            public File[] b() {
                return file.listFiles((FileFilter)new ExceptCVSAndSVNFileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() && super.accept(file);
                    }
                });
            }
        });
    }

    public static File[] getAllFrameworksDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            File file;
            File[] fileArray;
            File[] fileArray2 = EditorVariables.getUserFrameworksDirs();
            if (fileArray2 != null) {
                arrayList.addAll(Arrays.asList(fileArray2));
            }
            if (additionalFrameworksProvider != null && (fileArray = additionalFrameworksProvider.getContributedFrameworksPluginDirs()) != null) {
                arrayList.addAll(Arrays.asList(fileArray));
            }
            if ((fileArray = EditorVariables.getAdditionalFrameworksDirs()) != null) {
                arrayList.addAll(Arrays.asList(fileArray));
            }
            if ((file = EditorVariables.getFrameworksDir()) != null) {
                arrayList.add(file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return arrayList.toArray(new File[0]);
    }

    public static File[] getAdditionalFrameworksDirs() {
        ArrayList<File> arrayList = null;
        String[] stringArray = Options.getInstance().getStringArrayProperty("additional.frameworks.directories");
        if (stringArray != null) {
            arrayList = new ArrayList<File>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = EditorVariables.expandEditorVariables(stringArray[i2], null);
                arrayList.add(new File(string));
            }
        }
        return arrayList != null ? arrayList.toArray(new File[0]) : null;
    }

    public static URL getCurrentProjectURL(String string) {
        URL uRL = null;
        if (projectURLProvider != null) {
            uRL = projectURLProvider.hwk(string);
        }
        if (uRL == null || "file:newProject.xpr".equals(uRL.toString())) {
            try {
                return URLUtil.correct((File)new File(System.getProperty("user.dir", ".")));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static URL getCurrentArchiveURL(String string) {
        URL uRL;
        block10: {
            uRL = null;
            if (string != null) {
                if (string.startsWith("zip:")) {
                    int n2 = string.indexOf("!/");
                    try {
                        if (n2 != -1) {
                            uRL = new URL(string.substring("zip:".length(), n2));
                            break block10;
                        }
                        uRL = new URL(string.substring("zip:".length(), string.length()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                    }
                } else {
                    eb eb2 = (eb)StaticComponentsRegistry.get((String)"ARCHIVE_EXTENSIONS_RECOGNIZER");
                    if (eb2 != null && eb2.b(string)) {
                        try {
                            uRL = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                        }
                    }
                }
            }
        }
        if (uRL == null && archiveURLProvider != null) {
            uRL = archiveURLProvider.zsi();
        }
        return uRL;
    }

    private static String slashifyIfNeeded(String object, String string) {
        if (((String)object).endsWith(string)) {
            object = (String)object + "/";
        }
        return object;
    }

    public static void setProjectURLProvider(m m2) {
        projectURLProvider = m2;
    }

    public static void setArchiveURLProvider(ro.sync.util.i i2) {
        archiveURLProvider = i2;
    }

    public static void setFrameworkLocationResolver(e e2) {
        StaticComponentsRegistry.register((String)"FRAMEWORK_LOCATION_RESOLVER", (Object)e2);
    }

    private static e getFrameworkLocationResolver() {
        return (e)StaticComponentsRegistry.get((String)"FRAMEWORK_LOCATION_RESOLVER");
    }

    private static i getPluginLocationResolver() {
        return (i)StaticComponentsRegistry.get((String)"PLUGIN_LOCATION_RESOLVER");
    }

    public static void setPluginLocationResolver(i i2) {
        StaticComponentsRegistry.register((String)"PLUGIN_LOCATION_RESOLVER", (Object)i2);
    }

    public static void setRootMapResolver(b b2) {
        StaticComponentsRegistry.register((String)"DITA_ROOT_MAP_PROVIDER", (Object)b2);
    }

    private static b getRootMapResolver() {
        return (b)StaticComponentsRegistry.get((String)"DITA_ROOT_MAP_PROVIDER");
    }

    public static void setConditionSetNameResolver(g g2) {
        conditionSetNameResolver = g2;
    }

    public static void setArchiveExtensionsRecognizer(eb eb2) {
        StaticComponentsRegistry.register((String)"ARCHIVE_EXTENSIONS_RECOGNIZER", (Object)eb2);
    }

    public static String getSystemPathSeparator() {
        return File.pathSeparator;
    }

    public static String expandFrameworksVariables(String string, String string2, _c _c2) {
        return EditorVariables.expandFrameworksVariables(string, string2, null, _c2);
    }

    public static String expandFrameworksVariables(String string, String string2, String string3, _c _c2) {
        block6: {
            Serializable serializable;
            Object object;
            try {
                if (string != null && string3 != null) {
                    object = EditorVariables.getCanonicalDir(string3);
                    serializable = URLUtil.correct((File)object);
                    string = EditorVariables.expandBaseFrameworkVars(string, string2, _c2, (File)object, (URL)serializable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException, (Throwable)malformedURLException);
            }
            if (string2 != null) {
                object = System.getProperty("com.oxygenxml.editor.home.url");
                try {
                    serializable = EditorVariables.getCanonicalDir(string2);
                    URL uRL = URLUtil.correct((File)serializable);
                    File file = ((File)serializable).getParentFile();
                    URL uRL2 = URLUtil.correct((File)file);
                    return EditorVariables.expandFrameworksVariables(string, _c2, file, uRL2, (File)serializable, uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + (String)object);
                }
            }
        }
        return string;
    }

    private static String expandBaseFrameworkVars(String string, String string2, _c _c2, File file, URL uRL) throws MalformedURLException {
        String string3 = uRL.toExternalForm();
        if (string3.endsWith("/")) {
            uRL = new URL(string3.substring(0, string3.length() - 1));
        }
        if (file != null && (_c2 == _c.e || _c2 == _c.d)) {
            String string4;
            File file2;
            String string5;
            _c _c3 = _c2;
            if (string2 == null) {
                _c3 = _c.e;
            } else if (_c2 == _c.d && !Equaler.verifyEquals((Object)(string5 = (file2 = EditorVariables.getCanonicalDir(string2)) != null ? file2.getParent() : null), (Object)(string4 = file.getParent()))) {
                _c3 = _c.e;
            }
            string = EditorVariables.expandFrameworkOnly(string, _c3, file.toString().replace('\\', '/'), uRL, true);
        }
        return string;
    }

    private static File getCanonicalDir(String string) {
        File file = null;
        if (string != null) {
            try {
                URL uRL = new URL(string);
                file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL).getParentFile();
            }
            catch (MalformedURLException malformedURLException) {
                file = new File(string).getParentFile();
            }
        }
        return file;
    }

    public static String expandFrameworksVariables(String string, _c _c2, File file, URL uRL, File file2, URL uRL2) {
        block10: {
            if (uRL2 != null && string != null) {
                String string2 = System.getProperty("com.oxygenxml.editor.home.url");
                try {
                    String string3 = uRL2.toExternalForm();
                    if (string3.endsWith("/")) {
                        uRL2 = new URL(string3.substring(0, string3.length() - 1));
                    }
                    if ((string3 = uRL.toExternalForm()).endsWith("/")) {
                        uRL = new URL(string3.substring(0, string3.length() - 1));
                    }
                    String string4 = file2.toString().replace('\\', '/');
                    if (_c2 != _c.h) {
                        string = EditorVariables.expandFrameworkOnly(string, _c2, string4, uRL2, false);
                    }
                    if (_c2 != _c.d) {
                        String string5 = string = EditorVariables.slashifyIfNeeded(string, "${frameworks}");
                        String string6 = string = Formatter.formatMessage((String)string, (String)"${frameworks}", (String)uRL.toString());
                        if (_c2 != _c.e && (string = Formatter.formatMessage((String)string, (String)(uRL2.toExternalForm() + "/"), (String)"${framework}/")).equals(string6)) {
                            string = string6.equals(uRL2.toExternalForm()) ? "${framework}/" : string5;
                        }
                        string = EditorVariables.slashifyIfNeeded(string, "${frameworksDir}");
                        if (file != null) {
                            String string7 = file.toString().replace('\\', '/');
                            string5 = string;
                            string6 = string = Formatter.formatMessage((String)string, (String)"${frameworksDir}", (String)string7);
                            if (_c2 != _c.e && (string = Formatter.formatMessage((String)string, (String)(string4 + "/"), (String)"${frameworkDir}/")).equals(string6)) {
                                string = string6.equals(string4) ? "${frameworkDir}/" : string5;
                            }
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug("Cannot convert ${frameworks} or ${frameworksDir}. Home url is " + string2);
                }
            }
        }
        return string;
    }

    private static String expandFrameworkOnly(String string, _c _c2, String string2, URL uRL, boolean bl) {
        String string3 = uRL.toString();
        if (_c2 == _c.d) {
            string3 = EditorVariables.makeURLRelative2Frameworks(string3);
        }
        String string4 = "${framework}";
        if (bl) {
            string4 = "${baseFramework}";
        }
        string = EditorVariables.slashifyIfNeeded(string, string4);
        string = Formatter.formatMessage((String)string, (String)string4, (String)string3);
        string4 = "${frameworkDir}";
        if (bl) {
            string4 = "${baseFrameworkDir}";
        }
        string = EditorVariables.slashifyIfNeeded(string, string4);
        String string5 = string2;
        if (_c2 == _c.d) {
            string5 = EditorVariables.makeFileRelative2Frameworks(string5);
        }
        string = Formatter.formatMessage((String)string, (String)string4, (String)string5);
        return string;
    }

    public static String makeURLRelative2Framework(String string, String string2) {
        if (string != null && string2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.startsWith(string3)) {
                stringBuilder.append("${framework}");
                stringBuilder.append("/");
                stringBuilder.append(string.substring(string3.length()));
                string = stringBuilder.toString();
            } else {
                try {
                    URL uRL = new URL(string2);
                    File file = URLUtil.getAbsoluteFileFromFileUrl((URL)uRL).getParentFile();
                    File file2 = file.getParentFile().getCanonicalFile();
                    String string4 = URLUtil.correct((File)file2).toExternalForm();
                    if (string.startsWith(string4) && (string.length() == string4.length() || string4.endsWith("/") || string.charAt(string4.length()) == '\\' || string.charAt(string4.length()) == '/')) {
                        stringBuilder.append("${frameworks}");
                        if (string4.endsWith("/")) {
                            stringBuilder.append("/");
                        }
                        stringBuilder.append(string.substring(string4.length()));
                        string = stringBuilder.toString();
                    }
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, (Throwable)iOException);
                }
            }
        }
        return string;
    }

    public static String makeURLRelative2Project(String string, String string2) {
        if (string != null && string2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.startsWith(string3)) {
                stringBuilder.append("${pdu}");
                stringBuilder.append("/");
                stringBuilder.append(string.substring(string3.length()));
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    public static String makeFileRelative2Framework(String string, String string2) {
        if (string != null && string2 != null) {
            try {
                String string3 = new File(string2).getParentFile().getCanonicalPath().replace('\\', '/');
                Object object = new File(string).getCanonicalPath().replace('\\', '/');
                if (string2.endsWith("/") || string2.endsWith("\\")) {
                    object = (String)object + "/";
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (EditorVariables.isAncestorOrSame((String)object, string3)) {
                    stringBuilder.append("${frameworkDir}");
                    stringBuilder.append(((String)object).substring(string3.length()));
                    string = stringBuilder.toString();
                } else {
                    String string4 = new File(string3).getParentFile().getCanonicalPath().replace('\\', '/');
                    if (EditorVariables.isAncestorOrSame((String)object, string4)) {
                        stringBuilder.append("${frameworksDir}");
                        stringBuilder.append(((String)object).substring(string4.length()));
                        string = stringBuilder.toString();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String makeFileRelative2Project(String string, String string2) {
        if (string != null && string2 != null) {
            try {
                String string3 = new File(string2).getParentFile().getCanonicalPath().replace('\\', '/');
                String string4 = new File(string).getCanonicalPath().replace('\\', '/');
                StringBuilder stringBuilder = new StringBuilder();
                if (string4 != null && EditorVariables.isAncestorOrSame(string4, string3)) {
                    stringBuilder.append("${pd}");
                    stringBuilder.append(string4.substring(string3.length()));
                    string = stringBuilder.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void setXpathEvaluator(k k2) {
        StaticComponentsRegistry.register((String)"STATIC_XPATH_EVALUATOR", (Object)k2);
    }

    public static k getXpathEvaluator() {
        return (k)StaticComponentsRegistry.get((String)"STATIC_XPATH_EVALUATOR");
    }

    public static void addCustomEditorVariablesResolver(EditorVariablesResolver editorVariablesResolver) {
        customResolvers.add(editorVariablesResolver);
    }

    public static void removeCustomEditorVariablesResolver(EditorVariablesResolver editorVariablesResolver) {
        customResolvers.remove(editorVariablesResolver);
    }

    public static List<EditorVariableDescription> getAllCustomResolvedEditorVariables() {
        ArrayList<EditorVariableDescription> arrayList = null;
        for (int i2 = 0; i2 < customResolvers.size(); ++i2) {
            List<EditorVariableDescription> list;
            EditorVariablesResolver editorVariablesResolver = customResolvers.get(i2);
            if (editorVariablesResolver == null || (list = editorVariablesResolver.getCustomResolverEditorVariableDescriptions()) == null || list.isEmpty()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<EditorVariableDescription>();
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static void setAdditionalFrameworksProvider(me me2) {
        additionalFrameworksProvider = me2;
    }

    public static void setUserUploadedFrameworks(File file) {
        userUploadedFrameworksDir = file;
    }

    public static void setCatalogUtilsAccess(ro.sync.util.editorvars.m m2) {
        catalogUtilsAccess = m2;
    }

    public static ro.sync.util.editorvars.m getCatalogUtilsAccess() {
        return catalogUtilsAccess;
    }

    public static synchronized String generateUniqueID() {
        return h.c();
    }

    public static boolean isRelativizedToProject(String string) {
        return string != null && string.startsWith("${pdu}");
    }

    static {
        EditorVariables.setArchiveExtensionsRecognizer(null);
        EditorVariables.setXpathEvaluator(null);
        EditorVariables.setFrameworkLocationResolver(null);
        EditorVariables.setPluginLocationResolver(null);
        EditorVariables.setRootMapResolver(null);
        customResolvers = new ArrayList<EditorVariablesResolver>();
        frameworksURLForTests = null;
        frameworksDirInitializing = new ThreadLocal();
        DEFAULT_FRAMEWORK_URL = null;
        frameworksDirForTests = null;
        cachedCustomFrameworksDir = null;
        isLoadedFromOptions = false;
        lastFrameworksURL = null;
        lastFrameworksDir = null;
    }

    private static final class _b
    implements EditorVariableResolver {
        private String g;
        private String f;
        private String c = null;
        private String d = null;
        private String e = null;
        private String b = null;
        boolean h = false;

        public _b(String string, String string2) {
            this.g = string;
            this.f = string2;
        }

        public String resolve(EditorVariable editorVariable) throws OperationCancelledException {
            String string;
            block12: {
                this.b();
                string = null;
                if (EditorVariablesBase.getName("${cfdu}").equals(editorVariable.getName())) {
                    string = this.c;
                } else if (EditorVariablesBase.getName("${cfd}").equals(editorVariable.getName())) {
                    string = this.b != null ? this.b : EditorVariableUtil.serialize((EditorVariable)editorVariable);
                } else if (EditorVariablesBase.getName("${cfn}").equals(editorVariable.getName())) {
                    string = this.d;
                } else if (EditorVariablesBase.getName("${cfne}").equals(editorVariable.getName())) {
                    string = this.e;
                } else if (EditorVariablesBase.getName("${cf}").equals(editorVariable.getName())) {
                    try {
                        File file = URLUtil.getCanonicalFileFromFileUrl((URL)new URL(this.g));
                        if (file != null) {
                            string = file.getAbsolutePath();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        string = EditorVariableUtil.serialize((EditorVariable)editorVariable);
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug("Current file could not be calculated: " + malformedURLException, (Throwable)malformedURLException);
                    }
                }
            }
            return string;
        }

        private void b() {
            if (!this.h) {
                int n2;
                Object object;
                Object object2;
                this.h = true;
                boolean bl = false;
                try {
                    object2 = new URL(this.g);
                    bl = ((URL)object2).getProtocol().equals("jar");
                    object = URLUtil.extractPathAndFileName((URL)object2);
                    if (object != null) {
                        this.c = object[0];
                        if (this.c != null && this.c.endsWith("/") && !bl) {
                            this.c = this.c.substring(0, this.c.length() - 1);
                        }
                        this.d = URLUtil.uncorrect((String)object[1]);
                        if (this.d != null) {
                            this.e = this.d;
                            n2 = this.d.lastIndexOf(46);
                            if (n2 != -1) {
                                this.d = this.d.substring(0, n2);
                            }
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    logger.warn((Object)malformedURLException, (Throwable)malformedURLException);
                }
                if (this.c == null || this.d == null) {
                    int n3;
                    object2 = this.g;
                    if (((String)object2).startsWith("/")) {
                        object2 = ((String)object2).substring(1);
                    }
                    if ((n3 = ((String)object2).lastIndexOf(47)) != -1) {
                        if (this.c == null) {
                            this.c = ((String)object2).substring(0, n3);
                        }
                        if (this.d == null) {
                            this.e = this.d = URLUtil.uncorrect((String)((String)object2).substring(n3 + 1));
                            n2 = ((String)object2).lastIndexOf(46);
                            if (n2 != -1 && n2 >= n3 + 1) {
                                this.d = ((String)object2).substring(n3 + 1, n2);
                            }
                        }
                    }
                }
                try {
                    object2 = null;
                    if (this.c != null) {
                        this.c = URLUtil.correct((String)this.c, (boolean)false);
                        object2 = new URL(this.c);
                    }
                    if (object2 != null) {
                        if ("file".equals(((URL)object2).getProtocol())) {
                            boolean bl2 = false;
                            String string = ((URL)object2).toString();
                            if (PlatformDetector.isWin() && string.endsWith(":")) {
                                object2 = new URL(string + "/");
                                bl2 = true;
                            }
                            this.b = URLUtil.getCanonicalFileFromFileUrl((URL)object2).getAbsolutePath();
                            if (bl2 && this.b.endsWith("\\") && !this.f.endsWith("${cfd}")) {
                                this.b = this.b.substring(0, this.b.length() - 1);
                            }
                        } else {
                            object = TemporaryFilesFactory.getOxygenTempDirectory();
                            File file = new File((File)object, FileSystemUtil.proposeValidFileName((String)this.c));
                            this.b = file.getAbsolutePath();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    logger.error("Error when expand " + this.c + " - " + malformedURLException, (Throwable)malformedURLException);
                }
            }
        }
    }

    public static final class _c
    extends Enum<_c> {
        public static final /* enum */ _c e = new _c();
        public static final /* enum */ _c d = new _c();
        public static final /* enum */ _c h = new _c();
        public static final /* enum */ _c g = new _c();
        public static final /* enum */ _c c = new _c();
        public static final /* enum */ _c f = new _c();
        private static final /* synthetic */ _c[] b;

        public static _c[] values() {
            return (_c[])b.clone();
        }

        public static _c valueOf(String string) {
            return Enum.valueOf(_c.class, string);
        }

        private static /* synthetic */ _c[] b() {
            return new _c[]{e, d, h, g, c, f};
        }

        static {
            b = _c.b();
        }
    }

    public static interface _d {
        public String b(String var1);
    }
}

