/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.auth.Credentials;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.BreakableOutputStream;
import ro.sync.basic.net.http.HttpException;
import ro.sync.basic.util.EmptyInputStream;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.plugin.RedirectFollowingURLConnection;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.b.b;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;
import ro.sync.net.protocol.http.abstraction.b;
import ro.sync.net.protocol.http.abstraction.f;
import ro.sync.net.protocol.http.abstraction.g;
import ro.sync.net.protocol.http.abstraction.h;
import ro.sync.net.protocol.http.abstraction.i;
import ro.sync.net.protocol.http.abstraction.k;
import ro.sync.net.protocol.http.c;
import ro.sync.net.protocol.http.d;
import ro.sync.net.protocol.http.l;
import ro.sync.net.protocol.http.p;
import ro.sync.net.protocol.http.r;
import ro.sync.net.protocol.http.t;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class WebdavHttpURLConnection
extends HttpURLConnection
implements t,
FileBrowsingConnection,
RedirectFollowingURLConnection {
    private static final String i = "GET";
    private static final Logger p = LoggerFactory.getLogger((String)WebdavHttpURLConnection.class.getName());
    private final h q;
    private final String o;
    private _c k;
    private final List<String> m = new ArrayList<String>(3);
    private final List<String> l = new ArrayList<String>(3);
    private i h = ro.sync.net.protocol.http.abstraction.i.c;
    private InputStream g;
    private g j;
    private ro.sync.net.protocol.http.b f = new ro.sync.net.protocol.http.b();
    private Exception n;

    public WebdavHttpURLConnection(URL uRL) {
        this(uRL, "HTTP_DEFAULT_SESSION_ID");
    }

    public WebdavHttpURLConnection(URL uRL, String string) {
        super(uRL);
        if (p.isDebugEnabled()) {
            this.n = new Exception();
        }
        this.o = string;
        if (p.isDebugEnabled()) {
            p.debug("Construct a connection to " + URLUtil.filterPasswords((String)String.valueOf(uRL)));
        }
        this.q = this.createHttpClientSettings();
        c c2 = r.d().e();
        if (c2 != null) {
            this.setReadTimeout(c2.c());
            this.setConnectTimeout(c2.c());
        } else {
            this.setReadTimeout(d.e());
            this.setConnectTimeout(d.e());
        }
    }

    protected h createHttpClientSettings() {
        return ro.sync.net.protocol.http.abstraction.k.d(this.o).b();
    }

    @Override
    public void setReadTimeout(int n2) {
        super.setReadTimeout(n2);
        this.q.k(n2);
    }

    @Override
    public void setConnectTimeout(int n2) {
        super.setConnectTimeout(n2);
        this.q.d(n2);
    }

    @Override
    public void connect() throws IOException {
        if (p.isDebugEnabled()) {
            p.debug("WebDav connection to: " + URLUtil.filterPasswords((String)String.valueOf(this.url)));
        }
        this.connected = true;
        if ("HEAD".equals(this.method) || "DELETE".equals(this.method)) {
            this.i();
        }
    }

    private void i() throws IOException {
        if (this.j == null) {
            if (!this.connected) {
                this.connect();
            }
            if (this.j == null) {
                if ("HEAD".equals(this.method)) {
                    this.obtainResponse(ro.sync.net.protocol.http.abstraction.i.h);
                } else if ("DELETE".equals(this.method)) {
                    this.obtainResponse(ro.sync.net.protocol.http.abstraction.i.i);
                } else {
                    ro.sync.net.protocol.b.b b2 = ro.sync.net.protocol.b.c.d();
                    if (b2 != null) {
                        b2.b(this.url);
                    }
                    this.getInputStream();
                }
            }
        }
    }

    @Override
    public String getHeaderField(String string) {
        if (p.isDebugEnabled()) {
            p.debug("getHeaderField: " + string);
        }
        try {
            this.i();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = null;
        if (this.j != null) {
            g._b _b2;
            if (p.isDebugEnabled()) {
                p.debug("executedMethod to get field: " + string);
            }
            if ((_b2 = this.j.h(string)) != null) {
                string2 = _b2.b();
                if (p.isDebugEnabled()) {
                    p.debug("executedMethod non null field: " + string2);
                }
            }
        }
        if (p.isDebugEnabled()) {
            p.debug("getHeaderField value is: " + string2);
        }
        return string2;
    }

    @Override
    public String getHeaderField(int n2) {
        try {
            this.i();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        if (this.j != null) {
            g._b[] _bArray = this.j.f();
            if (n2 == 0) {
                string = this.j.b();
            } else if (n2 - 1 < _bArray.length) {
                string = _bArray[n2 - 1].b();
            }
        }
        if (p.isDebugEnabled()) {
            p.debug("H Idx: " + n2 + " v: " + string);
        }
        return string;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        try {
            this.i();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        if (this.j != null) {
            g._b[] _bArray = this.j.f();
            if (n2 == 0) {
                string = "Status";
            } else if (n2 - 1 < _bArray.length) {
                string = _bArray[n2 - 1].c();
            }
        }
        if (p.isDebugEnabled()) {
            p.debug("H Idx: " + n2 + " n: " + string);
        }
        return string;
    }

    @Override
    public InputStream getErrorStream() {
        String string;
        HttpExceptionWithDetails httpExceptionWithDetails = null;
        if (this.f.c() instanceof HttpExceptionWithDetails) {
            httpExceptionWithDetails = (HttpExceptionWithDetails)((Object)this.f.c());
        } else if (this.f.f() instanceof HttpExceptionWithDetails) {
            httpExceptionWithDetails = (HttpExceptionWithDetails)((Object)this.f.f());
        }
        if (httpExceptionWithDetails != null && (string = httpExceptionWithDetails.getReason()) != null) {
            return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        }
        return super.getErrorStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object object;
        Object object2;
        ro.sync.net.protocol.b.b b2;
        StringBuilder stringBuilder = d.c();
        if (stringBuilder != null) {
            stringBuilder.append("GET INPUT STREAM " + this.url).append("\n");
        }
        if (this.f.c() != null) {
            throw this.f.c();
        }
        if (this.getDoOutput() && this.k != null && !this.k.c()) {
            this.k.close();
        }
        this.f();
        ro.sync.net.protocol.b.b b3 = b2 = i.equals(this.method) ? ro.sync.net.protocol.b.c.d() : null;
        if (b2 != null && this.g == null && (object2 = b2.d(this.url, this.m, this.l)) != null && (object = ((b._c)object2).d()) != null) {
            this.g = object;
            if (((b._c)object2).c() != null) {
                this.url = ((b._c)object2).c();
            }
        }
        if (this.g == null) {
            try {
                ro.sync.net.protocol.b.b b4;
                if (!this.connected) {
                    this.connect();
                }
                if ("HEAD".equals(this.method) || "DELETE".equals(this.method)) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                object2 = this.url;
                this.obtainResponse(this.h == ro.sync.net.protocol.http.abstraction.i.j ? ro.sync.net.protocol.http.abstraction.i.j : ro.sync.net.protocol.http.abstraction.i.m);
                try {
                    object = this.j.d();
                    if (object != null) {
                        this.url = ((URI)object).toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    p.warn((Object)malformedURLException, (Throwable)malformedURLException);
                }
                this.g = this.j.c();
                if (this.g == null) {
                    this.g = EmptyInputStream.INSTANCE;
                }
                if ((object = super.getContentEncoding()) != null && ((String)object).toLowerCase().equals("gzip")) {
                    this.g = new GZIPInputStream(this.g);
                }
                this.g = new _b(this.g, this.getReferenceToConnection());
                ro.sync.net.protocol.b.b b5 = b4 = i.equals(this.method) ? ro.sync.net.protocol.b.c.d() : null;
                if (b4 != null) {
                    this.g = b4.e((URL)object2, this.url, this.g, this.m, this.l);
                }
            }
            catch (IOException iOException) {
                this.f.d(iOException);
                throw iOException;
            }
        }
        return this.g;
    }

    protected void obtainResponse(i i2) throws IOException {
        if (p.isDebugEnabled()) {
            p.debug("Get Input Stream for :" + URLUtil.filterPasswords((String)String.valueOf(this.url)));
        }
        this.f();
        this.q.j(this.instanceFollowRedirects);
        this.j = ro.sync.net.protocol.http.abstraction.k.d(this.o).e(this.q, i2, this.url, null, null, true, this.m, this.l);
    }

    private void f() {
        if (!WebdavHttpURLConnection.b(this.m, "Accept")) {
            this.setRequestProperty("Accept", "application/xml,*/*");
        }
        if (!WebdavHttpURLConnection.b(this.m, "Accept-Encoding")) {
            this.setRequestProperty("Accept-Encoding", "gzip");
        }
    }

    @Override
    public String getContentEncoding() {
        String string = super.getContentEncoding();
        if (string != null && string.toLowerCase().equals("gzip")) {
            string = null;
        }
        return string;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.k == null) {
            this.k = new _c();
        }
        return this.k;
    }

    @Override
    public void disconnect() {
        if (this.j != null) {
            p.debug("Disconnecting");
            this.f.e(this.j.g());
            this.f.g(String.valueOf(this.j.b()));
            this.j.e();
            if (this.q != null && this.q instanceof b) {
                try {
                    ((b)this.q).close();
                }
                catch (IOException iOException) {
                    p.error((Object)iOException, (Throwable)iOException);
                }
            }
            this.j = null;
        }
        this.c();
    }

    private void c() {
        if (this.k != null) {
            try {
                this.k.b();
            }
            catch (IOException iOException) {
                p.warn("Webdav output stream could not be disposed correctly", (Throwable)iOException);
            }
        }
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void setRequestMethod(String string) throws ProtocolException {
        if ("PROPFIND".equals(string)) {
            this.h = ro.sync.net.protocol.http.abstraction.i.l;
        } else {
            if ("POST".equals(string)) {
                this.h = ro.sync.net.protocol.http.abstraction.i.j;
            }
            super.setRequestMethod(string);
        }
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.m.add(string);
        this.l.add(string2);
    }

    @Override
    public String getRequestProperty(String string) {
        String string2 = null;
        for (int i2 = 0; i2 < this.m.size(); ++i2) {
            if (!this.m.get(i2).equals(string)) continue;
            string2 = this.l.get(i2);
        }
        return string2;
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i2 = 0; i2 < this.m.size(); ++i2) {
            String string2 = this.m.get(i2);
            List list = hashMap.computeIfAbsent(string2, string -> new ArrayList());
            list.add(this.l.get(i2));
        }
        return hashMap;
    }

    @Override
    public int getResponseCode() throws IOException {
        int n2;
        block5: {
            n2 = -1;
            try {
                this.i();
            }
            catch (HttpException httpException) {
                n2 = httpException.getReasonCode();
                if (n2 != -1) break block5;
                throw httpException;
            }
        }
        if (this.j != null) {
            n2 = this.j.g();
        } else if (n2 == -1) {
            n2 = this.f.h();
        }
        return n2;
    }

    @Override
    public String getResponseMessage() throws IOException {
        String string;
        block5: {
            string = null;
            try {
                this.i();
            }
            catch (HttpException httpException) {
                string = httpException.getReason();
                if (string == null || !string.isEmpty()) break block5;
                string = ro.sync.net.protocol.http.abstraction.c.c.b(httpException.getReasonCode());
            }
        }
        if (this.j != null) {
            string = String.valueOf(this.j.b());
        } else if (string == null) {
            string = this.f.i();
        }
        return string;
    }

    public void finalize() throws Throwable {
        if (this.j != null) {
            if (this.n != null) {
                p.warn("Connection to {} closed by Garbage Collector. Object construction stacktrace: {}", (Object)this.url, (Object)this.n);
            } else {
                p.warn("Connection to {} closed by Garbage Collector.", (Object)this.url);
            }
        }
        this.disconnect();
    }

    private static boolean b(List<String> list, String string) {
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = list.get(i2);
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDoOutput(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        new Exception().printStackTrace(printStream);
        try {
            String string = byteArrayOutputStream.toString("UTF8").toLowerCase();
            if (string.indexOf("org.apache.xmlrpc") != -1 || string.indexOf("printservice") != -1 && string.indexOf("sun.print") != -1) {
                p.debug("Do output called. From XMLRPC or Unix Printing probably.");
                this.h = ro.sync.net.protocol.http.abstraction.i.j;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            p.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
        }
        super.setDoOutput(bl);
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.m.add(string);
        this.l.add(string2);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        Object object;
        try {
            this.i();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        g._b[] _bArray = null;
        if (this.j != null) {
            _bArray = this.j.f();
        } else if (this.f.c() instanceof HttpExceptionWithDetails) {
            object = (HttpExceptionWithDetails)((Object)this.f.c());
            g g2 = ((HttpExceptionWithDetails)((Object)object)).getHttpResponse();
            _bArray = g2.f();
        }
        object = new HashMap();
        if (_bArray != null) {
            for (g._b _b2 : _bArray) {
                String string2 = _b2.c();
                String string3 = _b2.b();
                if (string3 == null) continue;
                object.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
            }
        }
        return object;
    }

    @Override
    public List<String> getHeaderKeys() {
        return this.m;
    }

    @Override
    public List<String> getHeaderValues() {
        return this.l;
    }

    @Override
    public void removeResource() throws IOException {
        this.connect();
        IOException iOException = null;
        g g2 = null;
        try {
            g2 = ro.sync.net.protocol.http.abstraction.k.d(this.o).e(this.q, ro.sync.net.protocol.http.abstraction.i.i, this.url, null, null, true, this.getHeaderKeys(), this.getHeaderValues());
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (g2 != null) {
            g2.e();
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public h getHTTPClientSettings() {
        return this.q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FolderEntryDescriptor> listFolder() throws IOException {
        f f2;
        try {
            f2 = (f)ro.sync.net.protocol.http.abstraction.k.d(this.o).e(this.q, ro.sync.net.protocol.http.abstraction.i.l, this.url, null, null, false, this.getHeaderKeys(), this.getHeaderValues());
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("401 Unauthorized")) {
                throw new UserActionRequiredException(new WebappMessage(3, "Authentication required", this.url.toExternalForm(), true));
            }
            throw iOException;
        }
        try {
            int n2;
            Enumeration<String> enumeration = f2.r();
            ArrayList<FolderEntryDescriptor> arrayList = new ArrayList<FolderEntryDescriptor>();
            while (enumeration.hasMoreElements()) {
                arrayList.add(new FolderEntryDescriptor(enumeration.nextElement()));
            }
            int n3 = 0;
            FolderEntryDescriptor folderEntryDescriptor = null;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                FolderEntryDescriptor folderEntryDescriptor2 = (FolderEntryDescriptor)arrayList.get(n2);
                String string = folderEntryDescriptor2.getAbsolutePath();
                if (!string.endsWith("/") || (folderEntryDescriptor == null || string.length() >= folderEntryDescriptor.getAbsolutePath().length()) && folderEntryDescriptor != null) continue;
                n3 = n2;
                folderEntryDescriptor = folderEntryDescriptor2;
            }
            if (folderEntryDescriptor != null) {
                n2 = 1;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (((FolderEntryDescriptor)arrayList.get(i2)).getAbsolutePath().startsWith(folderEntryDescriptor.getAbsolutePath())) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) {
                    arrayList.remove(n3);
                }
            }
            ArrayList<FolderEntryDescriptor> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            f2.e();
        }
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.q.c(sSLSocketFactory);
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.q.m();
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.q.b(hostnameVerifier);
    }

    public HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = this.q.e();
        return hostnameVerifier != null ? hostnameVerifier : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    }

    public Principal getLocalPrincipal() {
        Credentials credentials = ro.sync.net.protocol.http.b.f.p(this.getURL());
        if (credentials != null) {
            return credentials.getUserPrincipal();
        }
        return null;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        p.error("This method is not implemented, see EXM-46376", (Throwable)new Exception());
        return null;
    }

    public String getCipherSuite() {
        p.error("This method is not implemented, see EXM-46376", (Throwable)new Exception());
        return null;
    }

    public Certificate[] getLocalCertificates() {
        p.error("This method is not implemented, see EXM-46376", (Throwable)new Exception());
        return new Certificate[0];
    }

    public Certificate[] getServerCertificates() {
        p.error("This method is not implemented, see EXM-46376", (Throwable)new Exception());
        return new Certificate[0];
    }

    protected HttpURLConnection getReferenceToConnection() {
        return this;
    }

    private class _c
    extends BreakableOutputStream {
        private static final String e = "application/x-www-form-urlencoded";
        private static final String c = "Content-Type";
        private volatile boolean d;

        protected boolean c() {
            return !this.d;
        }

        public _c() {
            super((OutputStream)new l());
            this.d = true;
        }

        public void close() throws IOException {
            p.debug("Close WebdavOutstream");
            if (!this.d) {
                return;
            }
            this.d = false;
            try {
                p p2;
                if (p.isDebugEnabled()) {
                    p.debug("Start PUT/POST for: " + URLUtil.filterPasswords((String)String.valueOf(WebdavHttpURLConnection.this.url)) + ". Method to use instead of PUT is: " + WebdavHttpURLConnection.this.h);
                    p.debug("headers:" + WebdavHttpURLConnection.this.m + " " + WebdavHttpURLConnection.this.l);
                }
                if ((p2 = ((l)this.out).c()).b() > 0) {
                    this.d();
                }
                WebdavHttpURLConnection.this.q.j(WebdavHttpURLConnection.this.instanceFollowRedirects);
                WebdavHttpURLConnection.this.j = ro.sync.net.protocol.http.abstraction.k.d(WebdavHttpURLConnection.this.o).e(WebdavHttpURLConnection.this.q, WebdavHttpURLConnection.this.h, WebdavHttpURLConnection.this.url, p2, null, true, WebdavHttpURLConnection.this.m, WebdavHttpURLConnection.this.l);
                InputStream inputStream = WebdavHttpURLConnection.this.j.c();
                if (inputStream == null) {
                    inputStream = EmptyInputStream.INSTANCE;
                }
                WebdavHttpURLConnection.this.g = new _b(inputStream, WebdavHttpURLConnection.this.getReferenceToConnection());
                if (p.isDebugEnabled()) {
                    p.debug("End PUT/POST for: " + URLUtil.filterPasswords((String)String.valueOf(WebdavHttpURLConnection.this.url)));
                }
            }
            catch (IOException iOException) {
                if (p.isDebugEnabled()) {
                    p.debug((Object)iOException, (Throwable)iOException);
                }
                this.setPreviousOperationFailed(iOException);
                WebdavHttpURLConnection.this.f.b(iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                if (p.isDebugEnabled()) {
                    p.debug((Object)throwable, throwable);
                }
                this.setPreviousOperationFailed(new IOException(throwable.getMessage(), throwable));
            }
            finally {
                super.close();
            }
        }

        private void d() {
            if (WebdavHttpURLConnection.this.h == ro.sync.net.protocol.http.abstraction.i.j && !WebdavHttpURLConnection.b(WebdavHttpURLConnection.this.m, c)) {
                if (p.isDebugEnabled()) {
                    p.debug("Automatically setting the Content-Type to application/x-www-form-urlencoded");
                }
                WebdavHttpURLConnection.this.m.add(c);
                WebdavHttpURLConnection.this.l.add(e);
            }
        }

        public void b() throws IOException {
            ((l)this.out).b();
        }
    }

    private static class _b
    extends FilterInputStream {
        private final HttpURLConnection b;

        public _b(InputStream inputStream, HttpURLConnection httpURLConnection) {
            super(inputStream);
            this.b = httpURLConnection;
        }

        public String toString() {
            return super.toString() + " created from " + this.b;
        }

        @Override
        public void close() throws IOException {
            try {
                try {
                    super.close();
                }
                catch (ConnectionClosedException connectionClosedException) {
                    p.error((Object)connectionClosedException, (Throwable)connectionClosedException);
                }
            }
            finally {
                this.b.disconnect();
            }
        }
    }
}

