/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.io.b.b;
import ro.sync.io.b.c;
import ro.sync.io.b.d;
import ro.sync.security.Sandbox;
import ro.sync.util.h;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class TemporaryFilesFactory {
    private static final Logger b = LoggerFactory.getLogger((String)TemporaryFilesFactory.class.getName());
    private static Random c;

    public static File createTempFile(final String string, final String string2, final File file) throws IOException {
        try {
            return (File)Sandbox.runWithPerms((long)515L, (PrivilegedExceptionAction)new PrivilegedExceptionAction<File>(){

                public File b() throws Exception {
                    return TemporaryFilesFactory.c(string, string2, file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            throw new IOException(privilegedActionException.getMessage(), privilegedActionException.getException());
        }
    }

    public static File getOxygenTempDirectory() {
        return FileSystemUtil.getOxygenTempDirectory();
    }

    public static File newTempDir(String string, String string2) throws IOException {
        if (!TemporaryFilesFactory.isConfidentialNonEncryptedTempFileCreationAllowed()) {
            throw new IOException("Temporary directory creation disabled for security reasons.");
        }
        String string3 = string = string == null ? "" : string;
        if (string2 == null) {
            string2 = h.c();
        }
        string2 = string.concat(String.valueOf(string2));
        File file = TemporaryFilesFactory.getOxygenTempDirectory();
        File file2 = new File(file, string2);
        return file2;
    }

    public static File createNonConfidentialTempFile(String string, String string2, File file) throws IOException {
        File file2;
        File file3 = file;
        if (file3 == null && ((file2 = TemporaryFilesFactory.getOxygenTempDirectory()).exists() || file2.mkdir())) {
            file3 = file2;
        }
        return File.createTempFile("oxy_unsafe_" + string, string2, file3);
    }

    public static File createTempDir(String string, String string2) throws IOException {
        if (!TemporaryFilesFactory.isConfidentialNonEncryptedTempFileCreationAllowed()) {
            throw new IOException("Temporary directory creation disabled for security reasons.");
        }
        File file = TemporaryFilesFactory.newTempDir(string, string2);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create temporary folder: " + file);
        }
        return file;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return TemporaryFilesFactory.createTempFile(string, string2, null);
    }

    public static void storeConfidentialFilesAsEncrypted() {
        StaticComponentsRegistry.register((String)"CONFIDENTIAL_FILES_ENCRYPTION_DISABLED", (Object)false);
    }

    public static void setStreamEncryptionProvider(StreamEncryptionProvider streamEncryptionProvider) {
        StaticComponentsRegistry.register((String)"STREAM_ENCRYPTION_PROVIDER", (Object)streamEncryptionProvider);
    }

    public static boolean isConfidentialNonEncryptedTempFileCreationAllowed() {
        return (Boolean)StaticComponentsRegistry.get((String)"CONFIDENTIAL_FILES_ENCRYPTION_DISABLED");
    }

    public static c createConfidentialTempFile(String string, String string2) throws IOException, _b {
        if (TemporaryFilesFactory.isConfidentialNonEncryptedTempFileCreationAllowed()) {
            File file = TemporaryFilesFactory.createTempFile(string, string2);
            return new b(file);
        }
        StreamEncryptionProvider streamEncryptionProvider = (StreamEncryptionProvider)StaticComponentsRegistry.get((String)"STREAM_ENCRYPTION_PROVIDER");
        if (streamEncryptionProvider == null) {
            throw new _b();
        }
        File file = TemporaryFilesFactory.b(string, string2);
        return new d(file, streamEncryptionProvider);
    }

    private static File b(String string, String string2) throws IOException {
        File file = TemporaryFilesFactory.getOxygenTempDirectory();
        if (!file.exists() && !file.mkdir()) {
            throw new IllegalStateException("Temporary folder " + file + " does not exist");
        }
        return File.createTempFile("oxy_" + string, string2, file);
    }

    private static File c(String string, String string2, File file) throws IOException {
        File file2;
        if (!TemporaryFilesFactory.isConfidentialNonEncryptedTempFileCreationAllowed()) {
            throw new IOException("Temporary file creation disabled for security reasons.");
        }
        File file3 = file;
        if (file3 == null && ((file2 = TemporaryFilesFactory.getOxygenTempDirectory()).exists() || file2.mkdir())) {
            file3 = file2;
        }
        return File.createTempFile("oxy_" + string, string2, file3);
    }

    public static File createTempFileWithFallbacks(String string, String string2) {
        File file = null;
        try {
            file = TemporaryFilesFactory.createTempFile(string, string2);
        }
        catch (IOException iOException) {
            b.error("Cannot create temporary file: " + iOException.getMessage(), (Throwable)iOException);
            try {
                file = TemporaryFilesFactory.createTempFile(string, string2, new File(System.getProperty("user.home")));
            }
            catch (IOException iOException2) {
                b.error("Cannot create temporary file in user home: " + iOException.getMessage(), (Throwable)iOException);
                file = new File(TemporaryFilesFactory.generateTemporaryFileName(string, string2));
            }
        }
        TemporaryFilesFactory.deleteOnExitOnDesktopApp(file);
        return file;
    }

    public static String generateTemporaryFileName(String string, String string2) {
        long l2;
        if (c == null) {
            c = new Random();
        }
        l2 = (l2 = c.nextLong()) == Long.MIN_VALUE ? 0L : Math.abs(l2);
        return string + Long.toString(l2) + string2;
    }

    public static void deleteOnExitOnDesktopApp(File file) {
        if (Boolean.TRUE.equals(StaticComponentsRegistry.get((String)"IS_WEBAUTHOR_COMPONENT"))) {
            b.warn("File.deleteOnExit was called on {}", (Object)file, (Object)new Exception());
        }
        file.deleteOnExit();
    }

    static {
        StaticComponentsRegistry.register((String)"CONFIDENTIAL_FILES_ENCRYPTION_DISABLED", (Object)true);
        c = null;
    }

    @SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
    public static interface StreamEncryptionProvider {
        public InputStream decrypt(InputStream var1) throws IOException;

        public OutputStream encrypt(OutputStream var1) throws IOException;
    }

    public static class _b
    extends Exception {
    }
}

