/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.api.oauth.token;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.api.oauth.token.f;
import ro.sync.fsv.sharepoint.api.oauth.token.g;

@SkipObfuscate
@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthAccessToken {
    @JsonProperty(value="access_token")
    private String value;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="refresh_token")
    private f refreshToken;
    @JsonIgnore
    private int expiresIn;
    private String scope;
    private String jti;
    @JsonProperty(value="id_token")
    private g idToken;
    @JsonIgnore
    private long expirationTime;

    public OAuthAccessToken() {
    }

    public OAuthAccessToken(String string, long l2) {
        this.value = string;
        this.expirationTime = l2;
    }

    public String getValue() {
        return this.value;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public f getRefreshToken() {
        return this.refreshToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getJti() {
        return this.jti;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    @JsonProperty(value="expires_in")
    public void setExpiresIn(int n2) {
        this.expiresIn = n2;
        long l2 = System.currentTimeMillis();
        this.expirationTime = l2 + (long)(n2 * 1000);
    }

    public void setIdToken(g g2) {
        this.idToken = g2;
    }

    public g getIdToken() {
        return this.idToken;
    }

    @JsonIgnore
    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    public String toString() {
        return String.format("OAuthAccessToken [value=%s,\n tokenType=%s,\n refreshToken=%s,\n expiresIn=%s,\n scope=%s,\n jti=%s,\n idToken=%s,\n expirationTime=%s]", this.value, this.tokenType, this.refreshToken, this.expiresIn, this.scope, this.jti, this.idToken, this.expirationTime);
    }
}

