/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Crypto;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.cd;
import ro.sync.exml.editor.scenario.BaseScenarioImpl;
import ro.sync.exml.editor.xmleditor.transform.TransformationParameter;
import ro.sync.exml.editor.xmleditor.transform.advanced.AdvancedTransformerOptionsBase;
import ro.sync.exml.editor.xmleditor.transform.advanced.SaxonHEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XQuerySaxonEEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XQuerySaxonHEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XQuerySaxonPEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XSLTSaxonEEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XSLTSaxonHEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XSLTSaxonPEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.c.e;
import ro.sync.exml.editor.xmleditor.transform.c.g;
import ro.sync.exml.o.b;
import ro.sync.exml.options.Options;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.SerializableLinkedHashMap;
import ro.sync.options.SerializableList;
import ro.sync.util.db;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.xml.transformer.u;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Scenario
extends BaseScenarioImpl {
    public static final String DEFAULT_SCENARIO_NAME = "xml-stylesheet processing instruction";
    public static final String APACHE_FOP = "Apache FOP";
    public static final String PDF_CHEMISTRY = "Oxygen PDF Chemistry Processor";
    public static final String BUILTIN_OLD = "Built-in (Apache FOP)";
    public static final String METHOD_PDF = "pdf";
    public static final String METHOD_PS = "ps";
    public static final String METHOD_TXT = "txt";
    public static final String XSL_CONTEXT_XML_TRANSFORMER = "XML";
    public static final String XML_CONTEXT_XSL_TRANSFORMER = "XSL";
    public static final String JSON_CONTEXT_XSL_TRANSFORMER = "JSON/XSL";
    public static final String JSON_CONTEXT_XQUERY_TRANSFORMER = "JSON/XQERY";
    public static final String XSL_CONTEXT_JSON_TRANSFORMER = "XSL/JSON";
    public static final String XQUERY_CONTEXT_XML_TRANSFORMER = "XQUERY";
    public static final String XQUERY_CONTEXT_JSON_TRANSFORMER = "XQUERY/JSON";
    public static final String SQL_CONTEXT_SQL_TRANSFORMER = "SQL";
    public static final String XPROC_CONTEXT_XPROC_TRANSFORMER = "XPROC";
    public static final String XML_CONTEXT_DITA_OT_TRANSFORMER = "DITAMAP";
    public static final String XML_CONTEXT_ANT_TRANSFORMER = "ANT";
    public static final String XML_CONTEXT_XQUERY_TRANSFORMER = "XML_XQUERY";
    public static final String XML_CHEMISTRY_TRANSFORMER = "XML_CHEMISTRY";
    private static final String[] ALL_SCENARIO_TYPES = new String[]{"XSL", "XML_XQUERY", "XML_CHEMISTRY", "DITAMAP", "ANT", "JSON/XSL", "JSON/XQERY", "XML", "XSL/JSON", "XPROC", "XQUERY", "XQUERY/JSON", "SQL"};
    private static List<String> allScenarioTypes = null;
    private static final ImmutableMap<String, Integer> scenarioTypeToPriorityMap = Scenario.buildScenarioTypeToPriorityMap();
    SerializableLinkedHashMap<String, AdvancedTransformerOptionsBase> advancedOptionsMap;
    @PersistentObjectField(hasEditorVariables=false, isIDTypeVariables=true)
    private String name;
    @PersistentObjectField(hasEditorVariables=true)
    private String baseURL = "";
    @PersistentObjectField(hasEditorVariables=true)
    private String footerURL = "";
    @PersistentObjectField(hasEditorVariables=false)
    private String fOPMethod;
    @PersistentObjectField(hasEditorVariables=false)
    private String fOProcessorName;
    @PersistentObjectField(hasEditorVariables=true)
    private String headerURL = "";
    @PersistentObjectField(hasEditorVariables=true)
    private String inputXSLURL = "";
    @PersistentObjectField(hasEditorVariables=true)
    private String inputXMLURL = "";
    private boolean defaultScenario;
    private boolean isFOPPerforming;
    @PersistentObjectField(hasEditorVariables=false)
    private String type = "XSL";
    private boolean saveAs = true;
    private boolean openInBrowser;
    @PersistentObjectField(hasEditorVariables=true)
    private String outputResource;
    private boolean openOtherLocationInBrowser = false;
    @PersistentObjectField(hasEditorVariables=true)
    private String locationToOpenInBrowserURL = "";
    private boolean openInEditor;
    private boolean showInHTMLPane;
    private boolean showInXMLPane = true;
    private boolean showInSVGPane;
    private boolean showInResultSetPane = false;
    private boolean useXSLTInput = true;
    private SerializableList<TransformationParameter> xsltParams = new SerializableList();
    @PersistentObjectField(hasEditorVariables=true)
    private String[] cascadingStylesheets = new String[0];
    @PersistentObjectField(hasEditorVariables=false)
    private String xslTransformer = "Saxon6.5.5";
    @PersistentObjectField(hasEditorVariables=true)
    private String[] extensionURLs = new String[0];

    public static String[] getAllScenarioTypes() {
        if (allScenarioTypes == null) {
            allScenarioTypes = new ArrayList<String>();
            for (String string : ALL_SCENARIO_TYPES) {
                if (!cd.h().validateScenario(string)) continue;
                allScenarioTypes.add(string);
            }
        }
        return allScenarioTypes.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.id = null;
    }

    public Scenario() {
    }

    public Scenario(String string) {
        this.setName(string);
    }

    @Override
    protected int compareTypeTo(String string) {
        Integer n2 = (Integer)scenarioTypeToPriorityMap.get((Object)this.type);
        Integer n3 = (Integer)scenarioTypeToPriorityMap.get((Object)string);
        if (n2 == null) {
            n2 = -1;
        }
        if (n3 == null) {
            n3 = -1;
        }
        return n2 - n3;
    }

    @Override
    public Object clone() {
        Scenario scenario = (Scenario)super.clone();
        if (scenario != null) {
            if (this.xsltParams != null) {
                scenario.xsltParams = (SerializableList)this.xsltParams.clone();
            }
            if (this.cascadingStylesheets != null) {
                scenario.cascadingStylesheets = (String[])this.cascadingStylesheets.clone();
            }
            if (this.extensionURLs != null) {
                scenario.extensionURLs = (String[])this.extensionURLs.clone();
            }
            if (this.advancedOptionsMap != null) {
                scenario.advancedOptionsMap = (SerializableLinkedHashMap)this.advancedOptionsMap.clone();
            }
        }
        return scenario;
    }

    private boolean verifyEquals(String string, String string2) {
        if (string == null || string2 == null) {
            return Equaler.verifyEquals((Object)string, (Object)string2);
        }
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(string2);
            return Equaler.verifyEquals((Object)URLUtil.clearUserInfo((URL)uRL).toString(), (Object)URLUtil.clearUserInfo((URL)uRL2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            return Equaler.verifyEquals((Object)string, (Object)string2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Scenario)) {
            return false;
        }
        Scenario scenario = (Scenario)object;
        if (scenario.getStorage() != this.getStorage()) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.getId(), (Object)this.getId())) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.type, (Object)this.type)) {
            return false;
        }
        if (!this.verifyEquals(scenario.baseURL, this.baseURL)) {
            return false;
        }
        if (!this.verifyEquals(scenario.inputXSLURL, this.inputXSLURL)) {
            return false;
        }
        if (!this.verifyEquals(scenario.inputXMLURL, this.inputXMLURL)) {
            return false;
        }
        if (scenario.defaultScenario != this.defaultScenario) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.fOPMethod, (Object)this.fOPMethod)) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.fOProcessorName, (Object)this.fOProcessorName)) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.outputResource, (Object)this.outputResource)) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.xsltParams, this.xsltParams)) {
            return false;
        }
        if (!Equaler.verifyArrayEquals((Object[])scenario.cascadingStylesheets, (Object[])this.cascadingStylesheets)) {
            return false;
        }
        if (!Equaler.verifyArrayEquals((Object[])scenario.extensionURLs, (Object[])this.extensionURLs)) {
            return false;
        }
        if (!this.verifyEquals(scenario.headerURL, this.headerURL)) {
            return false;
        }
        if (!this.verifyEquals(scenario.footerURL, this.footerURL)) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.getXslTransformer(), (Object)this.getXslTransformer())) {
            return false;
        }
        if (scenario.isFOPPerforming != this.isFOPPerforming) {
            return false;
        }
        if (scenario.showInHTMLPane != this.showInHTMLPane) {
            return false;
        }
        if (scenario.showInXMLPane != this.showInXMLPane) {
            return false;
        }
        if (scenario.showInSVGPane != this.showInSVGPane) {
            return false;
        }
        if (scenario.showInResultSetPane != this.showInResultSetPane) {
            return false;
        }
        if (scenario.useXSLTInput != this.useXSLTInput) {
            return false;
        }
        if (scenario.saveAs != this.saveAs) {
            return false;
        }
        if (scenario.openInBrowser != this.openInBrowser) {
            return false;
        }
        if (scenario.openOtherLocationInBrowser != this.openOtherLocationInBrowser) {
            return false;
        }
        if (!Equaler.verifyEquals((Object)scenario.locationToOpenInBrowserURL, (Object)this.locationToOpenInBrowserURL)) {
            return false;
        }
        if (scenario.openInEditor != this.openInEditor) {
            return false;
        }
        return this.verifyEqualsAdvancedOptions(scenario);
    }

    public int hashCode() {
        int n2 = Boolean.valueOf(this.defaultScenario).hashCode();
        if (this.type != null) {
            n2 += this.type.hashCode();
        }
        if (this.inputXMLURL != null) {
            n2 += this.inputXMLURL.hashCode();
        }
        if (this.inputXSLURL != null) {
            n2 += this.inputXSLURL.hashCode();
        }
        if (this.getXslTransformer() != null) {
            n2 += this.getXslTransformer().hashCode();
        }
        return n2;
    }

    private boolean verifyEqualsAdvancedOptions(Scenario scenario) {
        boolean bl = true;
        if (scenario.advancedOptionsMap == null && this.advancedOptionsMap != null || scenario.advancedOptionsMap != null && this.advancedOptionsMap == null) {
            bl = false;
        }
        if (bl && scenario.advancedOptionsMap != null && this.advancedOptionsMap != null) {
            if (scenario.advancedOptionsMap.size() != this.advancedOptionsMap.size()) {
                bl = false;
            } else {
                for (String string : scenario.advancedOptionsMap.keySet()) {
                    if (Equaler.verifyEquals(scenario.advancedOptionsMap.get(string), this.advancedOptionsMap.get(string))) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getFooterURL() {
        return this.footerURL;
    }

    public String getFOPMethod() {
        return this.fOPMethod;
    }

    public String getFOProcessorName() {
        return this.fOProcessorName;
    }

    public String getHeaderURL() {
        return this.headerURL;
    }

    public String getInputXSLURL() {
        return this.inputXSLURL;
    }

    public String getInputXMLURL() {
        return this.inputXMLURL;
    }

    public boolean isDefaultScenario() {
        return this.defaultScenario;
    }

    public boolean getIsFOPPerforming() {
        return this.isFOPPerforming;
    }

    public String getSaveAsResource() {
        return this.outputResource;
    }

    public boolean getShowInHTMLPane() {
        return this.showInHTMLPane;
    }

    public boolean getShowInXMLPane() {
        return this.showInXMLPane;
    }

    public boolean getShowInSVGPane() {
        return this.showInSVGPane;
    }

    public boolean getShowInResultSetPane() {
        return this.showInResultSetPane;
    }

    public boolean getUseXSLTInput() {
        return this.useXSLTInput;
    }

    public SerializableList<TransformationParameter> getXsltParams() {
        return this.xsltParams;
    }

    public String[] getCascadingStylesheets() {
        return this.cascadingStylesheets;
    }

    public String getXslTransformer() {
        return this.xslTransformer;
    }

    public boolean isSaveAs() {
        return this.saveAs;
    }

    public boolean isOpenInBrowser() {
        return this.openInBrowser;
    }

    public boolean isOpenInEditor() {
        return this.openInEditor;
    }

    public boolean isOpenOtherLocationInBrowser() {
        return this.openOtherLocationInBrowser;
    }

    public String getLocationToOpenInBrowserURL() {
        return this.locationToOpenInBrowserURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    @Override
    public void setType(String string) {
        this.type = string;
        if (string == null) {
            this.type = XML_CONTEXT_XSL_TRANSFORMER;
        }
    }

    public void setFooterURL(String string) {
        this.footerURL = string;
    }

    public void setFOPMethod(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        this.fOPMethod = string;
    }

    public void setFOProcessorName(String string) {
        if (string != null && string.trim().length() == 0) {
            throw new IllegalArgumentException("The FOProcessorName may be null, but not the empty string.");
        }
        this.fOProcessorName = string;
    }

    public void setHeaderURL(String string) {
        this.headerURL = string;
    }

    public void setInputXSLURL(String string) {
        this.inputXSLURL = string;
    }

    public void setInputXMLURL(String string) {
        this.inputXMLURL = string;
    }

    public void setDefaultScenario(boolean bl) {
        this.defaultScenario = bl;
    }

    public void setIsFOPPerforming(boolean bl) {
        this.isFOPPerforming = bl;
    }

    public void setSaveAs(boolean bl) {
        this.saveAs = bl;
    }

    public void setOpenInBrowser(boolean bl) {
        this.openInBrowser = bl;
    }

    public void setOpenInEditor(boolean bl) {
        this.openInEditor = bl;
    }

    public void setOpenOtherLocationInBrowser(boolean bl) {
        this.openOtherLocationInBrowser = bl;
    }

    public void setLocationToOpenInBrowserURL(String string) {
        this.locationToOpenInBrowserURL = string;
    }

    public void setSaveAsResource(String string) {
        if (string != null && string.trim().length() == 0) {
            throw new IllegalArgumentException("The outputFile may be null, but not the empty string.");
        }
        this.outputResource = string;
        if (this.outputResource != null) {
            this.outputResource = this.replaceWindowsSeparatorsWithLinuxSeparators(this.outputResource);
        }
    }

    private String replaceWindowsSeparatorsWithLinuxSeparators(String string) {
        if (string.contains("\\")) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = string.length();
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if ('{' == c2) {
                    ++n3;
                } else if ('}' == c2) {
                    --n3;
                }
                if (c2 == '\\' && n3 == 0) {
                    stringBuilder.append("/");
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public void setShowInHTMLPane(boolean bl) {
        this.showInHTMLPane = bl;
    }

    public void setShowInXMLPane(boolean bl) {
        this.showInXMLPane = bl;
    }

    public void setShowInSVGPane(boolean bl) {
        this.showInSVGPane = bl;
    }

    public void setShowInResultSetPane(boolean bl) {
        this.showInResultSetPane = bl;
    }

    public void setUseXSLTInput(boolean bl) {
        this.useXSLTInput = bl;
    }

    public void setXsltParams(SerializableList<TransformationParameter> serializableList) {
        if (serializableList != null) {
            this.xsltParams = (SerializableList)serializableList.clone();
            Collections.sort(this.xsltParams, e.PARAM_NAME_COMPARATOR);
        } else {
            this.xsltParams.clear();
        }
    }

    public void setCascadingStylesheets(String[] stringArray) {
        this.cascadingStylesheets = stringArray;
    }

    public void setXslTransformer(String string) {
        this.xslTransformer = string;
    }

    public String toString() {
        return this.getName();
    }

    public String[] getExtensions() {
        return this.extensionURLs;
    }

    public static URL[] getExtensionsAsURLs(URL uRL, String[] stringArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                URL uRL2 = new URL(uRL, EditorVariables.expandEditorVariables(stringArray[i2], uRL != null ? uRL.toString() : null));
                db.b(arrayList, uRL2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                b.c("Could not create URL for extension:" + stringArray[i2]);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    public void setExtensions(String[] stringArray) {
        this.extensionURLs = stringArray;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.name == null) {
            throw new InvalidPersistentObjException("Invalid scenario name.");
        }
        if (this.type == null) {
            throw new InvalidPersistentObjException("Invalid scenario type.");
        }
        if (this.xsltParams == null) {
            throw new InvalidPersistentObjException("Invalid XSLT parameters list for scenario.");
        }
        if (this.xslTransformer == null) {
            throw new InvalidPersistentObjException("Invalid transformer in scenario.");
        }
        if (!(SQL_CONTEXT_SQL_TRANSFORMER.equals(this.type) || XML_CONTEXT_DITA_OT_TRANSFORMER.equals(this.type) || XML_CONTEXT_ANT_TRANSFORMER.equals(this.type) || XPROC_CONTEXT_XPROC_TRANSFORMER.equals(this.type))) {
            if (this.baseURL == null) {
                throw new InvalidPersistentObjException("Invalid base URL.");
            }
            if (this.headerURL == null) {
                throw new InvalidPersistentObjException("Invalid header URL for scenario.");
            }
            if (this.footerURL == null) {
                throw new InvalidPersistentObjException("Invalid footer URL for scenario.");
            }
            if (this.cascadingStylesheets == null) {
                throw new InvalidPersistentObjException("Invalid cascading XSLT's.");
            }
            if (this.extensionURLs == null) {
                this.setExtensions(new String[0]);
            }
        }
        if (BUILTIN_OLD.equals(this.fOProcessorName)) {
            this.fOProcessorName = APACHE_FOP;
        }
    }

    @Override
    public void prepareURLsForSerialization(boolean bl) {
        if (!bl) {
            URL uRL;
            if (this.inputXSLURL != null) {
                this.inputXSLURL = URLUtil.replaceBackSlash((String)this.inputXSLURL);
                try {
                    uRL = new URL(this.inputXSLURL);
                    this.inputXSLURL = Crypto.crypt((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.inputXMLURL != null) {
                this.inputXMLURL = URLUtil.replaceBackSlash((String)this.inputXMLURL);
                try {
                    uRL = new URL(this.inputXMLURL);
                    this.inputXMLURL = Crypto.crypt((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.baseURL != null) {
                this.baseURL = URLUtil.replaceBackSlash((String)this.baseURL);
                try {
                    uRL = new URL(this.baseURL);
                    this.baseURL = Crypto.crypt((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.headerURL != null) {
                this.headerURL = URLUtil.replaceBackSlash((String)this.headerURL);
                try {
                    uRL = new URL(this.headerURL);
                    this.headerURL = Crypto.crypt((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.footerURL != null) {
                this.footerURL = URLUtil.replaceBackSlash((String)this.footerURL);
                try {
                    uRL = new URL(this.footerURL);
                    this.footerURL = Crypto.crypt((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.locationToOpenInBrowserURL != null) {
                this.locationToOpenInBrowserURL = URLUtil.replaceBackSlash((String)this.locationToOpenInBrowserURL);
                try {
                    uRL = new URL(this.locationToOpenInBrowserURL);
                    this.locationToOpenInBrowserURL = Crypto.crypt((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            URL uRL;
            if (this.inputXSLURL != null) {
                this.inputXSLURL = URLUtil.replaceBackSlash((String)this.inputXSLURL);
                try {
                    uRL = new URL(this.inputXSLURL);
                    this.inputXSLURL = URLUtil.clearUserInfo((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.inputXMLURL != null) {
                this.inputXMLURL = URLUtil.replaceBackSlash((String)this.inputXMLURL);
                try {
                    uRL = new URL(this.inputXMLURL);
                    this.inputXMLURL = URLUtil.clearUserInfo((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.baseURL != null) {
                this.baseURL = URLUtil.replaceBackSlash((String)this.baseURL);
                try {
                    uRL = new URL(this.baseURL);
                    this.baseURL = URLUtil.clearUserInfo((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.headerURL != null) {
                this.headerURL = URLUtil.replaceBackSlash((String)this.headerURL);
                try {
                    uRL = new URL(this.headerURL);
                    this.headerURL = URLUtil.clearUserInfo((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.footerURL != null) {
                this.footerURL = URLUtil.replaceBackSlash((String)this.footerURL);
                try {
                    uRL = new URL(this.footerURL);
                    this.footerURL = URLUtil.clearUserInfo((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.locationToOpenInBrowserURL != null) {
                this.locationToOpenInBrowserURL = URLUtil.replaceBackSlash((String)this.locationToOpenInBrowserURL);
                try {
                    uRL = new URL(this.locationToOpenInBrowserURL);
                    this.locationToOpenInBrowserURL = URLUtil.clearUserInfo((URL)uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void decryptURLs() {
        if (this.inputXSLURL != null) {
            try {
                this.inputXSLURL = Crypto.decrypt((URL)new URL(this.inputXSLURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.inputXMLURL != null) {
            try {
                this.inputXMLURL = Crypto.decrypt((URL)new URL(this.inputXMLURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.baseURL != null) {
            try {
                this.baseURL = Crypto.decrypt((URL)new URL(this.baseURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.headerURL != null) {
            try {
                this.headerURL = Crypto.decrypt((URL)new URL(this.headerURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.footerURL != null) {
            try {
                this.footerURL = Crypto.decrypt((URL)new URL(this.footerURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.locationToOpenInBrowserURL != null) {
            try {
                this.locationToOpenInBrowserURL = Crypto.decrypt((URL)new URL(this.locationToOpenInBrowserURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private static void setDefaultHEOptions(XSLTSaxonHEAdvancedOptions xSLTSaxonHEAdvancedOptions) {
        xSLTSaxonHEAdvancedOptions.setOptimization(Options.getInstance().getBooleanProperty("saxon.latest.enable.optimizations"));
        xSLTSaxonHEAdvancedOptions.setDtdSourceValidation(Options.getInstance().getIntegerProperty("saxon8.dtd.based.validation"));
        xSLTSaxonHEAdvancedOptions.setLineNumbering(Options.getInstance().getBooleanProperty("saxon8.line.numbering"));
        xSLTSaxonHEAdvancedOptions.setTraceIntoXPathExpression(Options.getInstance().getBooleanProperty("saxon.trace.into.xpath.expressions"));
        xSLTSaxonHEAdvancedOptions.setExpandAttributeDefaults(Options.getInstance().getBooleanProperty("saxon.latest.expand.attribute.defaults"));
        String string = Options.getInstance().getStringProperty("xslt.strip.ws");
        if ("saxon.strip.ws.all".equals(string)) {
            xSLTSaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.all");
        } else if ("saxon.strip.ws.ignorable".equals(string)) {
            xSLTSaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
        } else {
            xSLTSaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.none");
        }
        xSLTSaxonHEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("saxon.latest.config.file"));
        xSLTSaxonHEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("saxon.latest.use.config.file"));
    }

    private static void setDefaultPEOptions(XSLTSaxonPEAdvancedOptions xSLTSaxonPEAdvancedOptions) {
        Scenario.setDefaultHEOptions(xSLTSaxonPEAdvancedOptions);
        xSLTSaxonPEAdvancedOptions.setAllowCallsOnExtensionFunctions(Options.getInstance().getBooleanProperty("saxon8.allow.calls.on.extension.functions"));
        xSLTSaxonPEAdvancedOptions.setRegisterSaxonCEExtensions(Options.getInstance().getBooleanProperty("saxon.latest.register.saxon.ce.extensions"));
        xSLTSaxonPEAdvancedOptions.setAssertionsEnabled(Options.getInstance().getBooleanProperty("saxon.latest.enable.assertions"));
    }

    private static void setDefaultEEOptions(XSLTSaxonEEAdvancedOptions xSLTSaxonEEAdvancedOptions) {
        Scenario.setDefaultPEOptions(xSLTSaxonEEAdvancedOptions);
        String string = Options.getInstance().getStringProperty("default.xml.schema.version");
        xSLTSaxonEEAdvancedOptions.setSchemaVersion(string);
        xSLTSaxonEEAdvancedOptions.setTreatResultValidationErrorsAsWarnings(Options.getInstance().getBooleanProperty("saxon8.validation.warnings.in.result"));
        xSLTSaxonEEAdvancedOptions.setAddCommentsForValidationErrors(Options.getInstance().getBooleanProperty("saxon8.validation.comments.in.result"));
        xSLTSaxonEEAdvancedOptions.setStreamingEnabled(false);
        String string2 = Options.getInstance().getStringProperty("saxon8.schema.based.validation");
        xSLTSaxonEEAdvancedOptions.setSourceValidation(string2);
    }

    private static void setDefaultXQueryHEOptions(XQuerySaxonHEAdvancedOptions xQuerySaxonHEAdvancedOptions) {
        xQuerySaxonHEAdvancedOptions.setOptimization(Options.getInstance().getBooleanProperty("xquery.enable.optimizations"));
        xQuerySaxonHEAdvancedOptions.setEnabledLinkedTreeModel(Options.getInstance().getBooleanProperty("xquery.linked.tree.model"));
        String string = Options.getInstance().getStringProperty("xquery.strip.ws");
        if ("saxon.strip.ws.all".equals(string)) {
            xQuerySaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.all");
        } else if ("saxon.strip.ws.none".equals(string)) {
            xQuerySaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.none");
        } else {
            xQuerySaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
        }
        xQuerySaxonHEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("xquery.saxon.config.file"));
        xQuerySaxonHEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("xquery.saxon.use.config.file"));
    }

    private static void setDefaultXQueryPEOptions(XQuerySaxonPEAdvancedOptions xQuerySaxonPEAdvancedOptions) {
        Scenario.setDefaultXQueryHEOptions(xQuerySaxonPEAdvancedOptions);
        xQuerySaxonPEAdvancedOptions.setAllowCallsOnExtensionFunctions(Options.getInstance().getBooleanProperty("xquery.allow.calls.on.extension.functions"));
    }

    private static void setDefaultXQueryEEOptions(XQuerySaxonEEAdvancedOptions xQuerySaxonEEAdvancedOptions) {
        Scenario.setDefaultXQueryPEOptions(xQuerySaxonEEAdvancedOptions);
        xQuerySaxonEEAdvancedOptions.setTreatResultValidationErrorsAsWarnings(Options.getInstance().getBooleanProperty("xquery.validation.warnings.in.result"));
        xQuerySaxonEEAdvancedOptions.setAddCommentsForValidationErrors(Options.getInstance().getBooleanProperty("xquery.validation.comments.in.result"));
        xQuerySaxonEEAdvancedOptions.setEnableBackup(Options.getInstance().getBooleanProperty("enable.xquery.backup"));
        xQuerySaxonEEAdvancedOptions.setEnableXQueryUpdate(Options.getInstance().getBooleanProperty("saxon.enable.xquery.update"));
        String string = Options.getInstance().getStringProperty("xquery.schema.based.validation");
        xQuerySaxonEEAdvancedOptions.setSourceValidation(string);
    }

    public static AdvancedTransformerOptionsBase getDefaultAdvancedOptions(String string) {
        SaxonHEAdvancedOptions saxonHEAdvancedOptions = null;
        if ("Saxon-HE".equals(string) || "Saxon-HE JSON".equals(string)) {
            XSLTSaxonHEAdvancedOptions xSLTSaxonHEAdvancedOptions = new XSLTSaxonHEAdvancedOptions();
            Scenario.setDefaultHEOptions(xSLTSaxonHEAdvancedOptions);
            saxonHEAdvancedOptions = xSLTSaxonHEAdvancedOptions;
        } else if ("Saxon-PE".equals(string) || "Saxon-PE JSON".equals(string)) {
            XSLTSaxonPEAdvancedOptions xSLTSaxonPEAdvancedOptions = new XSLTSaxonPEAdvancedOptions();
            Scenario.setDefaultPEOptions(xSLTSaxonPEAdvancedOptions);
            saxonHEAdvancedOptions = xSLTSaxonPEAdvancedOptions;
        } else if ("Saxon-EE".equals(string) || "Saxon-EE JSON".equals(string)) {
            XSLTSaxonEEAdvancedOptions xSLTSaxonEEAdvancedOptions = new XSLTSaxonEEAdvancedOptions();
            Scenario.setDefaultEEOptions(xSLTSaxonEEAdvancedOptions);
            saxonHEAdvancedOptions = xSLTSaxonEEAdvancedOptions;
        } else if ("Saxon-HE XQuery".equals(string) || "Saxon-HE XQuery JSON".equals(string)) {
            XQuerySaxonHEAdvancedOptions xQuerySaxonHEAdvancedOptions = new XQuerySaxonHEAdvancedOptions();
            Scenario.setDefaultXQueryHEOptions(xQuerySaxonHEAdvancedOptions);
            saxonHEAdvancedOptions = xQuerySaxonHEAdvancedOptions;
        } else if ("Saxon-PE XQuery".equals(string) || "Saxon-PE XQuery JSON".equals(string)) {
            XQuerySaxonPEAdvancedOptions xQuerySaxonPEAdvancedOptions = new XQuerySaxonPEAdvancedOptions();
            Scenario.setDefaultXQueryPEOptions(xQuerySaxonPEAdvancedOptions);
            saxonHEAdvancedOptions = xQuerySaxonPEAdvancedOptions;
        } else if ("Saxon-EE XQuery".equals(string) || "Saxon-EE XQuery JSON".equals(string)) {
            XQuerySaxonEEAdvancedOptions xQuerySaxonEEAdvancedOptions = new XQuerySaxonEEAdvancedOptions();
            Scenario.setDefaultXQueryEEOptions(xQuerySaxonEEAdvancedOptions);
            saxonHEAdvancedOptions = xQuerySaxonEEAdvancedOptions;
        }
        return saxonHEAdvancedOptions;
    }

    public AdvancedTransformerOptionsBase getAdvancedOptions(String string) {
        string = u.d(string);
        HashMap hashMap = null;
        hashMap = this.advancedOptionsMap == null ? new HashMap() : this.advancedOptionsMap;
        AdvancedTransformerOptionsBase advancedTransformerOptionsBase = (AdvancedTransformerOptionsBase)hashMap.get(string);
        if (advancedTransformerOptionsBase == null) {
            advancedTransformerOptionsBase = Scenario.getDefaultAdvancedOptions(string);
        }
        return advancedTransformerOptionsBase;
    }

    public void setAdvancedOptions(String string, AdvancedTransformerOptionsBase advancedTransformerOptionsBase) {
        if (this.advancedOptionsMap == null) {
            this.advancedOptionsMap = new SerializableLinkedHashMap();
        }
        this.advancedOptionsMap.put(string, advancedTransformerOptionsBase);
    }

    public static String getCreateNewScenarioHelpPageID(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (XML_CONTEXT_XQUERY_TRANSFORMER.equals(string) || XQUERY_CONTEXT_XML_TRANSFORMER.equals(string)) {
                return "transforming-xml-documents-using-xquery";
            }
            if (XML_CONTEXT_DITA_OT_TRANSFORMER.equals(string)) {
                return "dita-ot-transformation";
            }
            if (XML_CONTEXT_ANT_TRANSFORMER.equals(string)) {
                return "ant-transformation";
            }
            if (XPROC_CONTEXT_XPROC_TRANSFORMER.equals(string)) {
                return "xproc-transformation-scenario";
            }
        }
        return "defining-new-transformation-scenario";
    }

    public static List<String> getFOMethods(String string) {
        List<String> list = Scenario.getCommonFOMethods();
        if (string != null) {
            if (string.contains(APACHE_FOP)) {
                list = Scenario.getApacheFOPMethods();
            } else if (string.contains("XEP")) {
                list = Scenario.getXEPMethods();
            } else if (string.contains("Antenna House")) {
                list = Scenario.getAHMethods();
            }
        }
        return list;
    }

    private static List<String> getCommonFOMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(METHOD_PDF);
        arrayList.add(METHOD_PS);
        return arrayList;
    }

    private static List<String> getApacheFOPMethods() {
        List<String> list = Scenario.getCommonFOMethods();
        list.add(METHOD_TXT);
        list.add("rtf");
        list.add("pcl");
        list.add("afp");
        list.add("tiff");
        list.add("png");
        list.add("at");
        return list;
    }

    private static List<String> getXEPMethods() {
        List<String> list = Scenario.getCommonFOMethods();
        list.add("xps");
        list.add("xep");
        list.add("afp");
        list.add("html");
        return list;
    }

    private static List<String> getAHMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("@PDF");
        arrayList.add("@SVG");
        arrayList.add("@PS");
        arrayList.add("@XPS");
        arrayList.add("@INX");
        arrayList.add("@MIF");
        arrayList.add("@TEXT");
        arrayList.add("@AreaTree");
        return arrayList;
    }

    private static ImmutableMap<String, Integer> buildScenarioTypeToPriorityMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i2 = 0; i2 < ALL_SCENARIO_TYPES.length; ++i2) {
            builder.put((Object)ALL_SCENARIO_TYPES[i2], (Object)i2);
        }
        return builder.build();
    }

    @Override
    public void updateParameters(Map<String, String> map) {
        SerializableList<? extends e> serializableList = g.b(this.getXsltParams(), map);
        List list = serializableList.stream().map(TransformationParameter::getName).collect(Collectors.toList());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            if (list.contains(string)) continue;
            serializableList.add(new TransformationParameter(string, entry.getValue()));
        }
        this.setXsltParams(serializableList);
    }
}

