/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.finders;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.finders.jb;
import ro.sync.exml.options.Options;
import ro.sync.i18n.c;
import ro.sync.i18n.r;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public abstract class SearchReferencesScopePO
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)SearchReferencesScopePO.class.getName());
    protected int scope;
    public String[] anonymousWorkingSetEntries;
    private boolean useOnlyMasterFiles = true;

    public SearchReferencesScopePO() {
        this.scope = jb._d.c.c();
    }

    public SearchReferencesScopePO(int n2) {
        this.scope = n2;
    }

    public final jb._d getScope() {
        return jb._d.d(this.scope);
    }

    public String[] getAnonymousWorkingSetEntries() {
        return this.anonymousWorkingSetEntries;
    }

    public void setAnonymousWorkingSetEntries(String ... stringArray) {
        this.anonymousWorkingSetEntries = stringArray;
    }

    public abstract String getBackupExtension();

    public abstract boolean isBackupEnabled();

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"anonymousWorkingSetEntries"};
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
    }

    public abstract String[] getSelectedWorkingSetNames();

    public boolean isUseOnlyMasterFiles() {
        return this.useOnlyMasterFiles;
    }

    public void setUseOnlyMasterFiles(boolean bl) {
        this.useOnlyMasterFiles = bl;
    }

    public String getDescription() {
        c c2 = r.m();
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getScope()) {
            case f: {
                if (this.isUseOnlyMasterFiles() && Options.getInstance().getBooleanProperty("enable.project.master.files.support")) {
                    stringBuilder.append(c2.getString("Main_files_lower_case"));
                    break;
                }
                stringBuilder.append(c2.getString("Project_lower_case"));
                break;
            }
            case i: {
                stringBuilder.append(c2.getString("Current_file_lower_case"));
                break;
            }
            case j: {
                stringBuilder.append(c2.getString("Working_set_s"));
                String[] stringArray = this.getSelectedWorkingSetNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (i2 > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(" '").append(stringArray[i2]).append("'");
                }
                break;
            }
            case d: {
                if (this.isUseOnlyMasterFiles() && Options.getInstance().getBooleanProperty("enable.project.master.files.support")) {
                    stringBuilder.append(c2.getString("Main_files_lower_case"));
                    break;
                }
                stringBuilder.append(c2.getString("Workspace_lower_case"));
                break;
            }
            case h: {
                stringBuilder.append(c2.getString("Anonymous_working_set"));
                break;
            }
            case c: {
                stringBuilder.append(c2.getString("Undefined"));
            }
        }
        return stringBuilder.toString();
    }
}

