/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.properties.ECTablePropertiesCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.properties.EditedTablePropertiesInfo;
import ro.sync.ecss.extensions.commons.table.properties.SATablePropertiesCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelper;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class ShowTablePropertiesBaseOperation
implements AuthorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ShowTablePropertiesBaseOperation.class.getName());
    protected TablePropertiesHelper tableHelper;
    protected AuthorAccess authorAccess;

    public ShowTablePropertiesBaseOperation(TablePropertiesHelper tablePropertiesHelper) {
        this.tableHelper = tablePropertiesHelper;
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        this.authorAccess = authorAccess;
        try {
            this.showTableProperties(argumentsMap);
        }
        catch (AuthorOperationException authorOperationException) {
            authorAccess.getWorkspaceAccess().showErrorMessage(authorOperationException.getMessage(), authorOperationException);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public void showTableProperties(ArgumentsMap argumentsMap) throws AuthorOperationException {
        int n2 = this.authorAccess.getEditorAccess().getCaretOffset();
        List<Integer[]> list = this.getSelections();
        List<TabInfo> list2 = this.getCategoriesAndProperties(list);
        if (list2.isEmpty()) {
            throw new AuthorOperationException(this.authorAccess.getAuthorResourceBundle().getMessage("Cannot_perform_operation_no_element_to_edit_properties_for"));
        }
        EditedTablePropertiesInfo editedTablePropertiesInfo = null;
        EditedTablePropertiesInfo editedTablePropertiesInfo2 = new EditedTablePropertiesInfo(list2, this.getSelectedTab(list));
        editedTablePropertiesInfo = argumentsMap.getArgumentValue("tableInfo") != null ? ShowTablePropertiesBaseOperation.getTableInfoFromDescriptor((Map)argumentsMap.getArgumentValue("tableInfo"), list2) : this.showDialog(editedTablePropertiesInfo2);
        if (editedTablePropertiesInfo != null) {
            this.applyChanges(editedTablePropertiesInfo);
            this.authorAccess.getEditorAccess().setCaretPosition(n2);
        }
    }

    private static EditedTablePropertiesInfo getTableInfoFromDescriptor(Map<String, List> map, List<TabInfo> list) {
        ArrayList<TabInfo> arrayList = new ArrayList<TabInfo>();
        EditedTablePropertiesInfo editedTablePropertiesInfo = null;
        for (TabInfo tabInfo : list) {
            ArrayList<TableProperty> arrayList2 = new ArrayList<TableProperty>();
            List list2 = map.get(tabInfo.getTabKey());
            if (list2 == null) continue;
            for (Map map2 : list2) {
                String string = (String)map2.get("attributeName");
                boolean bl = (Boolean)map2.get("attribute");
                String string2 = (String)map2.get("currentValue");
                arrayList2.add(new TableProperty(string, null, null, string2, bl));
            }
            if (arrayList2.isEmpty()) continue;
            List<AuthorElement> list3 = tabInfo.getNodes();
            arrayList.add(new TabInfo(tabInfo.getTabKey(), arrayList2, list3));
        }
        if (!arrayList.isEmpty()) {
            editedTablePropertiesInfo = new EditedTablePropertiesInfo(arrayList);
        }
        return editedTablePropertiesInfo;
    }

    private void applyChanges(EditedTablePropertiesInfo editedTablePropertiesInfo) throws AuthorOperationException {
        this.applyAttributesChanges(editedTablePropertiesInfo);
        List<TabInfo> list = this.getFragmentsAndOffsetsToInsert(editedTablePropertiesInfo);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TabInfo tabInfo = list.get(i2);
            this.applyTabChanges(tabInfo);
        }
    }

    private void applyTabChanges(TabInfo tabInfo) {
        Object object;
        List<AuthorElement> list = tabInfo.getNodes();
        AuthorNode authorNode = this.authorAccess.getDocumentController().getStrictCommonAncestor(list.toArray(new AuthorElement[0]));
        if (!(authorNode instanceof AuthorElement)) {
            return;
        }
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!list.contains(object.getParentElement())) continue;
            object2.remove();
        }
        ShowTablePropertiesBaseOperation.sortInDocumentOrder(list);
        object2 = new int[list.size()];
        object = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2[i2] = list.get(i2).getStartOffset();
            object[i2] = list.get(i2).getEndOffset();
        }
        this.authorAccess.getDocumentController().multipleDelete((AuthorElement)authorNode, (int[])object2, (int[])object);
        int[] nArray = new int[tabInfo.getFragmentsToInsert().size()];
        for (int i3 = 0; i3 < tabInfo.getFragmentsToInsert().size(); ++i3) {
            nArray[i3] = tabInfo.getInsertOffsets()[i3].getOffset();
        }
        this.authorAccess.getDocumentController().insertMultipleFragments((AuthorElement)authorNode, tabInfo.getFragmentsToInsert().toArray(new AuthorDocumentFragment[0]), nArray);
    }

    private static void sortInDocumentOrder(List<AuthorElement> list) {
        Collections.sort(list, new Comparator<AuthorElement>(){

            @Override
            public int compare(AuthorElement authorElement, AuthorElement authorElement2) {
                int n2 = 0;
                n2 = authorElement.getStartOffset() < authorElement2.getStartOffset() ? -1 : 1;
                return n2;
            }
        });
    }

    private void applyAttributesChanges(EditedTablePropertiesInfo editedTablePropertiesInfo) {
        List<TabInfo> list = this.getElementsWithModifiedAttributes(editedTablePropertiesInfo);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TabInfo tabInfo = list.get(i2);
            List<AuthorElement> list2 = tabInfo.getNodes();
            List<TableProperty> list3 = tabInfo.getProperties();
            AuthorNode authorNode = this.authorAccess.getDocumentController().getCommonAncestor(list2.toArray(new AuthorElement[0]));
            if (authorNode == null) continue;
            int[] nArray = new int[list2.size()];
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                AuthorElement authorElement = list2.get(i3);
                nArray[i3] = authorElement.getStartOffset();
            }
            LinkedHashMap<String, AttrValue> linkedHashMap = new LinkedHashMap<String, AttrValue>();
            for (int i4 = 0; i4 < list3.size(); ++i4) {
                TableProperty tableProperty = list3.get(i4);
                linkedHashMap.put(tableProperty.getAttributeName(), tableProperty.getCurrentValue() != null ? new AttrValue(tableProperty.getCurrentValue()) : null);
            }
            if (linkedHashMap.isEmpty()) continue;
            this.authorAccess.getDocumentController().setMultipleAttributes(authorNode.getStartOffset(), nArray, linkedHashMap);
        }
    }

    private EditedTablePropertiesInfo showDialog(EditedTablePropertiesInfo editedTablePropertiesInfo) {
        EditedTablePropertiesInfo editedTablePropertiesInfo2 = null;
        Platform platform = this.authorAccess.getWorkspaceAccess().getPlatform();
        if (platform == Platform.STANDALONE) {
            Frame frame = (Frame)this.authorAccess.getWorkspaceAccess().getParentFrame();
            SATablePropertiesCustomizerDialog sATablePropertiesCustomizerDialog = new SATablePropertiesCustomizerDialog(frame, this.authorAccess.getAuthorResourceBundle(), this.authorAccess.getWorkspaceAccess()){

                @Override
                public String getHelpPageID() {
                    return ShowTablePropertiesBaseOperation.this.getHelpPageID();
                }
            };
            editedTablePropertiesInfo2 = sATablePropertiesCustomizerDialog.getTablePropertiesInformation(editedTablePropertiesInfo);
        } else if (platform == Platform.ECLIPSE) {
            ECTablePropertiesCustomizerDialog eCTablePropertiesCustomizerDialog = new ECTablePropertiesCustomizerDialog((Shell)this.authorAccess.getWorkspaceAccess().getParentFrame(), this.authorAccess.getAuthorResourceBundle(), this.authorAccess.getWorkspaceAccess(), this.getHelpPageID());
            editedTablePropertiesInfo2 = eCTablePropertiesCustomizerDialog.getTablePropertiesInformation(editedTablePropertiesInfo);
        }
        return editedTablePropertiesInfo2;
    }

    private List<Integer[]> getSelections() throws AuthorOperationException {
        int n2;
        int n3;
        List<Object> list;
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        if (this.authorAccess.getEditorAccess().hasSelection()) {
            list = this.authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            if (list != null && !list.isEmpty()) {
                for (n3 = 0; n3 < list.size(); ++n3) {
                    n2 = ((ContentInterval)list.get(n3)).getStartOffset();
                    int n4 = ((ContentInterval)list.get(n3)).getEndOffset();
                    arrayList.add(new Integer[]{n2, n4});
                }
            }
        } else {
            int n5 = this.authorAccess.getEditorAccess().getCaretOffset();
            arrayList.add(new Integer[]{n5, n5});
        }
        list = TableOperationsUtil.getTableElementsOfType(this.authorAccess, arrayList, 5, this.tableHelper);
        n3 = 0;
        for (n2 = 0; n2 < list.size() && n3 < 2; ++n2) {
            if (this.tableHelper.isNodeOfType((AuthorElement)list.get(n2), 4)) continue;
            ++n3;
        }
        if (n3 > 1) {
            throw new AuthorOperationException(this.authorAccess.getAuthorResourceBundle().getMessage("Cannot_perform_table_properties_operation"));
        }
        return arrayList;
    }

    protected List<TabInfo> getElementsWithModifiedAttributes(EditedTablePropertiesInfo editedTablePropertiesInfo) {
        ArrayList<TabInfo> arrayList = new ArrayList<TabInfo>();
        List<TabInfo> list = editedTablePropertiesInfo.getCategories();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ArrayList<TableProperty> arrayList2 = new ArrayList<TableProperty>();
            TabInfo tabInfo = list.get(i2);
            List<TableProperty> list2 = tabInfo.getProperties();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                TableProperty tableProperty = list2.get(i3);
                if (!tableProperty.isAttribute() || "<preserve>".equals(tableProperty.getCurrentValue())) continue;
                if ("<not set>".equals(tableProperty.getCurrentValue())) {
                    tableProperty.setCurrentValue(null);
                }
                arrayList2.add(tableProperty);
            }
            arrayList.add(new TabInfo(tabInfo.getTabKey(), arrayList2, tabInfo.getNodes()));
        }
        return arrayList;
    }

    protected boolean checkRowSpans(List<AuthorElement> list, int n2) {
        boolean bl = true;
        block0: for (int i2 = 0; i2 < list.size(); ++i2) {
            ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
            AuthorElement authorElement = list.get(i2);
            TableOperationsUtil.getChildElements(authorElement, 6, arrayList, this.tableHelper);
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                AuthorElement authorElement2;
                int[] nArray = this.authorAccess.getTableAccess().getTableRowSpanIndices((AuthorElement)arrayList.get(i3));
                if (nArray == null || nArray[1] - nArray[0] <= 0 || (authorElement2 = TableOperationsUtil.getElementAncestor(authorElement, n2, this.tableHelper)) == null) continue;
                ArrayList<AuthorElement> arrayList2 = new ArrayList<AuthorElement>();
                TableOperationsUtil.getChildElements(authorElement2, 0, arrayList2, this.tableHelper);
                List list2 = arrayList2.subList(nArray[0], nArray[1] + 1);
                int n3 = this.tableHelper.getElementType((AuthorElement)((AuthorElement)list2.get(0)).getParent());
                for (int i4 = 1; i4 < list2.size(); ++i4) {
                    if (n3 == this.tableHelper.getElementType((AuthorElement)((AuthorElement)list2.get(i4)).getParent())) continue;
                    bl = false;
                    break block0;
                }
                if (list.containsAll(list2)) continue;
                bl = false;
                break block0;
            }
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return null;
    }

    protected List<TabInfo> getFragmentsAndOffsetsToInsert(EditedTablePropertiesInfo editedTablePropertiesInfo) throws AuthorOperationException {
        List<TabInfo> list = editedTablePropertiesInfo.getCategories();
        ArrayList<TabInfo> arrayList = new ArrayList<TabInfo>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ArrayList<AuthorDocumentFragment> arrayList2 = new ArrayList<AuthorDocumentFragment>();
            ArrayList<Position> arrayList3 = new ArrayList<Position>();
            TabInfo tabInfo = list.get(i2);
            TabInfo tabInfo2 = null;
            ArrayList<AuthorElement> arrayList4 = new ArrayList<AuthorElement>();
            List<TableProperty> list2 = tabInfo.getProperties();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                TableProperty tableProperty = list2.get(i3);
                if (tableProperty.isAttribute()) continue;
                tabInfo2 = new TabInfo(tabInfo.getTabKey(), tabInfo.getProperties(), null);
                String string = tableProperty.getCurrentValue();
                if ("rowType".equals(tableProperty.getAttributeName())) {
                    for (int i4 = 0; i4 < tabInfo.getNodes().size(); ++i4) {
                        boolean bl = false;
                        AuthorElement authorElement = tabInfo.getNodes().get(i4);
                        bl = "Body".equals(string) ? this.computeFragmentsToMoveInsideBody(arrayList2, arrayList3, tabInfo, arrayList4, authorElement) : ("Header".equals(string) ? this.computeFragmentMoveInsideHeader(arrayList2, arrayList3, tabInfo, arrayList4, authorElement) : this.computeFragmentsToMoveInsideFooter(arrayList2, arrayList3, tabInfo, arrayList4, authorElement));
                        if (!bl || arrayList4.contains(authorElement.getParentElement())) continue;
                        arrayList4.add(0, (AuthorElement)authorElement.getParentElement());
                    }
                    tabInfo2.setNodes(arrayList4);
                    tabInfo2.setFragmentsToInsert(arrayList2);
                    tabInfo2.setInsertOffsets(arrayList3.toArray(new Position[0]));
                }
                arrayList.add(tabInfo2);
            }
        }
        return arrayList;
    }

    protected TabInfo getTableInformation(List<Integer[]> list) {
        TabInfo tabInfo = null;
        List<AuthorElement> list2 = TableOperationsUtil.getTableElementsOfType(this.authorAccess, list, 5, this.tableHelper);
        if (!list2.isEmpty()) {
            Object object;
            int n2;
            ArrayList<TableProperty> arrayList = new ArrayList<TableProperty>();
            ArrayList<AuthorElement> arrayList2 = new ArrayList<AuthorElement>();
            HashMap<TableProperty, String> hashMap = new HashMap<TableProperty, String>();
            arrayList2.addAll(list2);
            List<TableProperty> list3 = this.getTableAttribute();
            for (n2 = 0; n2 < list2.size(); ++n2) {
                object = list2.get(n2);
                for (int i2 = 0; i2 < list3.size(); ++i2) {
                    if (n2 == 0) {
                        hashMap.put(list3.get(i2), "Not computed");
                    }
                    String string = this.getCommonValue((AuthorElement)object, list3.get(i2).getAttributeName(), (String)hashMap.get(list3.get(i2)));
                    hashMap.put(list3.get(i2), string);
                }
            }
            for (n2 = 0; n2 < list3.size(); ++n2) {
                object = list3.get(n2);
                TableProperty tableProperty = this.getAttrProperty(list2, (String)hashMap.get(object), (TableProperty)object);
                if (tableProperty == null) continue;
                arrayList.add(tableProperty);
            }
            tabInfo = new TabInfo("Table", arrayList, arrayList2);
        }
        return tabInfo;
    }

    protected TableProperty getAttrProperty(List<AuthorElement> list, String string, TableProperty tableProperty) {
        TableProperty tableProperty2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!list.isEmpty()) {
            Object object;
            if (tableProperty.getValues() != null) {
                arrayList.addAll(tableProperty.getValues());
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                object = (String)arrayList.get(i2);
                if (((String)object).equalsIgnoreCase("left")) {
                    hashMap.put((String)object, "/images/table-properties/HalignLeft.png");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("right")) {
                    hashMap.put((String)object, "/images/table-properties/HalignRight.png");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("center")) {
                    hashMap.put((String)object, "/images/table-properties/HalignCenter.png");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("justify")) {
                    hashMap.put((String)object, "/images/table-properties/HalignJustify.png");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("top")) {
                    hashMap.put((String)object, "/images/table-properties/ValignTop.png");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("middle")) {
                    hashMap.put((String)object, "/images/table-properties/ValignMiddle.png");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("bottom")) {
                    hashMap.put((String)object, "/images/table-properties/ValignBottom.png");
                    continue;
                }
                hashMap.put((String)object, "/images/table-properties/EmptyIcon.png");
            }
            if (tableProperty.getIcons() != null) {
                hashMap.putAll(tableProperty.getIcons());
            }
            String string2 = null;
            if (list.size() > 1) {
                if (string == null || "Not computed".equals(string)) {
                    string2 = "<not set>";
                } else if (!arrayList.contains(string)) {
                    string2 = "<preserve>";
                    arrayList.add("<preserve>");
                    hashMap.put("<preserve>", "/images/table-properties/EmptyIcon.png");
                } else {
                    string2 = string;
                }
            } else if (list.size() == 1) {
                string2 = "<not set>";
                object = list.get(0).getAttribute(tableProperty.getAttributeName());
                if (object != null && !arrayList.contains(string2 = ((AttrValue)object).getValue())) {
                    string2 = "<preserve>";
                    arrayList.add("<preserve>");
                    hashMap.put("<preserve>", "/images/table-properties/EmptyIcon.png");
                }
            }
            arrayList.add("<not set>");
            hashMap.put("<not set>", "/images/table-properties/EmptyIcon.png");
            tableProperty2 = new TableProperty(tableProperty.getAttributeName(), tableProperty.getAttributeRenderString(), arrayList, string2, true);
            tableProperty2.setGuiType(tableProperty.getGuiType());
            tableProperty2.setParentGroup(tableProperty.getParentGroup());
            tableProperty2.setIcons(hashMap);
        }
        return tableProperty2;
    }

    protected String getCommonValue(AuthorElement authorElement, String string, String string2) {
        AttrValue attrValue;
        boolean bl;
        String string3 = string2;
        boolean bl2 = !this.tableHelper.isTable(authorElement);
        boolean bl3 = this.tableHelper.isTable(authorElement) && !this.tableHelper.isTableGroup(authorElement);
        boolean bl4 = bl = "align".equals(string) && bl3;
        if (!bl && !bl3) {
            AttrValue attrValue2 = authorElement.getAttribute(string);
            if (attrValue2 != null) {
                String string4 = attrValue2.getValue();
                if ("Not computed".equals(string3)) {
                    string3 = string4;
                } else if (string3 == null && bl2 || string3 != null && !string3.equals(string4) && !string3.equals("<not set>") && !string3.equals("<preserve>") && bl2) {
                    string3 = "<preserve>";
                }
            } else if (string3 != null && !string3.equals("Not computed") && !string3.equals("<preserve>") && bl2) {
                string3 = "<preserve>";
            } else if ("Not computed".equals(string3)) {
                string3 = null;
            }
        } else if (bl3 && (attrValue = authorElement.getAttribute(string)) != null) {
            String string5;
            string3 = string5 = attrValue.getValue();
        }
        return string3;
    }

    protected EditedTablePropertiesInfo.TAB_TYPE getSelectedTab(List<Integer[]> list) {
        EditedTablePropertiesInfo.TAB_TYPE tAB_TYPE;
        block20: {
            tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB;
            try {
                AuthorEditorAccess authorEditorAccess = this.authorAccess.getEditorAccess();
                SelectionInterpretationMode selectionInterpretationMode = authorEditorAccess.getAuthorSelectionModel().getSelectionInterpretationMode();
                if (selectionInterpretationMode != null) {
                    if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN) {
                        tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.COLUMN_TAB;
                    } else if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_ROW) {
                        tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
                    }
                    break block20;
                }
                if (list.size() == 1 && list.get(0)[0].intValue() == list.get(0)[1].intValue()) {
                    AuthorNode authorNode = this.authorAccess.getDocumentController().getNodeAtOffset(list.get(0)[0]);
                    if (authorNode instanceof AuthorElement) {
                        if (this.tableHelper.isTableCell((AuthorElement)authorNode)) {
                            tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB;
                        } else if (this.tableHelper.isTableRow((AuthorElement)authorNode)) {
                            tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
                        }
                    }
                    break block20;
                }
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Integer[] integerArray = list.get(i2);
                    AuthorNode authorNode = authorEditorAccess.getFullySelectedNode(authorEditorAccess.getBalancedSelection(integerArray[0], integerArray[1])[0], authorEditorAccess.getBalancedSelection(integerArray[0], integerArray[1])[1]);
                    if (authorNode instanceof AuthorElement) {
                        tAB_TYPE = this.getTabType((AuthorElement)authorNode);
                        if (tAB_TYPE != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) continue;
                        break;
                    }
                    List<AuthorNode> list2 = this.authorAccess.getDocumentController().getNodesToSelect(authorEditorAccess.getBalancedSelection(integerArray[0], integerArray[1])[0], authorEditorAccess.getBalancedSelection(integerArray[0], integerArray[1])[1]);
                    for (int i3 = 0; i3 < list2.size(); ++i3) {
                        AuthorElement authorElement;
                        AuthorNode authorNode2 = list2.get(i3);
                        if (!(authorNode2 instanceof AuthorElement)) continue;
                        AuthorElement authorElement2 = (AuthorElement)authorNode2;
                        tAB_TYPE = this.getTabType(authorElement2);
                        if (tAB_TYPE == EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) break block20;
                        ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
                        if (tAB_TYPE != EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB) {
                            ArrayList<AuthorElement> arrayList2 = new ArrayList<AuthorElement>();
                            authorElement = TableOperationsUtil.getElementAncestor(authorElement2, 5, this.tableHelper);
                            TableOperationsUtil.getChildElements(authorElement, 0, arrayList, this.tableHelper);
                            TableOperationsUtil.computeElementsList(arrayList2, authorElement, authorEditorAccess.getBalancedSelection(integerArray[0], integerArray[1])[0], authorEditorAccess.getBalancedSelection(integerArray[0], integerArray[1])[1], 0, true, this.tableHelper);
                            if (arrayList.size() > arrayList2.size()) {
                                tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
                                arrayList = new ArrayList();
                                TableOperationsUtil.computeElementsList(arrayList, authorElement, integerArray[0], integerArray[1], 0, false, this.tableHelper);
                            }
                        }
                        if (!arrayList.isEmpty()) {
                            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                                authorElement = (AuthorElement)arrayList.get(i4);
                                tAB_TYPE = this.checkForCellTab(authorElement, integerArray[0], integerArray[1], tAB_TYPE);
                                if (tAB_TYPE != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) {
                                    continue;
                                }
                                break block20;
                            }
                            continue;
                        }
                        tAB_TYPE = this.checkForCellTab(authorElement2, integerArray[0], integerArray[1], tAB_TYPE);
                        if (tAB_TYPE != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) {
                            continue;
                        }
                        break block20;
                    }
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug(throwable.getMessage(), throwable);
            }
        }
        return tAB_TYPE;
    }

    private EditedTablePropertiesInfo.TAB_TYPE checkForCellTab(AuthorElement authorElement, int n2, int n3, EditedTablePropertiesInfo.TAB_TYPE tAB_TYPE) {
        ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
        TableOperationsUtil.getChildElements(authorElement, 6, arrayList, this.tableHelper);
        ArrayList<AuthorElement> arrayList2 = new ArrayList<AuthorElement>();
        TableOperationsUtil.computeElementsList(arrayList2, authorElement, n2, n3, 6, true, this.tableHelper);
        if (!arrayList2.isEmpty() && arrayList.size() > arrayList2.size()) {
            tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB;
        }
        return tAB_TYPE;
    }

    private EditedTablePropertiesInfo.TAB_TYPE getTabType(AuthorElement authorElement) {
        EditedTablePropertiesInfo.TAB_TYPE tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB;
        if (this.tableHelper.isNodeOfType(authorElement, 6)) {
            tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB;
        } else if (this.tableHelper.isNodeOfType(authorElement, 0)) {
            tAB_TYPE = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
        }
        return tAB_TYPE;
    }

    protected abstract List<TabInfo> getCategoriesAndProperties(List<Integer[]> var1);

    protected abstract List<TableProperty> getTableAttribute();

    protected abstract boolean computeFragmentsToMoveInsideFooter(List<AuthorDocumentFragment> var1, List<Position> var2, TabInfo var3, List<AuthorElement> var4, AuthorElement var5) throws AuthorOperationException;

    protected abstract boolean computeFragmentMoveInsideHeader(List<AuthorDocumentFragment> var1, List<Position> var2, TabInfo var3, List<AuthorElement> var4, AuthorElement var5) throws AuthorOperationException;

    protected abstract boolean computeFragmentsToMoveInsideBody(List<AuthorDocumentFragment> var1, List<Position> var2, TabInfo var3, List<AuthorElement> var4, AuthorElement var5) throws AuthorOperationException;

    protected String getHelpPageID() {
        return null;
    }
}

