/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.ECPropertyComposite;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.exml.workspace.api.util.ColorThemeUtilities;
import ro.sync.util.Resource;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECPropertiesComposite
extends Composite
implements PropertySelectionController {
    private static final Logger logger = LoggerFactory.getLogger((String)ECPropertiesComposite.class.getName());
    private final List<ECPropertyComposite> propertyPanels = new ArrayList<ECPropertyComposite>();
    private final Map<String, PreviewGroup> previewsList = new HashMap<String, PreviewGroup>();
    private final Map<String, Composite> groupsList = new HashMap<String, Composite>();
    private final Map<URL, Image> images = new HashMap<URL, Image>();
    private final AuthorResourceBundle authorResourceBundle;
    private ColorThemeUtilities colorThemeUtilities;

    public ECPropertiesComposite(TabFolder tabFolder, List<TableProperty> list, String string, AuthorResourceBundle authorResourceBundle, ColorThemeUtilities colorThemeUtilities) {
        super((Composite)tabFolder, 0);
        ArrayList arrayList;
        Object object3;
        Object object2;
        this.authorResourceBundle = authorResourceBundle;
        this.colorThemeUtilities = colorThemeUtilities;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 8;
        this.setLayout((Layout)gridLayout);
        this.setBackgroundMode(2);
        if (!colorThemeUtilities.getColorTheme().isHighContrastTheme()) {
            this.setBackground(Display.getDefault().getSystemColor(1));
        }
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 340;
        this.setLayoutData(gridData);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = list.get(i2);
            object3 = ((TableProperty)object2).getParentGroup();
            arrayList = (ArrayList)linkedHashMap.get(object3);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(object2);
            linkedHashMap.put(object3, arrayList);
        }
        Set set = linkedHashMap.keySet();
        for (Object object3 : set) {
            if (((List)linkedHashMap.get(object3)).size() == 1 && ((TableProperty)((List)linkedHashMap.get(object3)).get(0)).getGuiType() == GuiElements.COMBOBOX) {
                this.groupsList.put((String)object3, new Composite((Composite)this, 0));
            } else {
                this.groupsList.put((String)object3, (Composite)new Group((Composite)this, 16));
            }
            this.previewsList.put((String)object3, new PreviewGroup(this, 16, colorThemeUtilities));
        }
        object2 = linkedHashMap.keySet();
        object3 = object2.iterator();
        while (object3.hasNext()) {
            arrayList = (String)object3.next();
            List list2 = (List)linkedHashMap.get(arrayList);
            this.addGroup((String)((Object)arrayList), list2);
        }
        if (string != null) {
            object3 = new Label((Composite)this, 16384);
            gridData = new GridData(4, 0, true, false);
            gridData.horizontalIndent = 8;
            gridData.verticalIndent = 8;
            object3.setLayoutData((Object)gridData);
            object3.setText(string);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                for (Image image : ECPropertiesComposite.this.images.values()) {
                    image.dispose();
                }
                ECPropertiesComposite.this.images.clear();
            }
        });
    }

    public List<TableProperty> getModifiedProperties() {
        ArrayList<TableProperty> arrayList = new ArrayList<TableProperty>();
        for (int i2 = 0; i2 < this.propertyPanels.size(); ++i2) {
            TableProperty tableProperty = this.propertyPanels.get(i2).getModifiedProperty();
            if (tableProperty == null) continue;
            arrayList.add(tableProperty);
        }
        return arrayList;
    }

    private void addGroup(String string, List<TableProperty> list) {
        Composite composite = this.groupsList.get(string);
        if (composite instanceof Group) {
            ((Group)composite).setText(this.authorResourceBundle.getMessage(string));
        }
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        if (!(composite instanceof Group)) {
            gridData.horizontalIndent = 3;
        }
        composite.setLayoutData((Object)gridData);
        int n2 = 1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).getGuiType() == GuiElements.COMBOBOX) {
                n2 = 2;
            }
            gridLayout.numColumns = n2;
            ECPropertyComposite eCPropertyComposite = new ECPropertyComposite(composite, list.get(i2), this.authorResourceBundle, this, i2 == 0);
            this.propertyPanels.add(eCPropertyComposite);
        }
        composite.pack(true);
        gridData = new GridData(0, 0, false, false);
        gridData.widthHint = 150;
        gridData.horizontalAlignment = 64;
        gridData.verticalAlignment = 4;
        this.previewsList.get(string).setLayoutData(gridData);
    }

    @Override
    public void selectionChanged(TableProperty tableProperty, String string) throws AuthorOperationException {
        ECPropertyComposite eCPropertyComposite;
        int n2;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = tableProperty.getParentGroup();
        if ("colsep".equalsIgnoreCase(tableProperty.getAttributeName()) || "rowsep".equalsIgnoreCase(tableProperty.getAttributeName())) {
            object2 = "<not set>";
            object = "<not set>";
            boolean bl = true;
            if ("colsep".equalsIgnoreCase(tableProperty.getAttributeName())) {
                object2 = string;
            } else {
                object = string;
                bl = false;
            }
            for (n2 = 0; n2 < this.propertyPanels.size(); ++n2) {
                eCPropertyComposite = this.propertyPanels.get(n2);
                if (bl && "rowsep".equalsIgnoreCase(eCPropertyComposite.getTableProperty().getAttributeName())) {
                    object = eCPropertyComposite.getCurrentlySelectedValue();
                    continue;
                }
                if (bl || !"colsep".equalsIgnoreCase(eCPropertyComposite.getTableProperty().getAttributeName())) continue;
                object2 = eCPropertyComposite.getCurrentlySelectedValue();
            }
            if ("1".equals(object2) && "1".equals(object)) {
                stringBuilder.append("/images/table-properties/ColRowSep.png");
            } else if ("1".equals(object2)) {
                stringBuilder.append("/images/table-properties/ColSep.png");
            } else if ("1".equals(object)) {
                stringBuilder.append("/images/table-properties/RowSep.png");
            } else {
                stringBuilder.append("/images/table-properties/EmptyIcon.png");
            }
        } else {
            object2 = null;
            object2 = tableProperty.getIcons().get(string);
            if (object2 != null) {
                stringBuilder.append((String)object2);
            } else {
                stringBuilder.append("/images/table-properties/EmptyIcon.png");
            }
        }
        object2 = this.previewsList.get(string2);
        if (object2 != null) {
            object = Resource.getResource(stringBuilder.toString());
            Image image = this.images.get(object);
            if (image == null) {
                n2 = 1;
                if (this.colorThemeUtilities.getColorTheme().isHighContrastTheme() && !this.colorThemeUtilities.getColorTheme().isHighContrastWhiteTheme()) {
                    try {
                        eCPropertyComposite = (ImageDescriptor)this.colorThemeUtilities.getImageInverter().loadImage((URL)object);
                        eCPropertyComposite = (ImageDescriptor)this.colorThemeUtilities.getImageInverter().invertImage(eCPropertyComposite);
                        image = eCPropertyComposite.createImage();
                        n2 = 0;
                    }
                    catch (IOException iOException) {
                        logger.error((Object)iOException, (Throwable)iOException);
                    }
                }
                if (n2 != 0) {
                    eCPropertyComposite = ImageDescriptor.createFromURL((URL)object);
                    image = eCPropertyComposite.createImage();
                }
                this.images.put((URL)object, image);
            }
            ((PreviewGroup)((Object)object2)).setPreviewImage(image);
            object2.redraw();
        }
    }

    class PreviewGroup
    extends Group {
        Label previewLabel;

        public PreviewGroup(Composite composite, int n2, ColorThemeUtilities colorThemeUtilities) {
            Object object;
            super(composite, n2);
            this.previewLabel = null;
            this.setText(ECPropertiesComposite.this.authorResourceBundle.getMessage("Preview"));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            this.setLayout((Layout)gridLayout);
            this.previewLabel = new Label((Composite)this, 0x1000000);
            this.previewLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            URL uRL = Resource.getResource("/images/table-properties/EmptyIcon.png");
            Image image = null;
            boolean bl = true;
            if (colorThemeUtilities.getColorTheme().isHighContrastTheme() && !colorThemeUtilities.getColorTheme().isHighContrastWhiteTheme()) {
                try {
                    object = colorThemeUtilities.getImageInverter().loadImage(uRL);
                    ImageDescriptor imageDescriptor = (ImageDescriptor)colorThemeUtilities.getImageInverter().invertImage(object);
                    image = imageDescriptor.createImage();
                    bl = false;
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, (Throwable)iOException);
                }
            }
            if (bl) {
                object = ImageDescriptor.createFromURL((URL)uRL);
                image = object.createImage();
            }
            ECPropertiesComposite.this.images.put(uRL, image);
            this.previewLabel.setImage(image);
        }

        public Label getPreviewLabel() {
            return this.previewLabel;
        }

        public void setPreviewImage(Image image) {
            this.previewLabel.setImage(image);
        }

        protected void checkSubclass() {
        }
    }
}

