/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SplitCellAboveBelowOperationBase
extends AbstractTableOperation {
    private static final String SPLIT_ABOVE = "Above";
    private static final String SPLIT_BELOW = "Below";
    private static final String ARGUMENT_NAME = "Split point";

    public SplitCellAboveBelowOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        try {
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
            AuthorElement authorElement = this.getElementAncestor(authorNode, 0);
            if (authorElement == null) {
                AuthorOperationException authorOperationException = new AuthorOperationException("The caret must be inside a table cell.");
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            String string = (String)argumentsMap.getArgumentValue(ARGUMENT_NAME);
            this.splitCell(authorElement, authorAccess, SPLIT_ABOVE.equals(string));
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void splitCell(AuthorElement authorElement, AuthorAccess authorAccess, boolean bl) throws AuthorOperationException, BadLocationException {
        int n2;
        AuthorElement authorElement2 = this.getElementAncestor(authorElement, 2);
        if (authorElement2 == null) throw new AuthorOperationException("The table cell must be inside a table element.");
        AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement2);
        Integer n3 = authorTableCellSpanProvider.getRowSpan(authorElement);
        int n4 = n2 = n3 != null ? n3 : 1;
        if (n2 <= 1) throw new AuthorOperationException("The cell you are trying to split does not span over multiple rows.");
        int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement);
        if (nArray == null) throw new AuthorOperationException("Invalid table. Could not determine the location of the cell.");
        if (!bl) {
            int n5 = this.findCellInsertionOffset(authorAccess, authorElement2, nArray[0] + n2 - 1, nArray[1]);
            if (n5 == -1) throw new AuthorOperationException("Could not determine the location where the split will occur.");
            AuthorDocumentFragment authorDocumentFragment = this.createEmptyCell(authorAccess, authorElement, this.getIgnoredAttributes());
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            authorDocumentController.insertFragment(n5, authorDocumentFragment);
            authorAccess.getEditorAccess().setCaretPosition(n5 + 1);
            this.tableHelper.updateTableRowSpan(authorAccess, authorElement, n2 - 1);
            return;
        } else {
            int n6 = this.findCellInsertionOffset(authorAccess, authorElement2, nArray[0] + 1, nArray[1]);
            if (n6 == -1) throw new AuthorOperationException("Could not determine the location where the split will occur.");
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            this.tableHelper.updateTableRowSpan(authorAccess, authorElement, n2 - 1);
            AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(authorElement, true);
            authorDocumentController.insertFragment(n6, authorDocumentFragment);
            SplitCellAboveBelowOperationBase.clearCell(authorAccess, authorElement, this.getIgnoredAttributes());
            authorAccess.getEditorAccess().setCaretPosition(authorElement.getStartOffset() + 1);
        }
    }

    private static void clearCell(AuthorAccess authorAccess, AuthorElement authorElement, String[] stringArray) {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            authorDocumentController.removeAttribute(stringArray[i2], authorElement);
        }
        if (authorElement.getStartOffset() + 1 < authorElement.getEndOffset()) {
            authorDocumentController.delete(authorElement.getStartOffset() + 1, authorElement.getEndOffset() - 1);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ARGUMENT_NAME, 3, "The location relative to the source cell for the newly split cell.", new String[]{SPLIT_ABOVE, SPLIT_BELOW}, SPLIT_ABOVE)};
    }

    @Override
    public String getDescription() {
        return "This operation splits the content of a table cell that spans over multiple rows.";
    }

    protected abstract String[] getIgnoredAttributes();
}

