/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class SurroundWithFragmentOperation
implements AuthorOperation {
    private static final String ARGUMENT_NAME = "fragment";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("fragment", 1, "The fragment to surround with. The first leaf will be the destination of the text to surround.\n\nIf the first leaf is not the desired location for the surrounded fragment, you can use the \"InsertOrReplaceFragmentOperation\" operation and set the folllowing arguments:\n - fragment: The XML fragment that will surround the selection. Use the ${selection} editor variable in the location you want to place the surrounded fragment.\n - schemaAware: Set to false, to avoid moving the fragment if it is not valid at the given location."), new ArgumentDescriptor("schemaAware", 3, "Controlling if the insertion is schema aware or not. When the schema aware is enabled and the fragments insertion is not allowed a dialog will be shown, proposing solutions, like:\n - insert the fragments inside a new element. The name of the element to wrap the fragments in is computed by analyzing the left or right siblings;\n - split an ancestor of the node at insertion offset and insert the fragments between the resulted elements;\n - insert the fragments somewhere in the proximity of the insertion offset(left or right without skipping content);\nNote: if a selection exists the surround with fragment operation is not schema aware.\nCan be: true, false. Default value is true.", new String[]{"true", "false"}, "true")};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_NAME);
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("The argument value was not defined, it is " + object);
        }
        Object object2 = argumentsMap.getArgumentValue("schemaAware");
        boolean bl = !"false".equals(object2);
        CommonsOperationsUtil.surroundWithFragment(authorAccess, bl, (String)object);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Surround the selected text with a document fragment. If there is no selection the fragment will be inserted at the current position.";
    }
}

