/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.ClassPathResourcesAccess;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.UniqueAttributesProcessor;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class CommonsOperationsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)CommonsOperationsUtil.class.getName());

    private CommonsOperationsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static Map<String, String> getAttributes(AuthorNode authorNode, boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = null;
        if (authorNode instanceof AuthorElement) {
            AuthorElement authorElement = (AuthorElement)authorNode;
            int n2 = authorElement.getAttributesCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = authorElement.getAttributeAtIndex(i2);
                AttrValue attrValue = authorElement.getAttribute(string);
                if (!attrValue.isSpecified()) continue;
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, String>();
                }
                if (!bl && ("id".equals(string) || "xml:id".equals(string))) continue;
                linkedHashMap.put(string, attrValue.getValue());
            }
        }
        return linkedHashMap;
    }

    public static String serializeAttributes(Map<String, String> map, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            if (collection.contains(string)) continue;
            String string2 = entry.getValue();
            stringBuilder.append(" ").append(string).append("=\"").append(string2).append("\"");
        }
        return stringBuilder.toString();
    }

    private static AuthorDocumentFragment createAuthorDocumentFragment(AuthorDocumentController authorDocumentController, int n2, int n3, ConversionElementHelper conversionElementHelper) throws BadLocationException, AuthorOperationException {
        AuthorDocumentFragment authorDocumentFragment = conversionElementHelper.createAuthorDocumentFragment(authorDocumentController, n2, n3);
        if (authorDocumentFragment == null) {
            authorDocumentFragment = n2 <= n3 ? authorDocumentController.createDocumentFragment(n2, n3) : authorDocumentController.createNewDocumentFragmentInContext("", n2);
        }
        return authorDocumentFragment;
    }

    public static void unwrapTags(AuthorAccess authorAccess, AuthorNode authorNode) throws BadLocationException {
        if (authorNode != null && authorNode != authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement()) {
            boolean bl;
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            int n3 = authorNode.getStartOffset();
            int n4 = authorNode.getEndOffset();
            int n5 = n2 <= n3 ? n2 : (n2 <= n4 ? n2 - 1 : n2 - 2);
            int n6 = authorNode.getStartOffset() + 1;
            int n7 = authorNode.getEndOffset() - 1;
            AuthorDocumentFragment authorDocumentFragment = null;
            if (n6 <= n7) {
                authorDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(n6, n7);
            }
            if ((bl = authorAccess.getDocumentController().deleteNode(authorNode)) && authorDocumentFragment != null) {
                authorAccess.getDocumentController().insertFragment(n3, authorDocumentFragment);
                authorAccess.getEditorAccess().setCaretPosition(n5);
            }
        }
    }

    public static void surroundWithFragment(AuthorAccess authorAccess, boolean bl, String string) throws AuthorOperationException {
        int n2;
        boolean bl2 = MoveCaretUtil.hasImposedEditorVariableCaretOffset(string);
        int n3 = n2 = authorAccess.getEditorAccess().hasSelection() ? Math.min(authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd()) : authorAccess.getEditorAccess().getCaretOffset();
        if (authorAccess.getEditorAccess().hasSelection()) {
            CommonsOperationsUtil.surroundWithFragment(authorAccess, string, authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
        } else {
            int n4 = authorAccess.getEditorAccess().getCaretOffset();
            if (!bl) {
                authorAccess.getDocumentController().insertXMLFragment(string, n4);
            } else {
                Integer n5;
                SchemaAwareHandlerResult schemaAwareHandlerResult = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string, n4);
                if (schemaAwareHandlerResult != null && (n5 = (Integer)schemaAwareHandlerResult.getResult("result.id.handle.insert.fragment.offset")) != null) {
                    n2 = n5;
                }
            }
        }
        if (bl2) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, n2);
        }
    }

    public static int surroundWithFragment(AuthorAccess authorAccess, String string, int n2, int n3) throws AuthorOperationException {
        int[] nArray = authorAccess.getEditorAccess().getBalancedSelection(n2, n3 + 1);
        authorAccess.getDocumentController().surroundInFragment(string, nArray[0], nArray[1] - 1);
        return authorAccess.getEditorAccess().getSelectionStart();
    }

    public static String setAttributeValue(AuthorDocumentController authorDocumentController, AuthorElement authorElement, QName qName, String string, boolean bl) {
        return CommonsOperationsUtil.setAttributeValue(authorDocumentController, authorElement, qName, string, string, bl);
    }

    public static String setAttributeValue(AuthorDocumentController authorDocumentController, AuthorElement authorElement, QName qName, String string, String string2, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = qName.getLocalPart();
        String string3 = null;
        String string4 = qName.getNamespaceURI();
        if (string4 != null && !"".equals(string4)) {
            object = CommonsOperationsUtil.getAttributeQName(authorElement, qName.getLocalPart(), qName.getNamespaceURI());
            if (object != null) {
                object2 = object;
            } else {
                NamespaceContext namespaceContext = authorElement.getNamespaceContext();
                string3 = namespaceContext.getPrefixForNamespace(string4);
                if (string3 != null && !"".equals(string3)) {
                    object2 = string3 + ":" + (String)object2;
                } else if (qName.getPrefix() != null && !qName.getPrefix().isEmpty() && namespaceContext.getNamespaceForPrefix(qName.getPrefix()) == null) {
                    string3 = qName.getPrefix();
                    bl2 = true;
                    object2 = string3 + ":" + (String)object2;
                } else {
                    string3 = CommonsOperationsUtil.buildFreshPrefix(namespaceContext);
                    bl2 = true;
                    object2 = string3 + ":" + (String)object2;
                }
            }
        }
        if (string == null || "".equals(string) && bl) {
            if (!bl2) {
                authorDocumentController.removeAttribute((String)object2, authorElement);
            }
        } else {
            if (bl2) {
                object = new AttrValue(string4);
                authorDocumentController.setAttribute("xmlns:" + string3, (AttrValue)object, authorElement);
            }
            object = new AttrValue(string2, string, true);
            authorDocumentController.setAttribute((String)object2, (AttrValue)object, authorElement);
        }
        return object2;
    }

    private static String getAttributeQName(AuthorElement authorElement, String string, String string2) {
        String string3 = null;
        int n2 = authorElement.getAttributesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4 = authorElement.getAttributeAtIndex(i2);
            if (!string.equals(CommonsOperationsUtil.getLocalName(string4))) continue;
            String string5 = authorElement.getAttributeNamespace(CommonsOperationsUtil.getPrefix(string4));
            if ((string2 != null || string5 != null) && (string2 == null || !string2.equals(string5))) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    public static String buildFreshPrefix(NamespaceContext namespaceContext) {
        String string = null;
        int n2 = 1;
        while (namespaceContext.getNamespaceForPrefix("ns" + n2) != null) {
            ++n2;
        }
        string = "ns" + n2;
        return string;
    }

    public static URL locateResourceInClasspath(AuthorAccess authorAccess, String string) {
        return CommonsOperationsUtil.locateResourceInClasspathFolder(authorAccess, "resources", string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URL locateResourceInClasspathFolder(AuthorAccess authorAccess, String string, String string2) {
        Object object;
        URL uRL;
        int n2;
        URL[] uRLArray;
        URL uRL2 = null;
        ClassPathResourcesAccess classPathResourcesAccess = authorAccess.getClassPathResourcesAccess();
        if (classPathResourcesAccess == null || (uRLArray = classPathResourcesAccess.getClassPathResources()) == null) return uRL2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (n2 = 0; n2 < uRLArray.length; ++n2) {
            uRL = uRLArray[n2];
            object = uRL.toExternalForm();
            if (!((String)object).endsWith("/" + string + "/") && !((String)object).endsWith("/" + string)) continue;
            try {
                arrayList.add(new URL(uRL, string2));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty()) return uRL2;
        uRL2 = (URL)arrayList.get(0);
        if (arrayList.size() <= 1) return uRL2;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            uRL = (URL)arrayList.get(n2);
            try {
                object = uRL.openStream();
                try {
                    ((InputStream)object).read();
                    uRL2 = uRL;
                    return uRL2;
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return uRL2;
    }

    public static URL expandAndResolvePath(AuthorAccess authorAccess, String string) {
        URL uRL;
        URL uRL2;
        block12: {
            uRL2 = null;
            String string2 = authorAccess.getUtilAccess().expandEditorVariables(string, null);
            try {
                uRL2 = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                Object object;
                try {
                    object = new File(string2);
                    if (((File)object).exists()) {
                        uRL2 = authorAccess.getUtilAccess().convertFileToURL((File)object);
                    }
                }
                catch (MalformedURLException malformedURLException2) {
                }
                catch (AccessControlException accessControlException) {
                    logger.debug("Cannot access the path: " + string, (Throwable)accessControlException);
                }
                if (uRL2 != null) break block12;
                try {
                    object = authorAccess.getUtilAccess().expandEditorVariables("${frameworkDir}", null);
                    File file = new File((String)object, string2);
                    if (file.exists()) {
                        uRL2 = authorAccess.getUtilAccess().convertFileToURL(file);
                    }
                }
                catch (MalformedURLException malformedURLException3) {
                }
                catch (AccessControlException accessControlException) {
                    logger.debug("Cannot access the path: " + string, (Throwable)accessControlException);
                }
            }
        }
        if (uRL2 != null && (uRL = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(null, uRL2.toString(), true, true)) != null) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static String getPrefix(String string) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(58);
            string2 = "";
            if (n2 != -1) {
                string2 = string.substring(0, n2);
            }
        }
        return string2;
    }

    public static String getLocalName(String string) {
        int n2;
        String string2 = string;
        if (string != null && (n2 = string.lastIndexOf(58)) != -1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    public static void removeUnwantedAttributes(String[] stringArray, AuthorDocumentFragment authorDocumentFragment, AuthorDocumentController authorDocumentController) {
        AuthorNode authorNode;
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list != null && !list.isEmpty() && (authorNode = list.get(0)).getType() == 0) {
            UniqueAttributesProcessor uniqueAttributesProcessor;
            AuthorElement authorElement = (AuthorElement)authorNode;
            HashSet<String> hashSet = new HashSet<String>();
            if (stringArray != null) {
                hashSet.addAll(Arrays.asList(stringArray));
            }
            if ((uniqueAttributesProcessor = authorDocumentController.getUniqueAttributesProcessor()) != null) {
                int n2 = authorElement.getAttributesCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = authorElement.getAttributeAtIndex(i2);
                    if (uniqueAttributesProcessor.copyAttributeOnSplit(string, authorElement)) continue;
                    hashSet.add(string);
                }
            }
            if (!hashSet.isEmpty()) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    authorElement.removeAttribute((String)iterator.next());
                }
            }
        }
    }

    public static List<Position> removeCurrentSelection(AuthorAccess authorAccess) {
        List<Position> list = new ArrayList<Position>();
        if (authorAccess.getEditorAccess().hasSelection()) {
            List<ContentInterval> list2 = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            list = CommonsOperationsUtil.removeIntervals(authorAccess, list2);
        }
        return list;
    }

    public static List<Position> removeIntervals(AuthorAccess authorAccess, List<ContentInterval> list) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        if (list != null) {
            if (list.size() > 1) {
                Collections.sort(list, new Comparator<ContentInterval>(){

                    @Override
                    public int compare(ContentInterval contentInterval, ContentInterval contentInterval2) {
                        int n2 = 0;
                        if (contentInterval != null && contentInterval2 != null) {
                            n2 = contentInterval.getStartOffset() > contentInterval2.getStartOffset() ? -1 : 1;
                        }
                        return n2;
                    }
                });
            }
            try {
                for (ContentInterval contentInterval : list) {
                    int[] nArray = authorAccess.getEditorAccess().getBalancedSelection(contentInterval.getStartOffset(), contentInterval.getEndOffset());
                    authorAccess.getDocumentController().delete(nArray[0], nArray[1] - 1);
                    AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(nArray[0]);
                    if (authorNode == null || authorNode == authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement() || authorNode.getStartOffset() + 1 != authorNode.getEndOffset()) continue;
                    arrayList.add(authorAccess.getDocumentController().createPositionInContent(authorNode.getStartOffset()));
                }
            }
            catch (Exception exception) {
                logger.debug(exception.getMessage(), (Throwable)exception);
            }
        }
        return arrayList;
    }

    public static List<SelectedFragmentInfo> getSelectedFragmentsForConversions(AuthorAccess authorAccess, ConversionElementHelper conversionElementHelper) throws AuthorOperationException {
        List<SelectedFragmentInfo> list = null;
        if (authorAccess.getEditorAccess().hasSelection()) {
            List<ContentInterval> list2 = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            try {
                list = CommonsOperationsUtil.getFragmentsForConversions(authorAccess, conversionElementHelper, list2);
            }
            catch (BadLocationException badLocationException) {
                logger.debug((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return list;
    }

    public static List<SelectedFragmentInfo> getFragmentsForConversions(AuthorAccess authorAccess, ConversionElementHelper conversionElementHelper, List<ContentInterval> list) throws BadLocationException, AuthorOperationException {
        ArrayList<SelectedFragmentInfo> arrayList = new ArrayList<SelectedFragmentInfo>();
        for (ContentInterval contentInterval : list) {
            arrayList.addAll(CommonsOperationsUtil.getFragmentsForConversions(authorAccess, conversionElementHelper, contentInterval));
        }
        return arrayList;
    }

    private static List<SelectedFragmentInfo> getFragmentsForConversions(AuthorAccess authorAccess, ConversionElementHelper conversionElementHelper, ContentInterval contentInterval) throws BadLocationException, AuthorOperationException {
        ArrayList<SelectedFragmentInfo> arrayList = new ArrayList<SelectedFragmentInfo>();
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        int n2 = contentInterval.getStartOffset();
        int n3 = contentInterval.getEndOffset();
        Segment segment = new Segment();
        int n4 = n3 - contentInterval.getStartOffset();
        authorDocumentController.getChars(n2, n4, segment);
        AuthorNode authorNode = null;
        char c2 = segment.first();
        int n5 = contentInterval.getStartOffset();
        int n6 = n2;
        while (c2 != '\uffff') {
            boolean bl;
            boolean bl2 = bl = n5 == n6;
            if (c2 == '\u0000') {
                OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n6);
                AuthorNode authorNode2 = offsetInformation.getNodeForMarkerOffset();
                Styles styles = authorAccess.getEditorAccess().getStyles(authorNode2);
                String string = styles.getDisplay();
                if (("block".equals(string) || "list-item".equals(string)) && conversionElementHelper.blockContentMustBeConverted(authorNode2, authorAccess)) {
                    arrayList.addAll(CommonsOperationsUtil.finishCurrentFragment(n5, n6, conversionElementHelper, authorDocumentController));
                    if ("list-item".equals(string) && authorNode2.getStartOffset() == n6 && authorNode2.getEndOffset() <= contentInterval.getEndOffset()) {
                        arrayList.add(CommonsOperationsUtil.getFragmentForNode(authorNode2, conversionElementHelper, authorDocumentController));
                        segment.setIndex(segment.getIndex() + authorNode2.getEndOffset() - authorNode2.getStartOffset());
                        n6 = authorNode2.getEndOffset();
                    } else if (bl && authorNode != authorNode2 && authorNode2.getStartOffset() + 1 == authorNode2.getEndOffset()) {
                        authorNode = authorNode2;
                        arrayList.add(CommonsOperationsUtil.getFragmentForNode(authorNode2, conversionElementHelper, authorDocumentController));
                    }
                    n5 = n6 + 1;
                }
            }
            c2 = segment.next();
            ++n6;
        }
        if (n5 < n3) {
            AuthorDocumentFragment authorDocumentFragment = CommonsOperationsUtil.createAuthorDocumentFragment(authorDocumentController, n5, n3 - 1, conversionElementHelper);
            arrayList.add(new SelectedFragmentInfo(authorDocumentFragment, null));
        }
        return arrayList;
    }

    private static SelectedFragmentInfo getFragmentForNode(AuthorNode authorNode, ConversionElementHelper conversionElementHelper, AuthorDocumentController authorDocumentController) throws BadLocationException, AuthorOperationException {
        AuthorDocumentFragment authorDocumentFragment = CommonsOperationsUtil.createAuthorDocumentFragment(authorDocumentController, authorNode.getStartOffset() + 1, authorNode.getEndOffset() - 1, conversionElementHelper);
        Map<String, String> map = CommonsOperationsUtil.getAttributes(authorNode, true);
        return new SelectedFragmentInfo(authorDocumentFragment, map);
    }

    private static List<SelectedFragmentInfo> finishCurrentFragment(int n2, int n3, ConversionElementHelper conversionElementHelper, AuthorDocumentController authorDocumentController) throws BadLocationException, AuthorOperationException {
        if (n2 == n3) {
            return Collections.emptyList();
        }
        AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n3);
        boolean bl = n2 <= authorNode.getStartOffset() + 1 && n3 >= authorNode.getEndOffset();
        AuthorDocumentFragment authorDocumentFragment = CommonsOperationsUtil.createAuthorDocumentFragment(authorDocumentController, n2, n3 - 1, conversionElementHelper);
        Map<String, String> map = CommonsOperationsUtil.getAttributes(authorNode, bl);
        return Collections.singletonList(new SelectedFragmentInfo(authorDocumentFragment, map));
    }

    public static void removeEmptyElements(AuthorAccess authorAccess, Collection<Position> collection) {
        if (!collection.isEmpty()) {
            for (Position position : collection) {
                try {
                    AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(position.getOffset() + 1);
                    while (authorNode != null && authorNode != authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement()) {
                        if (authorNode.getStartOffset() + 1 == authorNode.getEndOffset()) {
                            AuthorNode authorNode2 = authorNode.getParent();
                            authorAccess.getDocumentController().deleteNode(authorNode);
                            authorNode = authorNode2;
                            continue;
                        }
                        authorNode = null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    logger.debug(badLocationException.getMessage(), (Throwable)badLocationException);
                }
            }
        }
    }

    public static boolean isAllowedElement(String string, int n2, AuthorSchemaManager authorSchemaManager) throws BadLocationException {
        boolean bl = false;
        if (authorSchemaManager != null) {
            List<CIElement> list;
            WhatElementsCanGoHereContext whatElementsCanGoHereContext = authorSchemaManager.createWhatElementsCanGoHereContext(n2);
            if (whatElementsCanGoHereContext != null && (list = authorSchemaManager.whatElementsCanGoHere(whatElementsCanGoHereContext)) != null) {
                for (CIElement cIElement : list) {
                    if (!string.equals(cIElement.getName())) continue;
                    bl = true;
                    break;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public static abstract class ConversionElementHelper {
        public abstract boolean blockContentMustBeConverted(AuthorNode var1, AuthorAccess var2) throws AuthorOperationException;

        public AuthorDocumentFragment createAuthorDocumentFragment(AuthorDocumentController authorDocumentController, int n2, int n3) throws AuthorOperationException, BadLocationException {
            return null;
        }
    }

    public static class SelectedFragmentInfo {
        private AuthorDocumentFragment selectedFragment;
        private Map<String, String> attributes;

        public SelectedFragmentInfo(AuthorDocumentFragment authorDocumentFragment, Map<String, String> map) {
            this.selectedFragment = authorDocumentFragment;
            this.attributes = map;
        }

        public AuthorDocumentFragment getSelectedFragment() {
            return this.selectedFragment;
        }

        public void setSelectedFragment(AuthorDocumentFragment authorDocumentFragment) {
            this.selectedFragment = authorDocumentFragment;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> map) {
            this.attributes = map;
        }
    }
}

