/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class GenerateIDsOperation
implements AuthorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GenerateIDsOperation.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        UniqueAttributesRecognizer uniqueAttributesRecognizer = this.getUniqueAttributesRecognizer();
        if (uniqueAttributesRecognizer != null) {
            uniqueAttributesRecognizer.activated(authorAccess);
            if (authorAccess.getEditorAccess().hasSelection()) {
                List<ContentInterval> list = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
                AuthorNode authorNode = authorAccess.getDocumentController().getAuthorDocumentNode();
                int n2 = -1;
                int n3 = -1;
                authorAccess.getDocumentController().disableLayoutUpdate();
                try {
                    for (ContentInterval contentInterval : list) {
                        int n4 = contentInterval.getStartOffset();
                        int n5 = contentInterval.getEndOffset();
                        n2 = Math.min(n4, n2);
                        n3 = Math.max(n5, n3);
                        GenerateIDsOperation.generateIDs(authorAccess, uniqueAttributesRecognizer, n4, n5);
                    }
                }
                finally {
                    if (n3 != -1 && n2 != -1) {
                        try {
                            authorNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.debug(badLocationException.getMessage(), (Throwable)badLocationException);
                        }
                    }
                    authorAccess.getDocumentController().enableLayoutUpdate(authorNode);
                }
            }
            try {
                AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
                int n6 = authorNode.getStartOffset();
                int n7 = authorNode.getStartOffset();
                uniqueAttributesRecognizer.assignUniqueIDs(n6, n7, !authorAccess.getEditorAccess().hasSelection());
            }
            catch (BadLocationException badLocationException) {
                LOGGER.debug(badLocationException.getMessage(), (Throwable)badLocationException);
            }
        }
    }

    private static void generateIDs(AuthorAccess authorAccess, UniqueAttributesRecognizer uniqueAttributesRecognizer, int n2, int n3) {
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n3 - 1);
            if (n2 == authorNode.getStartOffset() && authorNode.getEndOffset() == n3 - 1) {
                uniqueAttributesRecognizer.assignUniqueIDs(n2, n2, true);
            } else {
                int[] nArray = authorAccess.getEditorAccess().getBalancedSelection(n2, n3);
                int n4 = nArray[0];
                int n5 = nArray[1];
                CharSequence charSequence = authorAccess.getDocumentController().getContentCharSequence();
                for (int i2 = 0; i2 < n5 - n4; ++i2) {
                    boolean bl;
                    char c2 = charSequence.charAt(n4 + i2);
                    boolean bl2 = bl = c2 == '\u0000';
                    if (!bl) continue;
                    int n6 = n4 + i2;
                    AuthorNode authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(n6 + 1);
                    if (authorNode2.getStartOffset() != n6) continue;
                    i2 += authorNode2.getEndOffset() - authorNode2.getStartOffset();
                    if (authorNode2.getEndOffset() > n5 - 1) continue;
                    uniqueAttributesRecognizer.assignUniqueIDs(n6, n6, true);
                }
            }
            uniqueAttributesRecognizer.assignUniqueIDs(n2, n3 - 1, false);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.debug(badLocationException.getMessage(), (Throwable)badLocationException);
        }
    }

    protected abstract UniqueAttributesRecognizer getUniqueAttributesRecognizer();

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Generate unique IDs on the selected content";
    }
}

