/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.ce;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.ce.DefaultSaveStrategy;
import ro.sync.ecss.extensions.api.webapp.ce.Room;
import ro.sync.ecss.extensions.api.webapp.ce.RoomCreatedListener;
import ro.sync.ecss.extensions.api.webapp.ce.RoomFactory;
import ro.sync.ecss.extensions.api.webapp.ce.RoomProxyCouldNotBeCreatedException;
import ro.sync.ecss.extensions.api.webapp.ce.SaveStrategy;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginLicensingException;
import ro.sync.exml.plugin.PluginManager;
import ro.sync.g.c;
import ro.sync.g.e.h;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class RoomsManager {
    private static final Logger logger = LoggerFactory.getLogger((String)RoomsManager.class.getName());
    public static final RoomsManager INSTANCE = new RoomsManager();
    static final String ROOM_EXTENSION_TYPE = "RoomFactory";
    public static final SaveStrategy DEFAULT_SAVE_STRATEGY = new DefaultSaveStrategy();
    private static final List<String> SHARED_CONTEXT_ATTRIBUTES = ImmutableList.builder().add((Object)"room-id").add((Object)"room-type").add((Object)"dita.val.url").add((Object)"dita.root.map.url").add((Object)"dita.context.guessed").add((Object)"KeyscopeStack").add((Object)"projectUrl").add((Object)"stylesheet-titles").add((Object)"editReferencesInPlace").build();
    private Optional<RoomFactory> roomFactory;
    private final List<RoomCreatedListener> roomCreatedListeners = new CopyOnWriteArrayList<RoomCreatedListener>();

    public String createRoomFromDocument(AuthorDocumentModel authorDocumentModel) {
        return this.createRoomFromDocument(authorDocumentModel, DEFAULT_SAVE_STRATEGY);
    }

    public String createRoomFromDocument(AuthorDocumentModel authorDocumentModel, SaveStrategy saveStrategy) {
        RoomsManager.checkLicense();
        EditingSessionContext editingSessionContext = authorDocumentModel.getAuthorAccess().getEditorAccess().getEditingContext();
        editingSessionContext.setAttribute("room's-creator", true);
        String string = this.getRoomFactoryOrThrow().createRoom(authorDocumentModel, saveStrategy);
        editingSessionContext.setAttribute("room-id", string);
        this.callRoomCreatedListeners(string);
        return string;
    }

    public Optional<Room> getRoom(String string) {
        if (string == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getRoomFactoryOrThrow().getRoom(string));
    }

    public Optional<Room> getRoomTryCreateProxy(String string) throws RoomProxyCouldNotBeCreatedException {
        if (string == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getRoomFactoryOrThrow().getRoomTryCreateProxy(string));
    }

    public boolean isEnabled() {
        return this.getRoomFactory().isPresent();
    }

    private RoomFactory getRoomFactoryOrThrow() {
        return this.getRoomFactory().orElseThrow(NoRoomFactoryRegisteredException::new);
    }

    private synchronized Optional<RoomFactory> getRoomFactory() {
        if (this.roomFactory == null) {
            this.roomFactory = PluginManager.getInstance().getPlugins().stream().flatMap(plugin -> plugin.getDescriptor().getExtensions(ROOM_EXTENSION_TYPE).stream()).findFirst().map(RoomsManager::getRoomFactory);
            if (this.roomFactory.isPresent()) {
                for (String string : SHARED_CONTEXT_ATTRIBUTES) {
                    this.roomFactory.get().addCommonEditingContextAttribute(string);
                }
            }
        }
        return this.roomFactory;
    }

    private static RoomFactory getRoomFactory(PluginDescriptor.PluginExtensionDescription pluginExtensionDescription) {
        return (RoomFactory)((Object)pluginExtensionDescription.getPluginExtension());
    }

    private static void checkLicense() {
        RoomsManager.getCurrentLicenseInformation().map(h::y).ifPresent(list -> {
            if (!list.contains("Conc")) {
                throw new PluginLicensingException("Your current license key does not cover the concurrent editing functionality.");
            }
        });
    }

    private static Optional<h> getCurrentLicenseInformation() {
        return Optional.ofNullable(c.n()).flatMap(c2 -> Optional.ofNullable(c2.i()));
    }

    public void addRoomCreatedListener(RoomCreatedListener roomCreatedListener) {
        this.roomCreatedListeners.add(roomCreatedListener);
    }

    public void removeRoomCreatedListener(RoomCreatedListener roomCreatedListener) {
        this.roomCreatedListeners.remove(roomCreatedListener);
    }

    private void callRoomCreatedListeners(String string) {
        this.roomCreatedListeners.forEach(roomCreatedListener -> {
            try {
                roomCreatedListener.roomCreated(string);
            }
            catch (Throwable throwable) {
                logger.warn("Error calling 'room created' listener for room " + string, throwable);
            }
        });
    }

    private static class NoRoomFactoryRegisteredException
    extends RuntimeException {
        private static final long serialVersionUID = -9211819699526881571L;

        public NoRoomFactoryRegisteredException() {
            super("The Web Author Concurrent Editing Plugin is not available.");
        }
    }
}

