/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.component;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.component.AuthorComponentException;
import ro.sync.ecss.extensions.api.component.EditorComponentProvider;
import ro.sync.ecss.extensions.api.component.EditorPageComponentsValidator;
import ro.sync.ecss.extensions.api.component.GenericEditorComponentProvider;
import ro.sync.ecss.extensions.api.component.InternalComponentProvider;
import ro.sync.ecss.extensions.api.component.KeyGenerator;
import ro.sync.ecss.extensions.api.component.SystemPropertiesLicenseUtil;
import ro.sync.ecss.extensions.api.component.listeners.OpenURLHandler;
import ro.sync.exml.cd;
import ro.sync.exml.editor.rc;
import ro.sync.exml.options.Options;
import ro.sync.exml.workspace.b.i.j;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class EditorComponentFactory {
    private static EditorComponentFactory instance;
    private boolean initialized = false;
    private j editorManager;
    private KeyGenerator keyGenerator;

    public static EditorComponentFactory getInstance() {
        if (instance == null) {
            instance = new EditorComponentFactory();
        }
        return instance;
    }

    public void dispose() {
        if (this.editorManager != null) {
            this.editorManager.vlj();
        }
        instance = null;
    }

    public void setObjectProperty(String string, Object object) {
        Options.getInstance().setUntypedObjectProperty(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorComponentProvider createEditorComponentProvider(String[] stringArray, String string, String string2) throws AuthorComponentException {
        this.createEditorManager();
        try {
            cd.p(() -> new EditorPageComponentsValidator(stringArray));
            GenericEditorComponentProvider genericEditorComponentProvider = new GenericEditorComponentProvider(this.editorManager, null, stringArray, string, string2);
            this.editorManager.ylj(genericEditorComponentProvider);
            GenericEditorComponentProvider genericEditorComponentProvider2 = genericEditorComponentProvider;
            return genericEditorComponentProvider2;
        }
        finally {
            cd.p(null);
        }
    }

    public PublicKey getPublicKey() throws AuthorComponentException {
        this.keyGenerator = new KeyGenerator();
        return this.keyGenerator.getPublicKey();
    }

    private void createEditorManager() throws AuthorComponentException {
        if (!this.initialized) {
            if (SystemPropertiesLicenseUtil.checkExternalLicense(this.keyGenerator)) {
                this.editorManager = new j();
                this.initialized = true;
            } else {
                throw new AuthorComponentException("Editor Component Factory not initialized.");
            }
        }
    }

    public void disposeEditorComponentProvider(EditorComponentProvider editorComponentProvider) {
        if (this.editorManager != null) {
            this.editorManager.slj((InternalComponentProvider)((Object)editorComponentProvider));
        }
    }

    public void setOpenURLHandler(OpenURLHandler openURLHandler) {
        this.editorManager.ulj(openURLHandler);
    }

    public void goToReference(URL uRL) throws MalformedURLException {
        rc rc2;
        URLInfo uRLInfo = URLUtil.getURLInfo((URL)uRL);
        if (uRLInfo.getReference() != null && (rc2 = this.editorManager.getEditorForURL(uRL)) != null && rc2.c()) {
            rc2.j(false).goToReference(uRLInfo.getReference());
        }
    }
}

