/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.component;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.Descriptor;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.component.AuthorComponentException;
import ro.sync.ecss.extensions.api.component.EditorComponentProvider;
import ro.sync.ecss.extensions.api.component.InternalComponentProvider;
import ro.sync.ecss.extensions.api.component.listeners.AuthorComponentListener;
import ro.sync.ecss.persistance.AuthorExtensionPO;
import ro.sync.ecss.persistance.CSSDescriptorPO;
import ro.sync.exml.editor.dd;
import ro.sync.exml.editor.df;
import ro.sync.exml.editor.ff;
import ro.sync.exml.editor.pb;
import ro.sync.exml.editor.persistance.DocumentTypePO;
import ro.sync.exml.editor.rc;
import ro.sync.exml.editor.s.j;
import ro.sync.exml.editor.xmleditor.ic;
import ro.sync.exml.editor.xmleditor.pageauthor.q;
import ro.sync.exml.editor.xmleditor.qb;
import ro.sync.exml.editor.y;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.author.DisplayModeConstants;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.listeners.WSEditorPageChangedListener;
import ro.sync.exml.workspace.b.d.f;
import ro.sync.exml.workspace.b.f.c;
import ro.sync.exml.workspace.b.i.b;
import ro.sync.i18n.r;
import ro.sync.ui.application.action.d;
import ro.sync.ui.bf;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
public abstract class AbstractComponentProvider
extends InternalComponentProvider
implements DisplayModeConstants,
EditorComponentProvider {
    protected static final Logger logger = LoggerFactory.getLogger((String)AbstractComponentProvider.class.getName());
    protected static final ro.sync.i18n.c messages = r.m();
    final List<AuthorComponentListener> authorComponentListeners = new ArrayList<AuthorComponentListener>();
    private final dd editor;
    private j statusPanel;
    protected boolean detectionFinished = false;
    private WSEditor editorAccess;
    private static int untitledFilesCounter = 0;

    public void save() {
        this.getWSEditorAccess().save();
    }

    @Override
    public void load(URL uRL, Reader reader) throws AuthorComponentException {
        Object object;
        if (uRL != null && (object = this.editor.getEditorManager().getEditorForURL(uRL)) != null && this.editor != ((rc)object).j(false)) {
            throw new AuthorComponentException("Multiple component provider instances cannot be created over the same URL.\nAnother component provider has already been created for this URL.\nPlease dispose a component provider which is not necessary anymote using AuthorComponentFactory.disposeEditorComponentProvider().");
        }
        object = this.editor.getEditorLocation();
        try {
            LinkedHashMap linkedHashMap;
            this.detectionFinished = false;
            this.editor.getDocumentTypeProvider().kgd(new qb(){

                @Override
                public void detectionTaskFinished() {
                    AbstractComponentProvider.this.detectionFinished = true;
                }
            });
            String string = null;
            if (reader == null && uRL != null) {
                URLInfo uRLInfo = URLUtil.getURLInfo((URL)uRL);
                string = uRLInfo.getReference();
                if (this.statusPanel != null) {
                    this.statusPanel.m(true);
                }
                if ((linkedHashMap = uRLInfo.getCustomQueryParameters()) != null) {
                    this.editor.setCustomQueryParams(linkedHashMap);
                }
                this.editor.open(uRLInfo.getURL(true, false, true));
                this.editor.requestFocusInEditor();
            } else if (reader != null) {
                boolean bl;
                if (uRL != null) {
                    URLInfo uRLInfo = URLUtil.getURLInfo((URL)uRL);
                    string = uRLInfo.getReference();
                    linkedHashMap = uRLInfo.getCustomQueryParameters();
                    if (linkedHashMap != null) {
                        this.editor.setCustomQueryParams(linkedHashMap);
                    }
                    uRL = uRLInfo.getURL(true, false, true);
                }
                if (this.statusPanel != null) {
                    this.statusPanel.m(false);
                }
                boolean bl2 = bl = uRL != null;
                if (uRL == null) {
                    uRL = URLUtil.correct((File)new File(messages.getString("Untitled") + ++untitledFilesCounter + ".xml"));
                }
                this.editor.reloadFromReader(reader, uRL);
                if (bl) {
                    this.editor.setFileEverSaved(true);
                }
                this.editor.requestFocusInEditor();
            } else {
                throw new AuthorComponentException("Both URL and Reader are NULL");
            }
            if (string != null) {
                this.editor.goToReference(string);
            }
            bf.l(new Runnable(){
                final /* synthetic */ URL val$oldURL;
                {
                    this.val$oldURL = uRL;
                }

                @Override
                public void run() {
                    AbstractComponentProvider.this.editor.getEditorManager().fireEditorRelocated(new rc(AbstractComponentProvider.this.editor), this.val$oldURL);
                }
            });
            for (int i2 = 0; i2 < this.authorComponentListeners.size(); ++i2) {
                this.authorComponentListeners.get(i2).loadedDocumentChanged();
            }
        }
        catch (Exception exception) {
            throw new AuthorComponentException(exception);
        }
    }

    @Override
    public void showLocation(URL uRL, Reader reader) throws AuthorComponentException {
        try {
            URL uRL2;
            URL uRL3 = this.editor.getEditorLocation();
            boolean bl = false;
            if (uRL3 != null) {
                uRL2 = URLUtil.correct((URL)uRL);
                String string = URLUtil.getEditorLocationKey((URL)(uRL2 = URLUtil.getCanonicalURL((URL)uRL2)), (boolean)false);
                bl = !Equaler.verifyEquals((Object)string, (Object)URLUtil.getEditorLocationKey((URL)uRL3, (boolean)false));
            } else {
                bl = true;
            }
            if (bl) {
                this.load(uRL, reader);
            } else {
                uRL2 = URLUtil.getURLInfo((URL)uRL);
                if (uRL2.getReference() != null) {
                    this.editor.goToReference(uRL2.getReference());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AuthorComponentException(exception);
        }
    }

    AbstractComponentProvider(ro.sync.exml.workspace.b.i.j j2, Frame frame, String[] stringArray, String string) throws AuthorComponentException {
        this(j2, frame, stringArray, string, null);
    }

    AbstractComponentProvider(ro.sync.exml.workspace.b.i.j j2, Frame frame, String[] stringArray, String string, String string2) throws AuthorComponentException {
        if (logger.isDebugEnabled()) {
            logger.debug("Create author component");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("There are no allowed pages specified in the component");
        }
        this.editor = this.createEditor(j2, frame, stringArray, string, string2);
        if (string != null) {
            this.editor.setInitialPage(new df(string, true));
        }
        this.editor.initFrame();
        this.editor.setEnableSetBoundsInEditor(true);
        try {
            this.editor.setLoadedURL(URLUtil.correct((File)new File(messages.getString("Untitled") + ".xml")));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (stringArray.length == 1) {
            this.editor.setShowPagesSwitch(false);
        }
        this.editor.addEditorListener(new y(){

            @Override
            public void modifiedStateChanged(Descriptor descriptor) {
                for (int i2 = 0; i2 < AbstractComponentProvider.this.authorComponentListeners.size(); ++i2) {
                    AbstractComponentProvider.this.authorComponentListeners.get(i2).modifiedStateChanged(AbstractComponentProvider.this.isModified());
                }
            }

            @Override
            public void editorPageChanged(pb pb2) {
            }

            @Override
            public void editorClosed(dd dd2) {
                if (AbstractComponentProvider.this.statusPanel != null) {
                    AbstractComponentProvider.this.statusPanel.l();
                }
            }
        });
        this.editorAccess = new c(this.editor, this.editor, null);
        this.editor.getDocumentTypeProvider().lfd(new ic(){

            @Override
            public void documentTypeChanged(DocumentTypePO documentTypePO, ExtensionsBundle extensionsBundle, long l2) {
                for (int i2 = 0; i2 < AbstractComponentProvider.this.authorComponentListeners.size(); ++i2) {
                    AbstractComponentProvider.this.authorComponentListeners.get(i2).documentTypeChanged();
                }
            }

            @Override
            public void cssChanged(CSSDescriptorPO[] cSSDescriptorPOArray, long l2, boolean bl) {
                for (int i2 = 0; i2 < AbstractComponentProvider.this.authorComponentListeners.size(); ++i2) {
                    AbstractComponentProvider.this.authorComponentListeners.get(i2).documentTypeChanged();
                }
            }

            @Override
            public void authorExtensionChanged(AuthorExtensionPO authorExtensionPO, ExtensionsBundle extensionsBundle, DocumentTypePO documentTypePO, long l2) {
                for (int i2 = 0; i2 < AbstractComponentProvider.this.authorComponentListeners.size(); ++i2) {
                    AbstractComponentProvider.this.authorComponentListeners.get(i2).documentTypeChanged();
                }
            }
        });
        this.addActionsToActionMap();
        this.editorAccess.addPageChangedListener(new WSEditorPageChangedListener(){

            @Override
            public void editorPageChanged() {
                AbstractComponentProvider.this.addActionsToActionMap();
            }
        });
        ff ff2 = new ff();
        ff2.jwq(new b(this.editor));
        this.editor.addDropHandler(ff2);
        this.editor.editorSelected(true, false);
    }

    protected abstract dd createEditor(ro.sync.exml.workspace.b.i.j var1, Frame var2, String[] var3, String var4, String var5) throws AuthorComponentException;

    private void addActionsToActionMap() {
        Map<String, Object> map = null;
        if ("Author".equals(this.editorAccess.getCurrentPageID())) {
            map = ((WSAuthorEditorPage)this.getWSEditorAccess().getCurrentPage()).getActionsProvider().getAuthorCommonActions();
        } else if ("Text".equals(this.editorAccess.getCurrentPageID())) {
            map = ((WSTextEditorPage)this.getWSEditorAccess().getCurrentPage()).getActionsProvider().getTextActions();
        }
        if (map != null) {
            for (Action action : map.values()) {
                if (!(action instanceof d)) continue;
                if ("Author".equals(this.editorAccess.getCurrentPageID())) {
                    ((d)action).wue(this.getAuthorPage().getSwingComponent());
                    continue;
                }
                ((d)action).wue((JComponent)((WSTextEditorPage)this.getWSEditorAccess().getCurrentPage()).getTextComponent());
            }
        }
    }

    public Reader createReader() {
        return this.editor.createReader();
    }

    @Override
    public void addAuthorComponentListener(AuthorComponentListener authorComponentListener) {
        if (!this.authorComponentListeners.contains(authorComponentListener)) {
            this.authorComponentListeners.add(authorComponentListener);
        }
    }

    @Override
    public void removeAuthorComponentListener(AuthorComponentListener authorComponentListener) {
        this.authorComponentListeners.remove(authorComponentListener);
    }

    @Override
    public Component getEditorComponent() {
        return this.editor.getComponent();
    }

    @Override
    public Component getStatusComponent() {
        if (this.statusPanel == null) {
            this.statusPanel = new j(true, true);
            this.editor.getStatusModel().k(this.statusPanel);
        }
        return this.statusPanel;
    }

    public boolean isModified() {
        return this.getWSEditorAccess().isModified();
    }

    public void setModified(boolean bl) {
        this.getWSEditorAccess().setModified(bl);
    }

    @Override
    public WSEditor getWSEditorAccess() {
        return this.editorAccess;
    }

    @Override
    public Object getEditorKey() {
        return this.editor;
    }

    q getAuthorPage() {
        return (q)this.editor.getEditorPage("Author");
    }

    @Override
    public JComponent getAdditionalEditHelper(int n2) {
        return new f(this.editor, n2);
    }

    @Override
    public void print(boolean bl) {
        this.editor.print(bl);
    }

    public void showLocation(URL uRL) throws AuthorComponentException {
        this.showLocation(uRL, null);
    }
}

